/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.Arrays;
import us.ihmc.robotics.dataStructures.ObsoletePolynomial;
import us.ihmc.robotics.linearDynamicSystems.ComplexConjugateMode;
import us.ihmc.robotics.linearDynamicSystems.EigenvalueDecomposer;
import us.ihmc.robotics.linearDynamicSystems.PolynomialMatrix;
import us.ihmc.robotics.linearDynamicSystems.SingleRealMode;
import us.ihmc.robotics.linearDynamicSystems.TransferFunctionMatrix;

public class LinearDynamicSystem {
    private final Matrix matrixA;
    private Matrix matrixB;
    private Matrix matrixC;
    private Matrix matrixD;
    private final TransferFunctionMatrix sIMinusAInverse;

    public LinearDynamicSystem(Matrix matrixA, Matrix matrixB, Matrix matrixC, Matrix matrixD) {
        if (matrixA == null) {
            throw new RuntimeException("matrixA must be defined. B,C,D can be null");
        }
        int order = matrixA.getRowDimension();
        if (matrixA.getColumnDimension() != order) {
            throw new RuntimeException("matrixA must be square!");
        }
        this.matrixA = new Matrix(matrixA.getArrayCopy());
        this.setMatrixB(matrixB);
        this.setMatrixC(matrixC);
        this.setMatrixD(matrixD);
        this.sIMinusAInverse = this.computeSIMinusAInverse();
    }

    public Matrix getMatrixA() {
        return new Matrix(this.matrixA.getArrayCopy());
    }

    public Matrix getMatrixB() {
        return new Matrix(this.matrixB.getArrayCopy());
    }

    public Matrix getMatrixC() {
        return new Matrix(this.matrixC.getArrayCopy());
    }

    public Matrix getMatrixD() {
        return new Matrix(this.matrixD.getArrayCopy());
    }

    public LinearDynamicSystem addFullStateFeedback(Matrix matrixK) {
        if (this.matrixB == null) {
            throw new RuntimeException("Matrix B must not be null for addFullStateFeedback!");
        }
        Matrix newMatrixA = this.matrixA.plus(this.matrixB.times(matrixK.times(-1.0)));
        Matrix newMatrixB = this.matrixB.copy();
        Matrix newMatrixC = null;
        Matrix newMatrixD = null;
        if (this.matrixC != null) {
            newMatrixC = this.matrixC;
            if (this.matrixD != null) {
                newMatrixC = this.matrixC.plus(this.matrixD.times(matrixK.times(-1.0)));
                newMatrixD = this.matrixD.copy();
            }
        }
        return new LinearDynamicSystem(newMatrixA, newMatrixB, newMatrixC, newMatrixD);
    }

    public LinearDynamicSystem addOutputStateFeedback(Matrix matrixK) {
        return this.addOutputStateFeedback(matrixK, null);
    }

    public LinearDynamicSystem addOutputStateFeedback(Matrix matrixK, Matrix matrixFF) {
        if (this.matrixB == null) {
            throw new RuntimeException("Matrix B must not be null for addOutputStateFeedback!");
        }
        if (this.matrixD != null) {
            throw new RuntimeException("Matrix D must be null for addOutputStateFeedback!");
        }
        if (this.matrixC == null) {
            throw new RuntimeException("Matrix C must not be null for addOutputStateFeedback!");
        }
        Matrix newMatrixA = this.matrixA.plus(this.matrixB.times(matrixK.times(-1.0)).times(this.matrixC));
        Matrix newMatrixB = this.matrixB.copy();
        Matrix newMatrixC = this.matrixC.copy();
        if (matrixFF != null) {
            newMatrixB = newMatrixB.times(matrixFF);
        }
        return new LinearDynamicSystem(newMatrixA, newMatrixB, newMatrixC, null);
    }

    public TransferFunctionMatrix getTransferFunctionMatrix() {
        TransferFunctionMatrix ret = this.sIMinusAInverse;
        if (this.matrixC != null) {
            ret = ret.preMultiply(this.matrixC);
        }
        if (this.matrixB != null) {
            ret = ret.times(this.matrixB);
        }
        if (this.matrixD != null) {
            ret = ret.plus(this.matrixD);
        }
        return ret;
    }

    public int getOrder() {
        return this.matrixA.getRowDimension();
    }

    public int getInputSize() {
        return this.matrixB.getColumnDimension();
    }

    public int getOutputSize() {
        return this.matrixC.getRowDimension();
    }

    public void setMatrixB(Matrix matrixB) {
        if (matrixB != null) {
            this.matrixB = new Matrix(matrixB.getArrayCopy());
        }
    }

    public void setMatrixC(Matrix matrixC) {
        if (matrixC != null) {
            this.matrixC = new Matrix(matrixC.getArrayCopy());
        }
    }

    public void setMatrixD(Matrix matrixD) {
        if (matrixD != null) {
            this.matrixD = new Matrix(matrixD.getArrayCopy());
        }
    }

    private TransferFunctionMatrix computeSIMinusAInverse() {
        return this.computeSIMinusAInverseUsingCofactors();
    }

    private TransferFunctionMatrix computeSIMinusAInverseUsingCofactors() {
        int order = this.matrixA.getColumnDimension();
        PolynomialMatrix sIMinusA = PolynomialMatrix.constructSIMinusA(this.matrixA);
        ObsoletePolynomial characteristicEquation = sIMinusA.computeDeterminant();
        ObsoletePolynomial[][] numerators = new ObsoletePolynomial[order][order];
        for (int i = 0; i < order; ++i) {
            for (int j = 0; j < order; ++j) {
                numerators[j][i] = sIMinusA.computeCofactor(i, j);
            }
        }
        return new TransferFunctionMatrix(numerators, characteristicEquation);
    }

    private TransferFunctionMatrix computeSIMinusAInverseUsingEigenvalueDecomposition() {
        EigenvalueDecomposer eigenvalueDecomposer = new EigenvalueDecomposer(this.matrixA);
        ArrayList<SingleRealMode> realModes = eigenvalueDecomposer.getRealModes();
        ArrayList<ComplexConjugateMode> complexConjugateModes = eigenvalueDecomposer.getComplexConjugateModes();
        TransferFunctionMatrix ret = null;
        for (SingleRealMode realMode : realModes) {
            TransferFunctionMatrix realModeMatrix = realMode.constructTransferFunctionMatrix();
            if (ret == null) {
                ret = realModeMatrix;
                continue;
            }
            ret = ret.plus(realModeMatrix);
        }
        for (ComplexConjugateMode complexConjugateMode : complexConjugateModes) {
            TransferFunctionMatrix complexConjugateModeMatrix = complexConjugateMode.constructTransferFunctionMatrix();
            if (ret == null) {
                ret = complexConjugateModeMatrix;
                continue;
            }
            ret = ret.plus(complexConjugateModeMatrix);
        }
        return ret;
    }

    public double[] eulerIntegrateOneStep(double[] currentState, double[] input, double stepSize) {
        Matrix currentStateMatrix = new Matrix(currentState, currentState.length);
        Matrix inputMatrix = new Matrix(input, input.length);
        Matrix nextStateMatrix = this.eulerIntegrateOneStep(currentStateMatrix, inputMatrix, stepSize);
        double[] nextState = new double[currentState.length];
        this.copyArray(nextStateMatrix, nextState);
        return nextState;
    }

    public Matrix eulerIntegrateOneStep(Matrix currentState, Matrix input, double stepSize) {
        Matrix nextState = currentState.copy();
        Matrix aTimesX = this.matrixA.times(currentState);
        Matrix bTimesU = this.matrixB.times(input);
        Matrix aTimesXPlusBTimesU = aTimesX.plus(bTimesU);
        Matrix aTimesXPlusBTimesUTimesStepSize = aTimesXPlusBTimesU.times(stepSize);
        nextState = nextState.plus(aTimesXPlusBTimesUTimesStepSize);
        return nextState;
    }

    public Matrix getOutputFromState(Matrix state, Matrix input) {
        Matrix cTimesX = this.matrixC.times(state);
        Matrix dTimesU = this.matrixD.times(input);
        Matrix output = cTimesX.plus(dTimesU);
        return output;
    }

    public double[] getOutputFromState(double[] state, double[] input) {
        Matrix stateMatrix = new Matrix(state, state.length);
        Matrix inputMatrix = new Matrix(input, input.length);
        Matrix outputMatrix = this.getOutputFromState(stateMatrix, inputMatrix);
        double[] output = new double[outputMatrix.getRowDimension()];
        this.copyArray(outputMatrix, output);
        return output;
    }

    public double[][] simulateInitialConditions(double[] initialConditions, double stepSize, int numTicks) {
        int order = this.matrixA.getRowDimension();
        if (initialConditions.length != order) {
            throw new RuntimeException("initialConditions.length != order");
        }
        double[][] ret = new double[numTicks][order];
        Matrix state = new Matrix(order, 1);
        this.copyArray(initialConditions, state);
        for (int i = 0; i < numTicks; ++i) {
            this.copyArray(state, ret[i]);
            Matrix aTimesX = this.matrixA.times(state);
            Matrix aTimesXTimesStepSize = aTimesX.times(stepSize);
            state = state.plus(aTimesXTimesStepSize);
        }
        return ret;
    }

    private void copyArray(double[] in, double[] out) {
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
    }

    private void copyArray(Matrix vectorIn, double[] out) {
        for (int i = 0; i < vectorIn.getRowDimension(); ++i) {
            out[i] = vectorIn.get(i, 0);
        }
    }

    private void copyArray(double[] in, Matrix vectorOut) {
        for (int i = 0; i < vectorOut.getRowDimension(); ++i) {
            vectorOut.set(i, 0, in[i]);
        }
    }

    public String toString() {
        return "A = " + Arrays.deepToString((Object[])this.matrixA.getArray()) + "\nB = " + Arrays.deepToString((Object[])this.matrixB.getArray()) + "\nC = " + Arrays.deepToString((Object[])this.matrixC.getArray()) + "\nD = " + Arrays.deepToString((Object[])this.matrixD.getArray());
    }
}

