/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra.cdreSolvers;

import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.robotics.linearAlgebra.careSolvers.CARETools;
import us.ihmc.robotics.linearAlgebra.cdreSolvers.AbstractCDRESolver;

public class NumericCDRESolver
extends AbstractCDRESolver {
    private static final double defaultDt = 1.0E-4;
    private final double dt;
    private double finalTime;
    private final DMatrixRMaj PFinal = new DMatrixRMaj(0, 0);
    private final RecyclingArrayList<DMatrixRMaj> PTrajectory = new RecyclingArrayList(() -> new DMatrixRMaj(0, 0));
    private final DMatrixRMaj PDot = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj PToReturn = new DMatrixRMaj(0, 0);

    public NumericCDRESolver() {
        this(1.0E-4);
    }

    public NumericCDRESolver(double dt) {
        this.dt = dt;
    }

    @Override
    public void setFinalBoundaryCondition(double finalTime, DMatrixRMaj PFinal) {
        this.PFinal.set((DMatrixD1)PFinal);
        this.finalTime = finalTime;
        this.PTrajectory.clear();
    }

    @Override
    public void computePFunction(double initialTime) {
        double time = this.finalTime;
        DMatrixRMaj lastP = (DMatrixRMaj)this.PTrajectory.add();
        lastP.set((DMatrixD1)this.PFinal);
        time -= this.dt;
        this.PDot.reshape(this.PFinal.numRows, this.PFinal.numCols);
        while (time >= initialTime) {
            CARETools.computeRiccatiRate(lastP, this.A, this.Q, this.M, this.PDot);
            DMatrixRMaj nextP = (DMatrixRMaj)this.PTrajectory.add();
            nextP.set((DMatrixD1)lastP);
            CommonOps_DDRM.addEquals((DMatrixD1)nextP, (double)(-this.dt), (DMatrixD1)this.PDot);
            lastP = nextP;
            time -= this.dt;
        }
    }

    @Override
    public DMatrixRMaj getP(double time) {
        int index = (int)Math.floor(time / this.dt);
        index = MathTools.clamp((int)index, (int)0, (int)(this.PTrajectory.size() - 2));
        double interpolationFraction = (time - (double)index * this.dt) / this.dt;
        int reverseTimeTrajectoryIndex = this.PTrajectory.size() - 1 - index;
        this.PToReturn.set((DMatrixD1)this.PTrajectory.get(reverseTimeTrajectoryIndex));
        CommonOps_DDRM.scale((double)(1.0 - interpolationFraction), (DMatrixD1)this.PToReturn);
        CommonOps_DDRM.addEquals((DMatrixD1)this.PToReturn, (double)interpolationFraction, (DMatrixD1)((DMatrixD1)this.PTrajectory.get(reverseTimeTrajectoryIndex - 1)));
        return this.PToReturn;
    }
}

