/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra.careSolvers;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.linearAlgebra.careSolvers.MatrixChecking;

public class LyapunovEquationSolver {
    private final DMatrixRMaj A = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj aTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj Q = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj tempMatrix = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj qVector = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj xVector = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj X = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj X1 = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj eyeX = new DMatrixRMaj(0, 0);
    private final LinearSolverDense<DMatrixRMaj> solver = LinearSolverFactory_DDRM.lu((int)0);
    private int n;
    private boolean isUpToDate = false;

    public void setMatrices(DMatrixRMaj A, DMatrixRMaj Q) {
        this.isUpToDate = false;
        MatrixChecking.assertIsSquare(A);
        MatrixChecking.assertIsSquare(Q);
        this.A.set((DMatrixD1)A);
        this.Q.set((DMatrixD1)Q);
        this.n = this.A.getNumRows();
    }

    public DMatrixRMaj solve() {
        this.aTranspose.reshape(this.n, this.n);
        this.eyeX.reshape(this.n, this.n);
        this.X1.reshape(this.n * this.n, this.n * this.n);
        this.tempMatrix.reshape(this.n * this.n, this.n * this.n);
        CommonOps_DDRM.transpose((DMatrixRMaj)this.A, (DMatrixRMaj)this.aTranspose);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.eyeX);
        CommonOps_DDRM.kron((DMatrixRMaj)this.aTranspose, (DMatrixRMaj)this.eyeX, (DMatrixRMaj)this.X1);
        CommonOps_DDRM.kron((DMatrixRMaj)this.eyeX, (DMatrixRMaj)this.aTranspose, (DMatrixRMaj)this.tempMatrix);
        CommonOps_DDRM.addEquals((DMatrixD1)this.X1, (DMatrixD1)this.tempMatrix);
        LyapunovEquationSolver.stack(this.Q, this.qVector);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.qVector);
        this.xVector.reshape(this.X1.getNumRows(), 1);
        this.solver.setA((Matrix)this.X1);
        this.solver.solve((Matrix)this.qVector, (Matrix)this.xVector);
        LyapunovEquationSolver.toSquareMatrix(this.xVector, this.X);
        this.isUpToDate = true;
        return this.X;
    }

    public DMatrixRMaj getX() {
        return this.isUpToDate ? this.X : this.solve();
    }

    private static void stack(DMatrixRMaj QMatrix, DMatrixRMaj qVector) {
        int rows = QMatrix.getNumRows();
        qVector.reshape(rows * rows, 1);
        for (int i = 0; i < rows; ++i) {
            MatrixTools.setMatrixBlock((DMatrix)qVector, (int)(i * rows), (int)0, (DMatrix)QMatrix, (int)0, (int)i, (int)rows, (int)1, (double)1.0);
        }
    }

    private static void toSquareMatrix(DMatrixRMaj xVector, DMatrixRMaj xMatrix) {
        int rows = (int)Math.sqrt(xVector.getNumRows());
        xMatrix.reshape(rows, rows);
        for (int i = 0; i < rows; ++i) {
            MatrixTools.setMatrixBlock((DMatrix)xMatrix, (int)0, (int)i, (DMatrix)xVector, (int)(i * rows), (int)0, (int)rows, (int)1, (double)1.0);
        }
    }
}

