/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra.careSolvers;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.NativeCommonOps;
import us.ihmc.robotics.linearAlgebra.careSolvers.AbstractCARESolver;
import us.ihmc.robotics.linearAlgebra.careSolvers.CARESolver;
import us.ihmc.robotics.linearAlgebra.careSolvers.MatrixToolsLocal;

public class DefectCorrectionCARESolver
extends AbstractCARESolver {
    private static final int defaultMaxIterations = 1000;
    private final int maxIterations;
    private static final double defaultConvergenceEpsilon = 1.0E-12;
    private final double convergenceEpsilon;
    private final DMatrixRMaj X = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj PE = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj ASquiggle = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj QSquiggle = new DMatrixRMaj(0, 0);
    private final CARESolver backendSolver;

    public DefectCorrectionCARESolver(CARESolver backendSolver) {
        this.backendSolver = backendSolver;
        this.maxIterations = 1000;
        this.convergenceEpsilon = 1.0E-12;
    }

    @Override
    public DMatrixRMaj computeP() {
        this.backendSolver.setMatrices(this.A, this.hasE ? this.E : null, this.M, this.Q);
        this.P.set((DMatrixD1)this.backendSolver.getP());
        int iterations = 0;
        boolean converged = false;
        while (!converged) {
            this.X.set((DMatrixD1)this.computeErrorEstimate(this.P));
            CommonOps_DDRM.addEquals((DMatrixD1)this.P, (DMatrixD1)this.X);
            converged = MatrixToolsLocal.isZero(this.X, this.convergenceEpsilon);
            if (iterations > this.maxIterations) {
                throw new RuntimeException("Failed to converge.");
            }
            ++iterations;
        }
        this.isUpToDate = true;
        return this.P;
    }

    private DMatrixRMaj computeErrorEstimate(DMatrixRMaj currentValue) {
        this.PE.reshape(this.n, this.n);
        if (!this.hasE) {
            this.PE.set((DMatrixD1)currentValue);
        } else {
            CommonOps_DDRM.mult((DMatrix1Row)currentValue, (DMatrix1Row)this.E, (DMatrix1Row)this.PE);
        }
        NativeCommonOps.multQuad((DMatrix1Row)this.PE, (DMatrix1Row)this.M, (DMatrix1Row)this.QSquiggle);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.QSquiggle);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)this.PE, (DMatrix1Row)this.A, (DMatrix1Row)this.QSquiggle);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)this.A, (DMatrix1Row)this.PE, (DMatrix1Row)this.QSquiggle);
        CommonOps_DDRM.addEquals((DMatrixD1)this.QSquiggle, (DMatrixD1)this.Q);
        this.ASquiggle.set((DMatrixD1)this.A);
        CommonOps_DDRM.multAdd((double)-1.0, (DMatrix1Row)this.M, (DMatrix1Row)this.PE, (DMatrix1Row)this.ASquiggle);
        this.backendSolver.setMatrices(this.ASquiggle, this.hasE ? this.E : null, this.M, this.QSquiggle);
        return this.backendSolver.getP();
    }
}

