/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.decomposition.svd.SvdImplicitQrDecompose_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.linearAlgebra.IncrementalCovariance3D;

public class PrincipalComponentAnalysis3D {
    private static final boolean DEBUG = false;
    private final DMatrixRMaj W = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj V = new DMatrixRMaj(3, 3);
    private final Vector3D principalAxis = new Vector3D();
    private final Vector3D secondaryAxis = new Vector3D();
    private final Vector3D thirdAxis = new Vector3D();
    private final Vector3D variance = new Vector3D();
    private final IncrementalCovariance3D covarianceCalculator = new IncrementalCovariance3D();
    private final DMatrixRMaj covariance = new DMatrixRMaj(3, 3);
    private final SingularValueDecomposition_F64<DMatrixRMaj> svd = new SvdImplicitQrDecompose_DDRM(true, false, true, false);

    public void clear() {
        this.covarianceCalculator.clear();
    }

    public void addAllDataPoints(List<? extends Tuple3DReadOnly> tuples) {
        this.covarianceCalculator.addAllDataPoints(tuples);
    }

    public void addAllDataPoint(DMatrixRMaj dataPoints) {
        this.covarianceCalculator.addAllDataPoint(dataPoints);
    }

    public void addPoint(double x, double y, double z) {
        this.covarianceCalculator.addDataPoint(x, y, z);
    }

    public void addDataPoint(Tuple3DReadOnly tuple) {
        this.covarianceCalculator.addDataPoint(tuple);
    }

    public void setPointCloud(List<? extends Tuple3DBasics> pointCloud) {
        this.clear();
        this.covarianceCalculator.clear();
        this.covarianceCalculator.addAllDataPoints(pointCloud);
    }

    public void setPointCloud(DMatrixRMaj pointCloud) {
        this.covarianceCalculator.clear();
        this.covarianceCalculator.addAllDataPoint(pointCloud);
    }

    public void compute() {
        if (this.covarianceCalculator.getSampleSize() < 3) {
            this.principalAxis.set(Double.NaN, Double.NaN, Double.NaN);
            this.secondaryAxis.set(Double.NaN, Double.NaN, Double.NaN);
            this.thirdAxis.set(Double.NaN, Double.NaN, Double.NaN);
            this.variance.set(0.0, 0.0, 0.0);
            return;
        }
        this.covarianceCalculator.getCovariance(this.covariance);
        this.svd.decompose((Matrix)this.covariance);
        this.svd.getW((Matrix)this.W);
        this.svd.getV((Matrix)this.V, false);
        SingularOps_DDRM.descendingOrder(null, (boolean)false, (DMatrixRMaj)this.W, (DMatrixRMaj)this.V, (boolean)false);
        this.principalAxis.set(this.V.get(0, 0), this.V.get(1, 0), this.V.get(2, 0));
        this.secondaryAxis.set(this.V.get(0, 1), this.V.get(1, 1), this.V.get(2, 1));
        this.thirdAxis.cross((Tuple3DReadOnly)this.principalAxis, (Tuple3DReadOnly)this.secondaryAxis);
        this.variance.setX(this.W.get(0, 0));
        this.variance.setY(this.W.get(1, 1));
        this.variance.setZ(this.W.get(2, 2));
    }

    public void getMean(Point3D meanToPack) {
        this.covarianceCalculator.getMean((Tuple3DBasics)meanToPack);
    }

    public void getPrincipalFrameRotationMatrix(RotationMatrix rotationMatrixToPack) {
        rotationMatrixToPack.setColumns((Tuple3DReadOnly)this.principalAxis, (Tuple3DReadOnly)this.secondaryAxis, (Tuple3DReadOnly)this.thirdAxis);
    }

    public void getVariance(Vector3D principalVarianceToPack) {
        principalVarianceToPack.setX(this.variance.getX());
        principalVarianceToPack.setY(this.variance.getY());
        principalVarianceToPack.setZ(this.variance.getZ());
    }

    public void getStandardDeviation(Vector3D principalStandardDeviationToPack) {
        principalStandardDeviationToPack.setX(Math.sqrt(this.variance.getX()));
        principalStandardDeviationToPack.setY(Math.sqrt(this.variance.getY()));
        principalStandardDeviationToPack.setZ(Math.sqrt(this.variance.getZ()));
    }

    public void getPrincipalVectors(Vector3D principalAxisToPack, Vector3D secondaryAxisToPack, Vector3D thirdAxisToPack) {
        principalAxisToPack.set(this.principalAxis);
        secondaryAxisToPack.set(this.secondaryAxis);
        thirdAxisToPack.set(this.thirdAxis);
    }

    public void getPrincipalVector(Vector3D principalVectorToPack) {
        principalVectorToPack.set(this.principalAxis);
    }

    public void getSecondaryVector(Vector3D secondaryVectorToPack) {
        secondaryVectorToPack.set(this.secondaryAxis);
    }

    public void getThirdVector(Vector3D thirdVectorToPack) {
        thirdVectorToPack.set(this.thirdAxis);
    }

    public void getScaledPrincipalVectors(Vector3D principalVectorToPack, Vector3D secondaryVectorToPack, Vector3D thirdVectorToPack) {
        principalVectorToPack.set(this.principalAxis);
        principalVectorToPack.scale(this.variance.getX());
        secondaryVectorToPack.set(this.secondaryAxis);
        secondaryVectorToPack.scale(this.variance.getY());
        thirdVectorToPack.set(this.thirdAxis);
        thirdVectorToPack.scale(this.variance.getZ());
    }
}

