/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.MatrixTools;

public class MatrixOfCofactorsCalculatorInefficient {
    public static DMatrixRMaj computeMatrixOfCoFactors(DMatrixRMaj mat) {
        int m = mat.getNumRows();
        int n = mat.getNumCols();
        DMatrixRMaj ret = new DMatrixRMaj(m, n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                DMatrixRMaj minor = MatrixOfCofactorsCalculatorInefficient.computeMinor(mat, i, j);
                double minorDeterminant = CommonOps_DDRM.det((DMatrixRMaj)minor);
                int sign = MatrixOfCofactorsCalculatorInefficient.isEven(i + 1 + (j + 1)) ? 1 : -1;
                ret.set(i, j, (double)sign * minorDeterminant);
            }
        }
        return ret;
    }

    private static boolean isEven(int k) {
        return k % 2 == 0;
    }

    private static DMatrixRMaj computeMinor(DMatrixRMaj mat, int i, int j) {
        int m = mat.getNumRows();
        int n = mat.getNumCols();
        DMatrixRMaj ret = new DMatrixRMaj(m - 1, n - 1);
        int[] rows = MatrixOfCofactorsCalculatorInefficient.determineIndices(i, m);
        int[] columns = MatrixOfCofactorsCalculatorInefficient.determineIndices(j, n);
        MatrixTools.getMatrixBlock((DMatrix)ret, (DMatrix)mat, (int[])rows, (int[])columns);
        return ret;
    }

    private static int[] determineIndices(int indexToOmit, int size) {
        int[] rows = new int[size - 1];
        int k = 0;
        for (int index = 0; index < size; ++index) {
            if (index == indexToOmit) continue;
            rows[k++] = index;
        }
        return rows;
    }
}

