/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import java.util.List;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class IncrementalCovariance3D {
    private int sampleSize = 0;
    private final Point3D mean = new Point3D();
    private final DMatrixRMaj secondMoment = new DMatrixRMaj(3, 3);

    public void clear() {
        this.sampleSize = 0;
        this.mean.set(0.0, 0.0, 0.0);
        this.secondMoment.zero();
    }

    public void addAllDataPoints(List<? extends Tuple3DReadOnly> tuples) {
        for (int i = 0; i < tuples.size(); ++i) {
            this.addDataPoint(tuples.get(i));
        }
    }

    public void addAllDataPoint(DMatrixRMaj dataPoints) {
        if (dataPoints.getNumRows() == 3) {
            for (int col = 0; col < dataPoints.getNumCols(); ++col) {
                double x = dataPoints.get(0, col);
                double y = dataPoints.get(1, col);
                double z = dataPoints.get(2, col);
                this.addDataPoint(x, y, z);
            }
        } else if (dataPoints.getNumCols() == 3) {
            for (int row = 0; row < dataPoints.getNumRows(); ++row) {
                double x = dataPoints.get(row, 0);
                double y = dataPoints.get(row, 1);
                double z = dataPoints.get(row, 2);
                this.addDataPoint(x, y, z);
            }
        } else {
            throw new RuntimeException("Unexpected matrix size: [nRows = " + dataPoints.getNumRows() + ", nCols = " + dataPoints.getNumCols() + "]");
        }
    }

    public void addDataPoint(Tuple3DReadOnly tuple) {
        this.addDataPoint(tuple.getX(), tuple.getY(), tuple.getZ());
    }

    public void addDataPoint(double x, double y, double z) {
        ++this.sampleSize;
        double devX = x - this.mean.getX();
        double devY = y - this.mean.getY();
        double devZ = z - this.mean.getZ();
        double nInv = 1.0 / (double)this.sampleSize;
        this.mean.setX(this.mean.getX() + devX * nInv);
        this.mean.setY(this.mean.getY() + devY * nInv);
        this.mean.setZ(this.mean.getZ() + devZ * nInv);
        double m00 = devX * (x - this.mean.getX());
        double m11 = devY * (y - this.mean.getY());
        double m22 = devZ * (z - this.mean.getZ());
        double m01 = devX * (y - this.mean.getY());
        double m02 = devX * (z - this.mean.getZ());
        double m12 = devY * (z - this.mean.getZ());
        this.secondMoment.add(0, 0, m00);
        this.secondMoment.add(0, 1, m01);
        this.secondMoment.add(0, 2, m02);
        this.secondMoment.add(1, 0, m01);
        this.secondMoment.add(1, 1, m11);
        this.secondMoment.add(1, 2, m12);
        this.secondMoment.add(2, 0, m02);
        this.secondMoment.add(2, 1, m12);
        this.secondMoment.add(2, 2, m22);
    }

    public void getMean(Tuple3DBasics meanToPack) {
        meanToPack.set((Tuple3DReadOnly)this.mean);
    }

    public void getCovariance(DMatrixRMaj covarianceToPack) {
        double div = 1.0 / (double)this.sampleSize;
        covarianceToPack.set((DMatrixD1)this.secondMoment);
        CommonOps_DDRM.scale((double)div, (DMatrixD1)covarianceToPack);
    }

    public void getCovarianceCorrected(DMatrixRMaj covarianceToPack) {
        double div = 1.0 / ((double)this.sampleSize - 1.0);
        covarianceToPack.set((DMatrixD1)this.secondMoment);
        CommonOps_DDRM.scale((double)div, (DMatrixD1)covarianceToPack);
    }

    public int getSampleSize() {
        return this.sampleSize;
    }
}

