/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.commons.MathTools;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.linearAlgebra.DampedNullspaceCalculator;

public class DampedQRNullspaceCalculator
implements DampedNullspaceCalculator {
    private final QRDecomposition<DMatrixRMaj> decomposer;
    private final LinearSolverDense<DMatrixRMaj> linearSolver;
    private final DMatrixRMaj nullspace;
    private final DMatrixRMaj Q;
    private final DMatrixRMaj R1;
    private final DMatrixRMaj nullspaceProjector;
    private final DMatrixRMaj tempMatrixForProjectionInPlace;
    private double alpha = 0.0;
    private final DMatrixRMaj tempMatrix = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj squared = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj inverse = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj transposed = new DMatrixRMaj(0, 0);

    public DampedQRNullspaceCalculator(int matrixSize, double alpha) {
        this.alpha = alpha;
        MathTools.checkIntervalContains((long)matrixSize, (long)1L, (long)Integer.MAX_VALUE);
        this.nullspaceProjector = new DMatrixRMaj(matrixSize, matrixSize);
        this.tempMatrixForProjectionInPlace = new DMatrixRMaj(matrixSize, matrixSize);
        this.linearSolver = LinearSolverFactory_DDRM.symmPosDef((int)matrixSize);
        this.decomposer = DecompositionFactory_DDRM.qr((int)matrixSize, (int)matrixSize);
        this.nullspace = new DMatrixRMaj(matrixSize, matrixSize);
        this.Q = new DMatrixRMaj(matrixSize, matrixSize);
        this.R1 = new DMatrixRMaj(matrixSize, matrixSize);
    }

    @Override
    public void setPseudoInverseAlpha(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public void projectOntoNullspace(DMatrixRMaj matrixToProjectOntoNullspace, DMatrixRMaj matrixToComputeNullspaceOf) {
        this.tempMatrixForProjectionInPlace.set((DMatrixD1)matrixToProjectOntoNullspace);
        this.projectOntoNullspace(this.tempMatrixForProjectionInPlace, matrixToComputeNullspaceOf, matrixToProjectOntoNullspace);
    }

    @Override
    public void projectOntoNullspace(DMatrixRMaj matrixToProjectOntoNullspace, DMatrixRMaj matrixToComputeNullspaceOf, DMatrixRMaj projectedMatrixToPack) {
        this.computeNullspaceProjector(matrixToComputeNullspaceOf, this.nullspaceProjector);
        CommonOps_DDRM.mult((DMatrix1Row)matrixToProjectOntoNullspace, (DMatrix1Row)this.nullspaceProjector, (DMatrix1Row)projectedMatrixToPack);
    }

    @Override
    public void computeNullspaceProjector(DMatrixRMaj matrixToComputeNullspaceOf, DMatrixRMaj nullspaceProjectorToPack) {
        int nullity = Math.max(matrixToComputeNullspaceOf.getNumCols() - matrixToComputeNullspaceOf.getNumRows(), 0);
        nullspaceProjectorToPack.reshape(matrixToComputeNullspaceOf.getNumCols(), matrixToComputeNullspaceOf.getNumCols());
        if (this.alpha == 0.0) {
            this.computeNullspace(this.nullspace, matrixToComputeNullspaceOf, nullity);
            CommonOps_DDRM.multOuter((DMatrix1Row)this.nullspace, (DMatrix1Row)nullspaceProjectorToPack);
        } else {
            int size = matrixToComputeNullspaceOf.getNumCols();
            int vars = matrixToComputeNullspaceOf.getNumRows();
            int rank = Math.min(size, vars);
            this.transposed.reshape(size, vars);
            this.R1.reshape(rank, vars);
            this.squared.reshape(vars, vars);
            this.inverse.reshape(vars, vars);
            CommonOps_DDRM.transpose((DMatrixRMaj)matrixToComputeNullspaceOf, (DMatrixRMaj)this.transposed);
            this.decomposer.decompose((Matrix)this.transposed);
            this.decomposer.getR((Matrix)this.R1, true);
            if (this.R1.getNumCols() == this.R1.getNumRows()) {
                DampedQRNullspaceCalculator.inner_small_upper_diagonal((DMatrix1Row)this.R1, (DMatrix1Row)this.squared);
            } else {
                CommonOps_DDRM.multInner((DMatrix1Row)this.R1, (DMatrix1Row)this.squared);
            }
            MatrixTools.addDiagonal((DMatrix)this.squared, (double)(this.alpha * this.alpha));
            this.linearSolver.setA((Matrix)this.squared);
            this.linearSolver.invert((Matrix)this.inverse);
            this.tempMatrix.reshape(size, vars);
            CommonOps_DDRM.multTransA((DMatrix1Row)matrixToComputeNullspaceOf, (DMatrix1Row)this.inverse, (DMatrix1Row)this.tempMatrix);
            CommonOps_DDRM.mult((double)-1.0, (DMatrix1Row)this.tempMatrix, (DMatrix1Row)matrixToComputeNullspaceOf, (DMatrix1Row)nullspaceProjectorToPack);
            MatrixTools.addDiagonal((DMatrix)nullspaceProjectorToPack, (double)1.0);
        }
    }

    private void computeNullspace(DMatrixRMaj nullspaceToPack, DMatrixRMaj matrixToComputeNullspaceOf, int nullity) {
        int size = matrixToComputeNullspaceOf.getNumCols();
        int rank = matrixToComputeNullspaceOf.getNumRows();
        nullspaceToPack.reshape(size, nullity);
        this.Q.reshape(size, size);
        this.transposed.reshape(size, rank);
        CommonOps_DDRM.transpose((DMatrixRMaj)matrixToComputeNullspaceOf, (DMatrixRMaj)this.transposed);
        this.decomposer.decompose((Matrix)this.transposed);
        this.decomposer.getQ((Matrix)this.Q, false);
        CommonOps_DDRM.extract((DMatrix)this.Q, (int)0, (int)this.Q.getNumRows(), (int)(this.Q.getNumCols() - nullity), (int)this.Q.getNumCols(), (DMatrix)nullspaceToPack, (int)0, (int)0);
    }

    static void inner_small_upper_diagonal(DMatrix1Row a, DMatrix1Row c) {
        for (int transposeRowIndex = 0; transposeRowIndex < a.numCols; ++transposeRowIndex) {
            for (int colIndex = transposeRowIndex; colIndex < a.numCols; ++colIndex) {
                double sum = 0.0;
                int indexA = transposeRowIndex;
                int indexB = colIndex;
                int indexC1 = colIndex * a.numCols + transposeRowIndex;
                int indexC2 = transposeRowIndex * a.numCols + colIndex;
                int row = 0;
                while (row <= transposeRowIndex) {
                    sum += a.data[indexA] * a.data[indexB];
                    ++row;
                    indexA += a.numCols;
                    indexB += a.numCols;
                }
                c.data[indexC1] = c.data[indexC2] = sum;
            }
        }
    }
}

