/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.kinematics;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.kinematics.TimeStampedTransform3D;

public class TransformInterpolationCalculator {
    private final Vector3D transform1Translation = new Vector3D();
    private final Vector3D transform2Translation = new Vector3D();
    private final Quaternion transform1Quaternion = new Quaternion();
    private final Quaternion transform2Quaternion = new Quaternion();
    private final Vector3D interpolatedTranslation = new Vector3D();
    private final Quaternion interpolatedQuaternion = new Quaternion();

    public void computeInterpolation(RigidBodyTransform transform1, RigidBodyTransform transform2, RigidBodyTransform result, double alpha) {
        alpha = MathTools.clamp((double)alpha, (double)0.0, (double)1.0);
        transform1.get((Orientation3DBasics)this.transform1Quaternion, (Tuple3DBasics)this.transform1Translation);
        transform2.get((Orientation3DBasics)this.transform2Quaternion, (Tuple3DBasics)this.transform2Translation);
        this.interpolatedTranslation.interpolate((Tuple3DReadOnly)this.transform1Translation, (Tuple3DReadOnly)this.transform2Translation, alpha);
        this.interpolatedQuaternion.interpolate((QuaternionReadOnly)this.transform1Quaternion, (QuaternionReadOnly)this.transform2Quaternion, alpha);
        result.setRotationAndZeroTranslation((Orientation3DReadOnly)this.interpolatedQuaternion);
        result.getTranslation().set((Tuple3DReadOnly)this.interpolatedTranslation);
    }

    public void interpolate(TimeStampedTransform3D timeStampedTransform1, TimeStampedTransform3D timeStampedTransform2, TimeStampedTransform3D resultToPack, long timeStamp) {
        long timeStamp1 = timeStampedTransform1.getTimeStamp();
        long timeStamp2 = timeStampedTransform2.getTimeStamp();
        MathTools.checkIntervalContains((long)timeStamp, (long)timeStamp1, (long)timeStamp2);
        RigidBodyTransform transform1 = timeStampedTransform1.getTransform3D();
        RigidBodyTransform transform2 = timeStampedTransform2.getTransform3D();
        resultToPack.setTimeStamp(timeStamp);
        double alpha = (double)(timeStamp - timeStamp1) / (double)(timeStamp2 - timeStamp1);
        RigidBodyTransform interpolatedTransform = resultToPack.getTransform3D();
        this.computeInterpolation(transform1, transform2, interpolatedTransform, alpha);
    }
}

