/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.kinematics;

import java.util.LinkedHashMap;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.kinematics.InverseJacobianSolver;
import us.ihmc.robotics.kinematics.InverseKinematicsCalculator;
import us.ihmc.robotics.kinematics.InverseKinematicsStepListener;
import us.ihmc.robotics.screwTheory.GeometricJacobian;

public class NumericalInverseKinematicsCalculator
implements InverseKinematicsCalculator {
    private final InverseJacobianSolver inverseJacobianCalculator;
    private final OneDoFJointBasics[] oneDoFJoints;
    private final double tolerance;
    private final int maxIterations;
    private final double maxStepSize;
    private final Random random = new Random(1251253L);
    private int iterationNumber;
    private double errorScalar;
    private double minimumErrorScalar;
    private final RigidBodyTransform actualTransform = new RigidBodyTransform();
    private final RigidBodyTransform errorTransform = new RigidBodyTransform();
    private final AxisAngle errorAxisAngle = new AxisAngle();
    private final RotationMatrix errorRotationMatrix = new RotationMatrix();
    private final Vector3D errorRotationVector = new Vector3D();
    private final Vector3D axis = new Vector3D();
    private final Vector3D errorTranslationVector = new Vector3D();
    private final DMatrixRMaj spatialError = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj jointAnglesCorrection;
    private final DMatrixRMaj jointAnglesMinimumError;
    private final double minRandomSearchScalar;
    private final double maxRandomSearchScalar;
    private int numberOfConstraints;
    private final int numberOfDoF;
    private InverseKinematicsStepListener stepListener = null;
    private boolean limitJointAngles = true;
    private final GeometricJacobian jacobian;
    private final double lambdaLeastSquares;

    public static NumericalInverseKinematicsCalculator createIKCalculator(JointBasics[] jointsToControl, int maxIterations) {
        JointBasics[] cloneOfControlledJoints = MultiBodySystemFactories.cloneKinematicChain((JointReadOnly[])jointsToControl);
        int numberOfDoFs = cloneOfControlledJoints.length;
        RigidBodyBasics cloneOfEndEffector = cloneOfControlledJoints[numberOfDoFs - 1].getSuccessor();
        MovingReferenceFrame cloneOfEndEffectorFrame = cloneOfEndEffector.getBodyFixedFrame();
        GeometricJacobian jacobian = new GeometricJacobian(cloneOfControlledJoints, (ReferenceFrame)cloneOfEndEffectorFrame);
        double lambdaLeastSquares = 9.0E-4;
        double tolerance = 0.001;
        double maxStepSize = 0.2;
        double minRandomSearchScalar = 0.02;
        double maxRandomSearchScalar = 0.8;
        return new NumericalInverseKinematicsCalculator(jacobian, lambdaLeastSquares, tolerance, maxIterations, maxStepSize, minRandomSearchScalar, maxRandomSearchScalar);
    }

    public NumericalInverseKinematicsCalculator(GeometricJacobian jacobian, double lambdaLeastSquares, double tolerance, int maxIterations, double maxStepSize, double minRandomSearchScalar, double maxRandomSearchScalar) {
        if (jacobian.getJacobianFrame() != jacobian.getEndEffectorFrame()) {
            throw new RuntimeException("jacobian.getJacobianFrame() != jacobian.getEndEffectorFrame()");
        }
        this.jacobian = jacobian;
        this.numberOfConstraints = 6;
        this.numberOfDoF = jacobian.getNumberOfColumns();
        this.inverseJacobianCalculator = InverseJacobianSolver.createInverseJacobianSolver(this.numberOfConstraints, this.numberOfDoF, false);
        this.oneDoFJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])jacobian.getJointsInOrder(), OneDoFJointBasics.class);
        if (this.oneDoFJoints.length != jacobian.getJointsInOrder().length) {
            throw new RuntimeException("Can currently only handle OneDoFJoints");
        }
        this.jointAnglesCorrection = new DMatrixRMaj(this.numberOfDoF, 1);
        this.jointAnglesMinimumError = new DMatrixRMaj(this.numberOfDoF, 1);
        this.lambdaLeastSquares = lambdaLeastSquares;
        this.tolerance = tolerance;
        this.maxIterations = maxIterations;
        this.maxStepSize = maxStepSize;
        this.minRandomSearchScalar = minRandomSearchScalar;
        this.maxRandomSearchScalar = maxRandomSearchScalar;
    }

    @Override
    public void attachInverseKinematicsStepListener(InverseKinematicsStepListener stepListener) {
        this.stepListener = stepListener;
    }

    @Override
    public void setLimitJointAngles(boolean limitJointAngles) {
        this.limitJointAngles = limitJointAngles;
    }

    public void setSelectionMatrix(DMatrixRMaj selectionMatrix) {
        if (selectionMatrix.getNumCols() != 6) {
            throw new RuntimeException("The selection matrix must have 6 columns, the argument has: " + selectionMatrix.getNumCols());
        }
        this.inverseJacobianCalculator.setSelectionMatrix(selectionMatrix);
    }

    @Override
    public boolean solve(RigidBodyTransformReadOnly desiredTransform) {
        this.iterationNumber = 0;
        this.minimumErrorScalar = Double.POSITIVE_INFINITY;
        this.numberOfConstraints = this.inverseJacobianCalculator.getNumberOfConstraints();
        boolean hasReachedMaxIterations = false;
        boolean hasReachedTolerance = false;
        do {
            this.computeError(desiredTransform);
            this.computeJointAngleCorrection(this.spatialError);
            this.updateBest();
            this.applyJointAngleCorrection();
            ++this.iterationNumber;
            hasReachedMaxIterations = this.iterationNumber >= this.maxIterations;
            boolean bl = hasReachedTolerance = this.errorScalar <= this.tolerance;
        } while (!hasReachedTolerance && !hasReachedMaxIterations);
        this.updateBest();
        this.setJointAngles(this.jointAnglesMinimumError);
        return hasReachedTolerance;
    }

    public void getBest(DMatrixRMaj bestToPack) {
        bestToPack.set((DMatrixD1)this.jointAnglesMinimumError);
    }

    public void getBest(LinkedHashMap<OneDoFJointBasics, Double> bestToPack) {
        for (int i = 0; i < this.oneDoFJoints.length; ++i) {
            bestToPack.put(this.oneDoFJoints[i], this.jointAnglesMinimumError.get(i, 0));
        }
    }

    private void getJointAngles(DMatrixRMaj angles) {
        for (int i = 0; i < angles.getNumRows(); ++i) {
            angles.set(i, 0, this.oneDoFJoints[i].getQ());
        }
    }

    public void setJointAngles(DMatrixRMaj angles) {
        for (int i = 0; i < angles.getNumRows(); ++i) {
            this.oneDoFJoints[i].setQ(angles.get(i, 0));
        }
    }

    private void updateBest() {
        this.errorScalar = NormOps_DDRM.normP2((DMatrixRMaj)this.inverseJacobianCalculator.getSubspaceSpatialVelocity());
        if (this.errorScalar < this.minimumErrorScalar) {
            this.getJointAngles(this.jointAnglesMinimumError);
            this.minimumErrorScalar = this.errorScalar;
        }
    }

    private void computeError(RigidBodyTransformReadOnly desiredTransform) {
        this.jacobian.compute();
        this.jacobian.getEndEffectorFrame().getTransformToDesiredFrame(this.actualTransform, this.jacobian.getBaseFrame());
        this.errorTransform.setAndInvert(desiredTransform);
        this.errorTransform.multiply((RigidBodyTransformReadOnly)this.actualTransform);
        this.errorRotationMatrix.set((RotationMatrixReadOnly)this.errorTransform.getRotation());
        this.errorAxisAngle.set((Orientation3DReadOnly)this.errorRotationMatrix);
        this.axis.set(this.errorAxisAngle.getX(), this.errorAxisAngle.getY(), this.errorAxisAngle.getZ());
        this.errorRotationVector.set(this.axis);
        this.errorRotationVector.scale(this.errorAxisAngle.getAngle());
        this.errorRotationVector.scale(0.2);
        this.errorTranslationVector.set((Tuple3DReadOnly)this.errorTransform.getTranslation());
        this.errorRotationVector.get(0, 0, (DMatrix)this.spatialError);
        this.errorTranslationVector.get(3, 0, (DMatrix)this.spatialError);
    }

    private void computeJointAngleCorrection(DMatrixRMaj spatialError) {
        this.inverseJacobianCalculator.solveUsingDampedLeastSquares(spatialError, this.jacobian.getJacobianMatrix(), this.lambdaLeastSquares);
        this.jointAnglesCorrection.set((DMatrixD1)this.inverseJacobianCalculator.getJointspaceVelocity());
        double correctionScale = RandomNumbers.nextDouble((Random)this.random, (double)this.minRandomSearchScalar, (double)this.maxRandomSearchScalar);
        CommonOps_DDRM.scale((double)correctionScale, (DMatrixD1)this.jointAnglesCorrection);
        for (int i = 0; i < this.jointAnglesCorrection.getNumRows(); ++i) {
            this.jointAnglesCorrection.set(i, 0, Math.min(this.maxStepSize, Math.max(this.jointAnglesCorrection.get(i, 0), -this.maxStepSize)));
        }
    }

    private void applyJointAngleCorrection() {
        for (int i = 0; i < this.oneDoFJoints.length; ++i) {
            OneDoFJointBasics oneDoFJoint = this.oneDoFJoints[i];
            double newQ = oneDoFJoint.getQ() - this.jointAnglesCorrection.get(i, 0);
            if (this.limitJointAngles) {
                newQ = Math.min(oneDoFJoint.getJointLimitUpper(), Math.max(newQ, oneDoFJoint.getJointLimitLower()));
            }
            oneDoFJoint.setQ(newQ);
            oneDoFJoint.getFrameAfterJoint().update();
        }
        if (this.stepListener != null) {
            this.stepListener.didAnInverseKinemticsStep(this.errorScalar);
        }
    }

    @Override
    public int getNumberOfIterations() {
        return this.iterationNumber;
    }

    @Override
    public double getErrorScalar() {
        return this.minimumErrorScalar;
    }
}

