/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.kinematics;

import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;

public class JointLimitData {
    private double positionSoftUpperLimit = Double.NaN;
    private double positionSoftLowerLimit = Double.NaN;
    private double velocityLimitUpper = Double.NaN;
    private double velocityLimitLower = Double.NaN;
    private double torqueLimitUpper = Double.NaN;
    private double torqueLimitLower = Double.NaN;
    private double positionLimitStiffness = Double.NaN;
    private double positionLimitDamping = Double.NaN;

    public JointLimitData() {
        this.clear();
    }

    public JointLimitData(OneDoFJointBasics joint) {
        this.clear();
        this.setJointLimits(joint);
    }

    public void clear() {
        this.positionSoftUpperLimit = Double.NaN;
        this.positionSoftLowerLimit = Double.NaN;
        this.velocityLimitUpper = Double.NaN;
        this.velocityLimitLower = Double.NaN;
        this.torqueLimitUpper = Double.NaN;
        this.torqueLimitLower = Double.NaN;
        this.positionLimitStiffness = Double.NaN;
        this.positionLimitDamping = Double.NaN;
    }

    public void set(JointLimitData other) {
        this.positionSoftUpperLimit = other.positionSoftUpperLimit;
        this.positionSoftLowerLimit = other.positionSoftLowerLimit;
        this.velocityLimitUpper = other.velocityLimitUpper;
        this.velocityLimitLower = other.velocityLimitLower;
        this.torqueLimitUpper = other.torqueLimitUpper;
        this.torqueLimitLower = other.torqueLimitLower;
        this.positionLimitStiffness = other.positionLimitStiffness;
        this.positionLimitDamping = other.positionLimitDamping;
    }

    public void setJointLimits(OneDoFJointBasics joint) {
        this.positionSoftUpperLimit = joint.getJointLimitUpper();
        this.positionSoftLowerLimit = joint.getJointLimitLower();
        this.velocityLimitUpper = joint.getVelocityLimitUpper();
        this.velocityLimitLower = joint.getVelocityLimitLower();
        this.torqueLimitUpper = joint.getEffortLimitUpper();
        this.torqueLimitLower = joint.getEffortLimitLower();
    }

    public void completeWith(JointLimitData other) {
        if (!this.hasPositionSoftUpperLimit()) {
            this.positionSoftUpperLimit = other.positionSoftUpperLimit;
        }
        if (!this.hasPositionSoftLowerLimit()) {
            this.positionSoftLowerLimit = other.positionSoftLowerLimit;
        }
        if (!this.hasVelocityUpperLimit()) {
            this.velocityLimitUpper = other.velocityLimitUpper;
        }
        if (!this.hasVelocityLowerLimit()) {
            this.velocityLimitLower = other.velocityLimitLower;
        }
        if (!this.hasTorqueUpperLimit()) {
            this.torqueLimitUpper = other.torqueLimitUpper;
        }
        if (!this.hasTorqueLowerLimit()) {
            this.torqueLimitLower = other.torqueLimitLower;
        }
        if (!this.hasPositionLimitStiffness()) {
            this.positionLimitStiffness = other.positionLimitStiffness;
        }
        if (!this.hasPositionLimitDamping()) {
            this.positionLimitDamping = other.positionLimitDamping;
        }
    }

    public boolean hasPositionSoftUpperLimit() {
        return !Double.isNaN(this.positionSoftUpperLimit);
    }

    public boolean hasPositionSoftLowerLimit() {
        return !Double.isNaN(this.positionSoftLowerLimit);
    }

    public boolean hasVelocityUpperLimit() {
        return !Double.isNaN(this.velocityLimitUpper);
    }

    public boolean hasVelocityLowerLimit() {
        return !Double.isNaN(this.velocityLimitLower);
    }

    public boolean hasTorqueUpperLimit() {
        return !Double.isNaN(this.torqueLimitUpper);
    }

    public boolean hasTorqueLowerLimit() {
        return !Double.isNaN(this.torqueLimitLower);
    }

    public boolean hasPositionLimitStiffness() {
        return !Double.isNaN(this.positionLimitStiffness);
    }

    public boolean hasPositionLimitDamping() {
        return !Double.isNaN(this.positionLimitDamping);
    }

    public double getPositionSoftUpperLimit() {
        return this.positionSoftUpperLimit;
    }

    public double getPositionSoftLowerLimit() {
        return this.positionSoftLowerLimit;
    }

    public double getTorqueUpperLimit() {
        return this.torqueLimitUpper;
    }

    public double getTorqueLowerLimit() {
        return this.torqueLimitLower;
    }

    public double getVelocityUpperLimit() {
        return this.velocityLimitUpper;
    }

    public double getVelocityLowerLimit() {
        return this.velocityLimitLower;
    }

    public double getJointLimitStiffness() {
        return this.positionLimitStiffness;
    }

    public double getJointLimitDamping() {
        return this.positionLimitDamping;
    }

    public void setVelocityUpperLimit(double velocityLimit) {
        this.velocityLimitUpper = velocityLimit;
    }

    public void setVelocityLowerLimit(double velocityLimit) {
        this.velocityLimitLower = velocityLimit;
    }

    public void setPositionSoftUpperLimit(double positionSoftUpperLimit) {
        this.positionSoftUpperLimit = positionSoftUpperLimit;
    }

    public void setPositionSoftLowerLimit(double positionSoftLowerLimit) {
        this.positionSoftLowerLimit = positionSoftLowerLimit;
    }

    public void setTorqueUpperLimit(double torqueLimit) {
        this.torqueLimitUpper = torqueLimit;
    }

    public void setTorqueLowerLimit(double torqueLimit) {
        this.torqueLimitLower = torqueLimit;
    }

    public void setPositionLimitStiffness(double stiffness) {
        this.positionLimitStiffness = stiffness;
    }

    public void setPositionLimitDamping(double damping) {
        this.positionLimitDamping = damping;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JointLimitData) {
            JointLimitData other = (JointLimitData)object;
            if (this.positionSoftLowerLimit != other.positionSoftLowerLimit) {
                return false;
            }
            if (this.positionSoftUpperLimit != other.positionSoftUpperLimit) {
                return false;
            }
            if (this.velocityLimitLower != other.velocityLimitLower) {
                return false;
            }
            if (this.velocityLimitUpper != other.velocityLimitUpper) {
                return false;
            }
            if (this.torqueLimitLower != other.torqueLimitLower) {
                return false;
            }
            if (this.torqueLimitUpper != other.torqueLimitUpper) {
                return false;
            }
            if (this.positionLimitStiffness != other.positionLimitStiffness) {
                return false;
            }
            return this.positionLimitDamping == other.positionLimitDamping;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": q_min: " + this.positionSoftLowerLimit + ", q_max: " + this.positionSoftUpperLimit + ", qd_min: " + this.velocityLimitLower + ", qd_max: " + this.velocityLimitUpper + ", tau_min: " + this.torqueLimitLower + ", tau_max: " + this.torqueLimitUpper + ", stiffness: " + this.positionLimitStiffness + ", damping: " + this.positionLimitDamping;
    }
}

