/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.kinematics;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.dense.row.linsol.svd.SolvePseudoInverseSvd_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class InverseJacobianSolver {
    private final LinearSolverDense<DMatrixRMaj> linearAlgebraSolver;
    private final DMatrixRMaj selectionMatrix;
    private final DMatrixRMaj subspaceJacobianMatrix;
    private final DMatrixRMaj subspaceSpatialVelocity;
    private final DMatrixRMaj jacobianMatrixTransposed;
    private final DMatrixRMaj jacobianTimesJacobianTransposedMatrix;
    private final DMatrixRMaj lamdaSquaredMatrix;
    private final DMatrixRMaj jacobianTimesJacobianTransposedPlusLamdaSquaredMatrix;
    private final DMatrixRMaj jacobianTimesSpatialVelocity;
    private final DMatrixRMaj jacobianTransposedTimesJacobianMatrix;
    private final DMatrixRMaj intermediateSubspaceSpatialVelocity;
    private final DMatrixRMaj intermediateResultInTaskspace;
    private final DMatrixRMaj jointspaceVelocity;
    private final int maximumNumberOfConstraints;
    private int numberOfConstraints;
    private final int numberOfDoF;

    public static InverseJacobianSolver createInverseJacobianSolver(int maximumNumberOfConstraints, int numberOfDoF, boolean useSVD) {
        Object solver = useSVD ? new SolvePseudoInverseSvd_DDRM(maximumNumberOfConstraints, maximumNumberOfConstraints) : LinearSolverFactory_DDRM.leastSquares((int)maximumNumberOfConstraints, (int)maximumNumberOfConstraints);
        return new InverseJacobianSolver(maximumNumberOfConstraints, numberOfDoF, (LinearSolverDense<DMatrixRMaj>)solver);
    }

    public InverseJacobianSolver(int maximumNumberOfConstraints, int numberOfDoF, LinearSolverDense<DMatrixRMaj> solver) {
        this.selectionMatrix = CommonOps_DDRM.identity((int)maximumNumberOfConstraints);
        this.numberOfDoF = numberOfDoF;
        this.maximumNumberOfConstraints = maximumNumberOfConstraints;
        this.numberOfConstraints = maximumNumberOfConstraints;
        this.subspaceJacobianMatrix = new DMatrixRMaj(maximumNumberOfConstraints, numberOfDoF);
        this.subspaceSpatialVelocity = new DMatrixRMaj(maximumNumberOfConstraints, 1);
        this.jacobianMatrixTransposed = new DMatrixRMaj(numberOfDoF, maximumNumberOfConstraints);
        this.jacobianTimesJacobianTransposedMatrix = new DMatrixRMaj(maximumNumberOfConstraints, maximumNumberOfConstraints);
        this.jacobianTimesSpatialVelocity = new DMatrixRMaj(numberOfDoF, 1);
        this.jacobianTransposedTimesJacobianMatrix = new DMatrixRMaj(numberOfDoF, numberOfDoF);
        this.lamdaSquaredMatrix = new DMatrixRMaj(numberOfDoF, numberOfDoF);
        this.jacobianTimesJacobianTransposedPlusLamdaSquaredMatrix = new DMatrixRMaj(numberOfDoF, numberOfDoF);
        this.linearAlgebraSolver = solver;
        this.intermediateSubspaceSpatialVelocity = new DMatrixRMaj(maximumNumberOfConstraints, 1);
        this.intermediateResultInTaskspace = new DMatrixRMaj(maximumNumberOfConstraints, 1);
        this.jointspaceVelocity = new DMatrixRMaj(numberOfDoF, 1);
    }

    public void setSelectionMatrix(DMatrixRMaj selectionMatrix) {
        this.numberOfConstraints = selectionMatrix.getNumRows();
        this.selectionMatrix.reshape(this.numberOfConstraints, selectionMatrix.getNumCols());
        this.selectionMatrix.set((DMatrixD1)selectionMatrix);
    }

    public void setSelectionMatrixForFullConstraint() {
        this.numberOfConstraints = this.maximumNumberOfConstraints;
        this.selectionMatrix.reshape(this.numberOfConstraints, this.numberOfConstraints);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.selectionMatrix);
    }

    public DMatrixRMaj getJointspaceVelocity() {
        return this.jointspaceVelocity;
    }

    public DMatrixRMaj getSubspaceSpatialVelocity() {
        return this.subspaceSpatialVelocity;
    }

    public boolean solveUsingJacobianInverse(DMatrixRMaj spatialVelocity, DMatrixRMaj jacobianMatrix) {
        this.computeSubspaceJacobian(this.subspaceJacobianMatrix, jacobianMatrix);
        this.computeSubspaceSpatialVelocity(this.subspaceSpatialVelocity, spatialVelocity);
        boolean success = this.linearAlgebraSolver.setA((Matrix)this.subspaceJacobianMatrix);
        if (success) {
            this.linearAlgebraSolver.solve((Matrix)this.subspaceSpatialVelocity, (Matrix)this.jointspaceVelocity);
        }
        return success;
    }

    public boolean solveUsingJacobianPseudoInverseOne(DMatrixRMaj spatialVelocity, DMatrixRMaj jacobianMatrix) {
        this.computeSubspaceJacobian(this.subspaceJacobianMatrix, jacobianMatrix);
        this.computeSubspaceSpatialVelocity(this.subspaceSpatialVelocity, spatialVelocity);
        this.computeJacobianTransposed(this.jacobianMatrixTransposed, this.subspaceJacobianMatrix);
        this.computeJacobianTransposedTimesJacobian(this.jacobianTransposedTimesJacobianMatrix, this.subspaceJacobianMatrix);
        this.jacobianTimesSpatialVelocity.reshape(this.numberOfDoF, 1);
        CommonOps_DDRM.mult((DMatrix1Row)this.jacobianMatrixTransposed, (DMatrix1Row)this.subspaceSpatialVelocity, (DMatrix1Row)this.jacobianTimesSpatialVelocity);
        boolean success = this.linearAlgebraSolver.setA((Matrix)this.jacobianTransposedTimesJacobianMatrix);
        if (success) {
            this.linearAlgebraSolver.solve((Matrix)this.jacobianTimesSpatialVelocity, (Matrix)this.jointspaceVelocity);
        }
        return success;
    }

    public boolean solveUsingJacobianPseudoInverseTwo(DMatrixRMaj spatialVelocity, DMatrixRMaj jacobianMatrix) {
        this.computeSubspaceJacobian(this.subspaceJacobianMatrix, jacobianMatrix);
        this.computeSubspaceSpatialVelocity(this.subspaceSpatialVelocity, spatialVelocity);
        this.computeJacobianTransposed(this.jacobianMatrixTransposed, this.subspaceJacobianMatrix);
        this.computeJacobianTimesJacobianTransposed(this.jacobianTimesJacobianTransposedMatrix, this.subspaceJacobianMatrix);
        this.intermediateResultInTaskspace.reshape(this.numberOfConstraints, 1);
        boolean success = this.linearAlgebraSolver.setA((Matrix)this.jacobianTimesJacobianTransposedMatrix);
        if (success) {
            this.linearAlgebraSolver.solve((Matrix)this.subspaceSpatialVelocity, (Matrix)this.intermediateResultInTaskspace);
        }
        CommonOps_DDRM.mult((DMatrix1Row)this.jacobianMatrixTransposed, (DMatrix1Row)this.intermediateResultInTaskspace, (DMatrix1Row)this.jointspaceVelocity);
        return success;
    }

    public boolean solveUsingDampedLeastSquares(DMatrixRMaj spatialVelocity, DMatrixRMaj jacobianMatrix, double lambdaLeastSquares) {
        this.computeSubspaceJacobian(this.subspaceJacobianMatrix, jacobianMatrix);
        this.computeSubspaceSpatialVelocity(this.subspaceSpatialVelocity, spatialVelocity);
        this.computeJacobianTransposed(this.jacobianMatrixTransposed, this.subspaceJacobianMatrix);
        this.computeJacobianTimesJacobianTransposed(this.jacobianTimesJacobianTransposedMatrix, this.subspaceJacobianMatrix);
        this.intermediateResultInTaskspace.reshape(this.numberOfConstraints, 1);
        this.lamdaSquaredMatrix.reshape(this.numberOfConstraints, this.numberOfConstraints);
        this.lamdaSquaredMatrix.zero();
        for (int i = 0; i < this.numberOfConstraints; ++i) {
            this.lamdaSquaredMatrix.set(i, i, lambdaLeastSquares);
        }
        this.jacobianTimesJacobianTransposedPlusLamdaSquaredMatrix.reshape(this.numberOfConstraints, this.numberOfConstraints);
        this.jacobianTimesJacobianTransposedPlusLamdaSquaredMatrix.set((DMatrixD1)this.jacobianTimesJacobianTransposedMatrix);
        CommonOps_DDRM.add((DMatrixD1)this.jacobianTimesJacobianTransposedMatrix, (DMatrixD1)this.lamdaSquaredMatrix, (DMatrixD1)this.jacobianTimesJacobianTransposedPlusLamdaSquaredMatrix);
        boolean success = this.linearAlgebraSolver.setA((Matrix)this.jacobianTimesJacobianTransposedPlusLamdaSquaredMatrix);
        if (success) {
            this.linearAlgebraSolver.solve((Matrix)this.subspaceSpatialVelocity, (Matrix)this.intermediateResultInTaskspace);
        }
        CommonOps_DDRM.mult((DMatrix1Row)this.jacobianMatrixTransposed, (DMatrix1Row)this.intermediateResultInTaskspace, (DMatrix1Row)this.jointspaceVelocity);
        return success;
    }

    public boolean solveUsingNullspaceMethod(DMatrixRMaj spatialVelocity, DMatrixRMaj jacobianMatrix, DMatrixRMaj privilegedJointVelocities) {
        this.computeSubspaceJacobian(this.subspaceJacobianMatrix, jacobianMatrix);
        this.computeSubspaceSpatialVelocity(this.subspaceSpatialVelocity, spatialVelocity);
        this.intermediateSubspaceSpatialVelocity.reshape(this.numberOfConstraints, 1);
        this.intermediateSubspaceSpatialVelocity.set((DMatrixD1)this.subspaceSpatialVelocity);
        CommonOps_DDRM.multAdd((double)-1.0, (DMatrix1Row)this.subspaceJacobianMatrix, (DMatrix1Row)privilegedJointVelocities, (DMatrix1Row)this.intermediateSubspaceSpatialVelocity);
        this.computeJacobianTransposed(this.jacobianMatrixTransposed, this.subspaceJacobianMatrix);
        this.computeJacobianTimesJacobianTransposed(this.jacobianTimesJacobianTransposedMatrix, this.subspaceJacobianMatrix);
        this.intermediateResultInTaskspace.reshape(this.numberOfConstraints, 1);
        boolean success = this.linearAlgebraSolver.setA((Matrix)this.jacobianTimesJacobianTransposedMatrix);
        if (success) {
            this.linearAlgebraSolver.solve((Matrix)this.intermediateSubspaceSpatialVelocity, (Matrix)this.intermediateResultInTaskspace);
        }
        this.jointspaceVelocity.set((DMatrixD1)privilegedJointVelocities);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.jacobianMatrixTransposed, (DMatrix1Row)this.intermediateResultInTaskspace, (DMatrix1Row)this.jointspaceVelocity);
        return success;
    }

    public boolean solveUsingNullspaceMethodWithoutSelectionMatrix(DMatrixRMaj spatialVelocity, DMatrixRMaj jacobianMatrix, DMatrixRMaj privilegedJointVelocities) {
        int numberOfConstraints = jacobianMatrix.getNumRows();
        this.subspaceJacobianMatrix.reshape(numberOfConstraints, jacobianMatrix.getNumCols());
        this.subspaceJacobianMatrix.set((DMatrixD1)jacobianMatrix);
        this.subspaceSpatialVelocity.reshape(spatialVelocity.getNumRows(), this.subspaceSpatialVelocity.getNumCols());
        this.subspaceSpatialVelocity.set((DMatrixD1)spatialVelocity);
        this.intermediateSubspaceSpatialVelocity.reshape(numberOfConstraints, 1);
        this.intermediateSubspaceSpatialVelocity.set((DMatrixD1)this.subspaceSpatialVelocity);
        CommonOps_DDRM.multAdd((double)-1.0, (DMatrix1Row)this.subspaceJacobianMatrix, (DMatrix1Row)privilegedJointVelocities, (DMatrix1Row)this.intermediateSubspaceSpatialVelocity);
        this.jacobianMatrixTransposed.reshape(this.numberOfDoF, numberOfConstraints);
        CommonOps_DDRM.transpose((DMatrixRMaj)this.subspaceJacobianMatrix, (DMatrixRMaj)this.jacobianMatrixTransposed);
        this.jacobianTimesJacobianTransposedMatrix.reshape(numberOfConstraints, numberOfConstraints);
        CommonOps_DDRM.multOuter((DMatrix1Row)this.subspaceJacobianMatrix, (DMatrix1Row)this.jacobianTimesJacobianTransposedMatrix);
        this.intermediateResultInTaskspace.reshape(numberOfConstraints, 1);
        boolean success = this.linearAlgebraSolver.setA((Matrix)this.jacobianTimesJacobianTransposedMatrix);
        if (success) {
            this.linearAlgebraSolver.solve((Matrix)this.intermediateSubspaceSpatialVelocity, (Matrix)this.intermediateResultInTaskspace);
        }
        this.jointspaceVelocity.set((DMatrixD1)privilegedJointVelocities);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.jacobianMatrixTransposed, (DMatrix1Row)this.intermediateResultInTaskspace, (DMatrix1Row)this.jointspaceVelocity);
        return success;
    }

    private void computeJacobianTransposedTimesJacobian(DMatrixRMaj resultToPack, DMatrixRMaj jacobian) {
        resultToPack.reshape(this.numberOfDoF, this.numberOfDoF);
        CommonOps_DDRM.multInner((DMatrix1Row)jacobian, (DMatrix1Row)resultToPack);
    }

    private void computeJacobianTimesJacobianTransposed(DMatrixRMaj resultToPack, DMatrixRMaj jacobian) {
        resultToPack.reshape(this.numberOfConstraints, this.numberOfConstraints);
        CommonOps_DDRM.multOuter((DMatrix1Row)jacobian, (DMatrix1Row)resultToPack);
    }

    private void computeJacobianTransposed(DMatrixRMaj jacobianTransposedToPack, DMatrixRMaj jacobian) {
        jacobianTransposedToPack.reshape(this.numberOfDoF, this.numberOfConstraints);
        CommonOps_DDRM.transpose((DMatrixRMaj)jacobian, (DMatrixRMaj)jacobianTransposedToPack);
    }

    private void computeSubspaceJacobian(DMatrixRMaj subspaceJacobianMatrixToPack, DMatrixRMaj jacobianMatrix) {
        subspaceJacobianMatrixToPack.reshape(this.numberOfConstraints, this.numberOfDoF);
        CommonOps_DDRM.mult((DMatrix1Row)this.selectionMatrix, (DMatrix1Row)jacobianMatrix, (DMatrix1Row)subspaceJacobianMatrixToPack);
    }

    private void computeSubspaceSpatialVelocity(DMatrixRMaj subspaceSpatialVelocityToPack, DMatrixRMaj spatialVelocity) {
        subspaceSpatialVelocityToPack.reshape(this.numberOfConstraints, 1);
        CommonOps_DDRM.mult((DMatrix1Row)this.selectionMatrix, (DMatrix1Row)spatialVelocity, (DMatrix1Row)subspaceSpatialVelocityToPack);
    }

    public int getNumberOfConstraints() {
        return this.numberOfConstraints;
    }

    public double computeDeterminant(DMatrixRMaj jacobianMatrix) {
        this.computeJacobianTimesJacobianTransposed(this.jacobianTimesJacobianTransposedMatrix, jacobianMatrix);
        return CommonOps_DDRM.det((DMatrixRMaj)this.jacobianTimesJacobianTransposedMatrix);
    }

    public double getLastComputedDeterminant() {
        double det = CommonOps_DDRM.det((DMatrixRMaj)this.jacobianTimesJacobianTransposedMatrix);
        return det;
    }

    public DMatrixRMaj getSelectionMatrix() {
        return this.selectionMatrix;
    }
}

