/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.interaction;

import java.util.function.Function;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.interaction.SphereRayIntersection;

public class StepCheckIsPointInsideAlgorithm {
    private final SphereRayIntersection boundingSphereIntersection = new SphereRayIntersection();
    private final Point3D interpolatedPoint = new Point3D();

    public void update(double radius, RigidBodyTransformReadOnly transform) {
        this.boundingSphereIntersection.update(radius, transform);
    }

    public void update(double radius, Point3DReadOnly offset, RigidBodyTransformReadOnly transform) {
        this.boundingSphereIntersection.update(radius, offset, transform);
    }

    public void update(double radius, Point3DReadOnly positionInWorld) {
        this.boundingSphereIntersection.update(radius, positionInWorld);
    }

    public double intersect(Line3DReadOnly pickRay, int resolution, Function<Point3DReadOnly, Boolean> isPointInside) {
        return this.intersect(pickRay, resolution, isPointInside, this.interpolatedPoint, true);
    }

    public double intersect(Line3DReadOnly pickRay, int resolution, Function<Point3DReadOnly, Boolean> isPointInside, Point3D intersectionToPack, boolean calculateDistance) {
        if (this.boundingSphereIntersection.intersect(pickRay)) {
            for (int i = 0; i < resolution; ++i) {
                intersectionToPack.interpolate((Tuple3DReadOnly)this.boundingSphereIntersection.getFirstIntersectionToPack(), (Tuple3DReadOnly)this.boundingSphereIntersection.getSecondIntersectionToPack(), (double)i / (double)resolution);
                if (!isPointInside.apply((Point3DReadOnly)intersectionToPack).booleanValue()) continue;
                return calculateDistance ? intersectionToPack.distance(pickRay.getPoint()) : 0.0;
            }
        }
        return Double.NaN;
    }

    public Point3D getClosestIntersection() {
        return this.interpolatedPoint;
    }
}

