/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.interaction;

import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class SphereRayIntersection {
    private final Sphere3D sphere = new Sphere3D();
    private final Point3D rayOriginInSphereFrame = new Point3D();
    private final Point3D firstIntersectionToPack = new Point3D();
    private final Point3D secondIntersectionToPack = new Point3D();
    private boolean intersects = false;
    private final FramePoint3D tempFramePoint = new FramePoint3D();

    public void update(double radius, RigidBodyTransformReadOnly transform) {
        this.update(radius, 0.0, transform);
    }

    public void update(double radius, double zOffset, RigidBodyTransformReadOnly transform) {
        this.sphere.setToZero();
        this.sphere.setRadius(radius);
        this.sphere.getPosition().addZ(zOffset);
        this.sphere.applyTransform((Transform)transform);
    }

    public void update(double radius, Point3DReadOnly offset, RigidBodyTransformReadOnly transform) {
        this.sphere.setToZero();
        this.sphere.setRadius(radius);
        this.sphere.getPosition().add((Tuple3DReadOnly)offset);
        this.sphere.applyTransform((Transform)transform);
    }

    public void update(double radius, Point3DReadOnly positionInWorld) {
        this.sphere.setToZero();
        this.sphere.setRadius(radius);
        this.sphere.getPosition().set((Tuple3DReadOnly)positionInWorld);
    }

    public void update(double radius, Point3DReadOnly offset, ReferenceFrame sphereFrame) {
        this.tempFramePoint.setIncludingFrame(sphereFrame, (Tuple3DReadOnly)offset);
        this.tempFramePoint.changeFrame(ReferenceFrame.getWorldFrame());
        this.sphere.setToZero();
        this.sphere.setRadius(radius);
        this.sphere.getPosition().set((Tuple3DReadOnly)this.tempFramePoint);
    }

    public boolean intersect(Line3DReadOnly pickRay) {
        this.rayOriginInSphereFrame.setX(pickRay.getPoint().getX() - this.sphere.getPosition().getX());
        this.rayOriginInSphereFrame.setY(pickRay.getPoint().getY() - this.sphere.getPosition().getY());
        this.rayOriginInSphereFrame.setZ(pickRay.getPoint().getZ() - this.sphere.getPosition().getZ());
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndEllipsoid3D((double)this.sphere.getRadius(), (double)this.sphere.getRadius(), (double)this.sphere.getRadius(), (Point3DReadOnly)this.rayOriginInSphereFrame, (Vector3DReadOnly)pickRay.getDirection(), (Point3DBasics)this.firstIntersectionToPack, (Point3DBasics)this.secondIntersectionToPack);
        this.firstIntersectionToPack.add((Tuple3DReadOnly)this.sphere.getPosition());
        this.secondIntersectionToPack.add((Tuple3DReadOnly)this.sphere.getPosition());
        this.intersects = numberOfIntersections == 2;
        return this.intersects;
    }

    public Point3DReadOnly getFirstIntersectionToPack() {
        return this.firstIntersectionToPack;
    }

    public Point3DReadOnly getSecondIntersectionToPack() {
        return this.secondIntersectionToPack;
    }

    public boolean getIntersects() {
        return this.intersects;
    }
}

