/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.interaction;

import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.shape.primitives.Ellipsoid3D;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.referenceFrames.MutableReferenceFrame;

public class EllipsoidRayIntersection {
    private final Ellipsoid3D ellipsoid = new Ellipsoid3D();
    private final FramePoint3D firstIntersectionToPack = new FramePoint3D();
    private final FramePoint3D secondIntersectionToPack = new FramePoint3D();
    private final FramePose3D tempFramePose = new FramePose3D();
    private final MutableReferenceFrame ellipsoidFrame = new MutableReferenceFrame(ReferenceFrame.getWorldFrame());
    private final FramePoint3D pickRayFrameOrigin = new FramePoint3D();
    private final FrameVector3D pickRayFrameDirection = new FrameVector3D();
    private boolean intersects = false;

    public void update(double radiusX, double radiusY, double radiusZ, Point3DReadOnly positionToParent, Orientation3DReadOnly orientationToParent, ReferenceFrame parentFrame) {
        this.ellipsoid.setToZero();
        this.ellipsoid.setRadiusX(radiusX);
        this.ellipsoid.setRadiusY(radiusY);
        this.ellipsoid.setRadiusZ(radiusZ);
        this.tempFramePose.setIncludingFrame(parentFrame, (Tuple3DReadOnly)positionToParent, orientationToParent);
        this.tempFramePose.changeFrame(ReferenceFrame.getWorldFrame());
        this.tempFramePose.get((RigidBodyTransformBasics)this.ellipsoidFrame.getTransformToParent());
        this.ellipsoidFrame.getReferenceFrame().update();
    }

    public boolean intersect(Line3DReadOnly pickRay) {
        this.pickRayFrameOrigin.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)pickRay.getPoint());
        this.pickRayFrameDirection.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)pickRay.getDirection());
        this.pickRayFrameOrigin.changeFrame(this.ellipsoidFrame.getReferenceFrame());
        this.pickRayFrameDirection.changeFrame(this.ellipsoidFrame.getReferenceFrame());
        this.firstIntersectionToPack.setToZero(this.ellipsoidFrame.getReferenceFrame());
        this.secondIntersectionToPack.setToZero(this.ellipsoidFrame.getReferenceFrame());
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndEllipsoid3D((double)this.ellipsoid.getRadiusX(), (double)this.ellipsoid.getRadiusY(), (double)this.ellipsoid.getRadiusZ(), (Point3DReadOnly)this.pickRayFrameOrigin, (Vector3DReadOnly)this.pickRayFrameDirection, (Point3DBasics)this.firstIntersectionToPack, (Point3DBasics)this.secondIntersectionToPack);
        boolean bl = this.intersects = numberOfIntersections == 2;
        if (this.intersects) {
            this.firstIntersectionToPack.changeFrame(ReferenceFrame.getWorldFrame());
            this.secondIntersectionToPack.changeFrame(ReferenceFrame.getWorldFrame());
        }
        return this.intersects;
    }

    public Point3DReadOnly getFirstIntersectionToPack() {
        return this.firstIntersectionToPack;
    }

    public Point3DReadOnly getSecondIntersectionToPack() {
        return this.secondIntersectionToPack;
    }

    public boolean getIntersects() {
        return this.intersects;
    }
}

