/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.hyperCubeTree;

import us.ihmc.robotics.hyperCubeTree.HyperCubeLeaf;
import us.ihmc.robotics.hyperCubeTree.HyperCubeTreeListener;
import us.ihmc.robotics.hyperCubeTree.OneDimensionalBounds;
import us.ihmc.robotics.quadTree.Box;
import us.ihmc.robotics.quadTree.QuadTreeForGroundListener;

public class OctreeToQuadtreeListenerConverter
implements HyperCubeTreeListener<Boolean, Void> {
    private final QuadTreeForGroundListener quadListener;

    public OctreeToQuadtreeListenerConverter(QuadTreeForGroundListener quadListener) {
        this.quadListener = quadListener;
    }

    @Override
    public void nodeAdded(String id, OneDimensionalBounds[] bounds, HyperCubeLeaf<Boolean> leaf) {
        Box boundryBox = new Box(bounds[0].min(), bounds[1].min(), bounds[0].max(), bounds[1].max());
        if (leaf != null && leaf.getValue().booleanValue()) {
            this.quadListener.nodeAdded(id, boundryBox, (float)leaf.getLocation()[0], (float)leaf.getLocation()[1], (float)leaf.getLocation()[2]);
        }
    }

    @Override
    public void nodeRemoved(String id) {
        this.quadListener.nodeRemoved(id);
    }

    @Override
    public void leafAdded(HyperCubeLeaf<Boolean> leaf) {
        if (leaf != null && leaf.getValue().booleanValue()) {
            double[] location = leaf.getLocation();
            this.quadListener.RawPointAdded((float)location[0], (float)location[1], (float)location[2]);
        }
    }

    @Override
    public void treeCleared() {
    }

    @Override
    public void metaDataUpdated(String id, OneDimensionalBounds[] bounds, Void data) {
    }
}

