/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.shapes.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.geometry.shapes.interfaces.STPShape3DReadOnly;

public interface STPCylinder3DReadOnly
extends STPShape3DReadOnly,
Cylinder3DReadOnly {
    default public void getBoundingBox(BoundingBox3DBasics boundingBoxToPack) {
        super.getBoundingBox(boundingBoxToPack);
        boundingBoxToPack.getMinPoint().sub(this.getMaximumMargin(), this.getMaximumMargin(), this.getMaximumMargin());
        boundingBoxToPack.getMaxPoint().add(this.getMaximumMargin(), this.getMaximumMargin(), this.getMaximumMargin());
    }

    @Override
    public boolean getSupportingVertex(Vector3DReadOnly var1, Point3DBasics var2);

    default public boolean equals(STPCylinder3DReadOnly other) {
        if (!super.equals((EuclidGeometry)other)) {
            return false;
        }
        return this.getMinimumMargin() == other.getMinimumMargin() && this.getMaximumMargin() == other.getMaximumMargin();
    }

    default public boolean epsilonEquals(STPCylinder3DReadOnly other, double epsilon) {
        if (!super.epsilonEquals((EuclidGeometry)other, epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals((double)this.getMinimumMargin(), (double)other.getMinimumMargin(), (double)epsilon)) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals((double)this.getMaximumMargin(), (double)other.getMaximumMargin(), (double)epsilon);
    }

    default public boolean geometricallyEquals(STPCylinder3DReadOnly other, double epsilon) {
        if (!super.geometricallyEquals((EuclidGeometry)other, epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals((double)this.getMinimumMargin(), (double)other.getMinimumMargin(), (double)epsilon)) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals((double)this.getMaximumMargin(), (double)other.getMaximumMargin(), (double)epsilon);
    }

    @Override
    default public boolean evaluatePoint3DCollision(Point3DReadOnly pointToCheck, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalAtClosestPointToPack) {
        return STPShape3DReadOnly.super.evaluatePoint3DCollision(pointToCheck, closestPointOnSurfaceToPack, normalAtClosestPointToPack);
    }

    @Override
    default public double signedDistance(Point3DReadOnly point) {
        return STPShape3DReadOnly.super.signedDistance(point);
    }

    @Override
    default public boolean isPointInside(Point3DReadOnly query, double epsilon) {
        return STPShape3DReadOnly.super.isPointInside(query, epsilon);
    }

    @Override
    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, Point3DBasics projectionToPack) {
        return STPShape3DReadOnly.super.orthogonalProjection(pointToProject, projectionToPack);
    }
}

