/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.shapes;

import java.util.List;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameBox3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameShape3DPoseBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoxPolytope3DView;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeIOTools;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.IntermediateVariableSupplier;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DChangeListener;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.geometry.shapes.STPShape3DTools;
import us.ihmc.robotics.geometry.shapes.interfaces.FrameSTPBox3DBasics;
import us.ihmc.robotics.geometry.shapes.interfaces.FrameSTPBox3DReadOnly;
import us.ihmc.robotics.geometry.shapes.interfaces.STPBox3DReadOnly;

public class FrameSTPBox3D
implements FrameSTPBox3DBasics {
    private double minimumMargin;
    private double maximumMargin;
    private double largeRadius;
    private double smallRadius;
    private final FrameBox3D rawBox3D = new FrameBox3D();
    private final STPShape3DTools.STPBox3DSupportingVertexCalculator supportingVertexCalculator = new STPShape3DTools.STPBox3DSupportingVertexCalculator();
    private boolean stpRadiiDirty = true;

    public FrameSTPBox3D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FrameSTPBox3D(ReferenceFrame referenceFrame) {
        this(referenceFrame, 1.0, 1.0, 1.0);
    }

    public FrameSTPBox3D(ReferenceFrame referenceFrame, double sizeX, double sizeY, double sizeZ) {
        this.setReferenceFrame(referenceFrame);
        this.getSize().set(sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameSTPBox3D(ReferenceFrame referenceFrame, Vector3DReadOnly size) {
        this.setReferenceFrame(referenceFrame);
        this.getSize().set((Tuple3DReadOnly)size);
        this.setupListeners();
    }

    public FrameSTPBox3D(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(referenceFrame, position, orientation, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameSTPBox3D(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly size) {
        this.setIncludingFrame(referenceFrame, position, orientation, size);
        this.setupListeners();
    }

    public FrameSTPBox3D(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(position, orientation, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameSTPBox3D(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, Vector3DReadOnly size) {
        this.setIncludingFrame(position, orientation, size);
        this.setupListeners();
    }

    public FrameSTPBox3D(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, FrameVector3DReadOnly size) {
        this.setIncludingFrame(position, orientation, size);
        this.setupListeners();
    }

    public FrameSTPBox3D(ReferenceFrame referenceFrame, Pose3DReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(referenceFrame, pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameSTPBox3D(ReferenceFrame referenceFrame, Pose3DReadOnly pose, Vector3DReadOnly size) {
        this.setIncludingFrame(referenceFrame, pose, size);
        this.setupListeners();
    }

    public FrameSTPBox3D(FramePose3DReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameSTPBox3D(FramePose3DReadOnly pose, Vector3DReadOnly size) {
        this.setIncludingFrame(pose, size);
        this.setupListeners();
    }

    public FrameSTPBox3D(FramePose3DReadOnly pose, FrameVector3DReadOnly size) {
        this.setIncludingFrame(pose, size);
        this.setupListeners();
    }

    public FrameSTPBox3D(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(referenceFrame, pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameSTPBox3D(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, Vector3DReadOnly size) {
        this.setIncludingFrame(referenceFrame, pose, size);
        this.setupListeners();
    }

    public FrameSTPBox3D(FrameShape3DPoseReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameSTPBox3D(FrameShape3DPoseReadOnly pose, Vector3DReadOnly size) {
        this.setIncludingFrame(pose, size);
        this.setupListeners();
    }

    public FrameSTPBox3D(FrameShape3DPoseReadOnly pose, FrameVector3DReadOnly size) {
        this.setIncludingFrame(pose, size);
        this.setupListeners();
    }

    public FrameSTPBox3D(ReferenceFrame referenceFrame, Box3DReadOnly other) {
        this.setIncludingFrame(referenceFrame, other);
        this.setupListeners();
    }

    public FrameSTPBox3D(ReferenceFrame referenceFrame, STPBox3DReadOnly other) {
        this.setIncludingFrame(referenceFrame, other);
        this.setupListeners();
    }

    public FrameSTPBox3D(FrameBox3DReadOnly other) {
        this.setIncludingFrame(other);
        this.setupListeners();
    }

    public FrameSTPBox3D(FrameSTPBox3DReadOnly other) {
        this.setIncludingFrame(other);
        this.setupListeners();
    }

    private void setupListeners() {
        this.addChangeListener(() -> {
            this.stpRadiiDirty = true;
        });
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.rawBox3D.setReferenceFrame(referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.rawBox3D.getReferenceFrame();
    }

    public FixedFrameShape3DPoseBasics getPose() {
        return this.rawBox3D.getPose();
    }

    public FixedFrameVector3DBasics getSize() {
        return this.rawBox3D.getSize();
    }

    @Override
    public double getMinimumMargin() {
        return this.minimumMargin;
    }

    @Override
    public double getMaximumMargin() {
        return this.maximumMargin;
    }

    @Override
    public double getSmallRadius() {
        this.updateRadii();
        return this.smallRadius;
    }

    @Override
    public double getLargeRadius() {
        this.updateRadii();
        return this.largeRadius;
    }

    @Override
    public void setMargins(double minimumMargin, double maximumMargin) {
        if (maximumMargin <= minimumMargin) {
            throw new IllegalArgumentException("The maximum margin has to be strictly greater that the minimum margin, max margin: " + maximumMargin + ", min margin: " + minimumMargin);
        }
        this.minimumMargin = minimumMargin;
        this.maximumMargin = maximumMargin;
        this.stpRadiiDirty = true;
    }

    protected void updateRadii() {
        if (!this.stpRadiiDirty) {
            return;
        }
        this.stpRadiiDirty = false;
        if (this.minimumMargin == 0.0 && this.maximumMargin == 0.0) {
            this.smallRadius = Double.NaN;
            this.largeRadius = Double.NaN;
        } else {
            this.smallRadius = this.minimumMargin;
            this.largeRadius = STPShape3DTools.computeLargeRadiusFromMargins(this.minimumMargin, this.maximumMargin, STPShape3DTools.computeBox3DMaximumEdgeLengthSquared((Vector3DReadOnly)this.getSize()));
        }
    }

    @Override
    public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        return this.supportingVertexCalculator.getSupportingVertex((Box3DReadOnly)this.rawBox3D, this.getSmallRadius(), this.getLargeRadius(), supportDirection, supportingVertexToPack);
    }

    public IntermediateVariableSupplier getIntermediateVariableSupplier() {
        return this.rawBox3D.getIntermediateVariableSupplier();
    }

    public void setIntermediateVariableSupplier(IntermediateVariableSupplier newSupplier) {
        this.rawBox3D.setIntermediateVariableSupplier(newSupplier);
    }

    public FrameSTPBox3D copy() {
        return new FrameSTPBox3D(this);
    }

    public FrameBoxPolytope3DView asConvexPolytope() {
        return this.rawBox3D.asConvexPolytope();
    }

    public void notifyChangeListeners() {
        this.rawBox3D.notifyChangeListeners();
    }

    public void addChangeListeners(List<? extends Shape3DChangeListener> listeners) {
        this.rawBox3D.addChangeListeners(listeners);
    }

    public void addChangeListener(Shape3DChangeListener listener) {
        this.rawBox3D.addChangeListener(listener);
    }

    public boolean removeChangeListener(Shape3DChangeListener listener) {
        return this.rawBox3D.removeChangeListener(listener);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameSTPBox3DReadOnly) {
            return FrameSTPBox3DBasics.super.equals((FrameSTPBox3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        long hash = EuclidHashCodeTools.combineHashCode((long)this.rawBox3D.hashCode(), (long)EuclidHashCodeTools.toLongHashCode((double)this.minimumMargin, (double)this.maximumMargin));
        return EuclidHashCodeTools.toIntHashCode((long)hash);
    }

    public String toString() {
        String stpSuffix = String.format(", small radius: " + EuclidCoreIOTools.DEFAULT_FORMAT + ", large radius: " + EuclidCoreIOTools.DEFAULT_FORMAT + "]", this.getSmallRadius(), this.getLargeRadius());
        return "STP " + EuclidFrameShapeIOTools.getFrameBox3DString((FrameBox3DReadOnly)this).replace("]", stpSuffix);
    }
}

