/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.algorithms;

import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameSphere3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;

public class SphereWithConvexPolygonIntersector {
    private final FramePoint3D closestPointOnPolygon = new FramePoint3D();
    private final FramePoint2D closestPointOnPolygon2d = new FramePoint2D();

    public boolean checkIfIntersectionExists(FrameSphere3D sphere, FrameConvexPolygon2D polygon) {
        ReferenceFrame originalSphereFrame = sphere.getReferenceFrame();
        sphere.changeFrame(polygon.getReferenceFrame());
        this.closestPointOnPolygon.setIncludingFrame((FrameTuple3DReadOnly)sphere.getPosition());
        this.closestPointOnPolygon2d.setIncludingFrame((FrameTuple3DReadOnly)this.closestPointOnPolygon);
        FramePoint2D pointUnsafe = this.closestPointOnPolygon2d;
        polygon.orthogonalProjection((Point2DBasics)pointUnsafe);
        this.closestPointOnPolygon2d.set(pointUnsafe.getX(), pointUnsafe.getY());
        this.closestPointOnPolygon.set((FrameTuple2DReadOnly)this.closestPointOnPolygon2d, 0.0);
        boolean isInsideOrOnSurface = sphere.isPointInside((FramePoint3DReadOnly)this.closestPointOnPolygon);
        this.closestPointOnPolygon.changeFrame(ReferenceFrame.getWorldFrame());
        sphere.changeFrame(originalSphereFrame);
        return isInsideOrOnSurface;
    }

    public FramePoint3D getClosestPointOnPolygon() {
        return this.closestPointOnPolygon;
    }
}

