/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.geometry.AngleTools;

public class SpiralBasedAlgorithm {
    public static Point3D[] generatePointsOnSphere(double sphereRadius, int numberOfPointsToGenerate) {
        return SpiralBasedAlgorithm.generatePointsOnSphere((Point3DReadOnly)new Point3D(), sphereRadius, numberOfPointsToGenerate, SpiralBasedAlgorithm.computeMagicDeltaN(numberOfPointsToGenerate));
    }

    public static Point3D[] generatePointsOnSphere(double sphereRadius, int numberOfPointsToGenerate, double deltaN) {
        return SpiralBasedAlgorithm.generatePointsOnSphere((Point3DReadOnly)new Point3D(), sphereRadius, numberOfPointsToGenerate, deltaN);
    }

    public static Point3D[] generatePointsOnSphere(Point3DReadOnly sphereOrigin, double sphereRadius, int numberOfPointsToGenerate) {
        return SpiralBasedAlgorithm.generatePointsOnSphere(sphereOrigin, sphereRadius, numberOfPointsToGenerate, SpiralBasedAlgorithm.computeMagicDeltaN(numberOfPointsToGenerate));
    }

    public static Point3D[] generatePointsOnSphere(Point3DReadOnly sphereOrigin, double sphereRadius, int numberOfPointsToGenerate, double deltaN) {
        Point3D[] pointsOnSphere = new Point3D[numberOfPointsToGenerate];
        double previousPhi = 0.0;
        pointsOnSphere[0] = new Point3D();
        pointsOnSphere[0].set(0.0, 0.0, -sphereRadius);
        pointsOnSphere[0].add((Tuple3DReadOnly)sphereOrigin);
        for (int planeIndex = 1; planeIndex < numberOfPointsToGenerate - 1; ++planeIndex) {
            double unitHeight = -1.0 + 2.0 * (double)planeIndex / ((double)numberOfPointsToGenerate - 1.0);
            double theta = Math.acos(unitHeight);
            double phi = previousPhi + deltaN / Math.sqrt(1.0 - unitHeight * unitHeight);
            AngleTools.trimAngleMinusPiToPi(phi);
            double rSinTheta = sphereRadius * Math.sin(theta);
            pointsOnSphere[planeIndex] = new Point3D();
            pointsOnSphere[planeIndex].setX(rSinTheta * Math.cos(phi));
            pointsOnSphere[planeIndex].setY(rSinTheta * Math.sin(phi));
            pointsOnSphere[planeIndex].setZ(sphereRadius * Math.cos(theta));
            pointsOnSphere[planeIndex].add((Tuple3DReadOnly)sphereOrigin);
            previousPhi = phi;
        }
        pointsOnSphere[numberOfPointsToGenerate - 1] = new Point3D();
        pointsOnSphere[numberOfPointsToGenerate - 1].set(0.0, 0.0, sphereRadius);
        pointsOnSphere[numberOfPointsToGenerate - 1].add((Tuple3DReadOnly)sphereOrigin);
        return pointsOnSphere;
    }

    public static Quaternion[][] generateOrientations(int numberOfRays, int numberOfRotationsAroundRay) {
        return SpiralBasedAlgorithm.generateOrientations(numberOfRays, numberOfRotationsAroundRay, SpiralBasedAlgorithm.computeMagicDeltaN(numberOfRays));
    }

    public static Quaternion[][] generateOrientations(int numberOfRays, int numberOfRotationsAroundRay, double deltaN) {
        Quaternion[][] rotations = new Quaternion[numberOfRays][numberOfRotationsAroundRay];
        Point3D sphereOrigin = new Point3D();
        Vector3D rayThroughSphere = new Vector3D();
        Point3D[] pointsOnSphere = SpiralBasedAlgorithm.generatePointsOnSphere(0.01, numberOfRays, deltaN);
        Quaternion rotationForXAxisAlignedWithRay = new Quaternion();
        double stepSizeAngleArounRay = Math.PI * 2 / (double)numberOfRotationsAroundRay;
        for (int rayIndex = 0; rayIndex < numberOfRays; ++rayIndex) {
            rayThroughSphere.sub((Tuple3DReadOnly)sphereOrigin, (Tuple3DReadOnly)pointsOnSphere[rayIndex]);
            rayThroughSphere.normalize();
            EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)Axis3D.X, (Vector3DReadOnly)rayThroughSphere, (Orientation3DBasics)rotationForXAxisAlignedWithRay);
            for (int rotationAroundRayIndex = 0; rotationAroundRayIndex < numberOfRotationsAroundRay; ++rotationAroundRayIndex) {
                double angle = (double)rotationAroundRayIndex * stepSizeAngleArounRay;
                Quaternion rotation = new Quaternion((QuaternionReadOnly)rotationForXAxisAlignedWithRay);
                rotation.appendRollRotation(angle);
                rotations[rayIndex][rotationAroundRayIndex] = rotation;
            }
        }
        return rotations;
    }

    public static double computeMagicDeltaN(int numberOfPointsToGenerate) {
        double deltaN = 3.6 / Math.sqrt(numberOfPointsToGenerate);
        return deltaN;
    }
}

