/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;

public class Point2dInConvexPolygon2d
extends Point2D {
    private static final long serialVersionUID = 5818978949209007789L;
    protected ConvexPolygon2D polygon;
    private final Point2D origin = new Point2D(0.0, 0.0);

    public Point2dInConvexPolygon2d(ConvexPolygon2D polygon, double x, double y) {
        super(x, y);
        this.polygon = polygon;
    }

    public boolean isPointInsidePolygon() {
        return this.polygon.isPointInside((Point2DReadOnly)this);
    }

    public void setEccentricity(double r) {
        r = Math.max(r, 1.0E-5);
        double e = this.getEccentricity();
        this.scale(r / e);
    }

    public void setAngle(double angle) {
        Point2DBasics point = this.findEdgePoint(angle);
        point.scale(this.getEccentricity());
        this.set((Tuple2DReadOnly)point);
    }

    public double getAngle() {
        return Math.atan2(this.getY(), this.getX());
    }

    public double getEccentricity() {
        Point2DBasics edgePoint = this.findEdgePoint(this.getX(), this.getY());
        return Math.max(0.001, this.distance((Point2DReadOnly)this.origin) / edgePoint.distance((Point2DReadOnly)this.origin));
    }

    private Point2DBasics findEdgePoint(double angle) {
        return this.findEdgePoint(Math.cos(angle), Math.sin(angle));
    }

    private Point2DBasics findEdgePoint(double x, double y) {
        Line2D ray;
        Point2DBasics[] edgePoints;
        if (x == 0.0 && y == 0.0) {
            x = 1.0;
        }
        if ((edgePoints = this.polygon.intersectionWithRay((Line2DReadOnly)(ray = new Line2D((Point2DReadOnly)new Point2D(0.0, 0.0), (Vector2DReadOnly)new Vector2D(x, y))))).length != 1) {
            throw new RuntimeException("intersecting points should be 1, but we get" + edgePoints.length);
        }
        return edgePoints[0];
    }
}

