/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRamp3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameConvexPolytope3DReadOnly;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameFace3DReadOnly;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameVertex3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class PlanerRegionBuilderTools {
    public static PlanarRegionsList createRegionsFromBox(FrameBox3DReadOnly box) {
        return PlanerRegionBuilderTools.createRegionsFromPolytope((ReferenceFrameHolder)box, (FrameConvexPolytope3DReadOnly)box.asConvexPolytope());
    }

    public static PlanarRegionsList createRegionsFromRamp(FrameRamp3DReadOnly ramp) {
        return PlanerRegionBuilderTools.createRegionsFromPolytope((ReferenceFrameHolder)ramp, (FrameConvexPolytope3DReadOnly)ramp.asConvexPolytope());
    }

    public static PlanarRegionsList createRegionsFromPolytope(ReferenceFrameHolder referenceFrameHolder, FrameConvexPolytope3DReadOnly frameConvexPolytope3DReadOnly) {
        PlanarRegionsList planarRegions = new PlanarRegionsList();
        PoseReferenceFrame faceFrame = new PoseReferenceFrame("faceFrame", referenceFrameHolder.getReferenceFrame());
        for (FrameFace3DReadOnly face : frameConvexPolytope3DReadOnly.getFaces()) {
            Quaternion faceOrientation = new Quaternion();
            EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)face.getNormal(), (Orientation3DBasics)faceOrientation);
            faceFrame.setPoseAndUpdate((Point3DReadOnly)face.getCentroid(), (Orientation3DReadOnly)faceOrientation);
            FrameConvexPolygon2D faceAsPolygon = new FrameConvexPolygon2D((ReferenceFrame)faceFrame);
            for (FrameVertex3DReadOnly vertex : face.getVertices()) {
                FramePoint3D faceFrameVertex = new FramePoint3D((FrameTuple3DReadOnly)vertex);
                faceFrameVertex.changeFrame((ReferenceFrame)faceFrame);
                faceAsPolygon.addVertex((FramePoint3DReadOnly)faceFrameVertex);
            }
            faceAsPolygon.update();
            planarRegions.addPlanarRegion(new PlanarRegion((RigidBodyTransformReadOnly)faceFrame.getTransformToWorldFrame(), (Vertex2DSupplier)faceAsPolygon));
        }
        return planarRegions;
    }

    public static void setRegionsIds(PlanarRegionsList planarRegions) {
        PlanerRegionBuilderTools.setRegionsIds(0, planarRegions);
    }

    public static void setRegionsIds(int startId, PlanarRegionsList planarRegions) {
        for (int i = 0; i < planarRegions.getNumberOfPlanarRegions(); ++i) {
            planarRegions.getPlanarRegion(i).setRegionId(startId + i);
        }
    }
}

