/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.robotics.RegionInWorldInterface;

public class PlanarLandmark
implements RegionInWorldInterface<PlanarLandmark> {
    private int id;
    private double area = 0.0;
    private final Plane3D plane;
    private final RigidBodyTransform fromLocalToWorldTransform = new RigidBodyTransform();
    private final RigidBodyTransform fromWorldToLocalTransform = new RigidBodyTransform();
    private final BoundingBox3D boundingBox3dInWorld = new BoundingBox3D((Point3DReadOnly)new Point3D(Double.NaN, Double.NaN, Double.NaN), (Point3DReadOnly)new Point3D(Double.NaN, Double.NaN, Double.NaN));

    public PlanarLandmark(int id, Plane3D plane, BoundingBox3D boundingBox3dInWorld, RigidBodyTransformReadOnly fromLocalToWorldTransform, double area) {
        this.id = id;
        this.plane = plane;
        this.boundingBox3dInWorld.set(boundingBox3dInWorld);
        this.fromLocalToWorldTransform.set(fromLocalToWorldTransform);
        this.fromWorldToLocalTransform.setAndInvert(fromLocalToWorldTransform);
        this.area = area;
    }

    public PlanarLandmark(PlanarLandmark other) {
        this.id = other.id;
        this.plane = new Plane3D(other.plane);
        this.area = other.area;
        this.fromLocalToWorldTransform.set(other.fromLocalToWorldTransform);
        this.fromWorldToLocalTransform.set(other.fromWorldToLocalTransform);
        this.boundingBox3dInWorld.set(other.boundingBox3dInWorld);
    }

    @Override
    public int getRegionId() {
        return this.id;
    }

    @Override
    public RigidBodyTransformReadOnly getTransformToLocal() {
        return this.fromWorldToLocalTransform;
    }

    @Override
    public RigidBodyTransformReadOnly getTransformToWorld() {
        return this.fromLocalToWorldTransform;
    }

    @Override
    public BoundingBox3DReadOnly getBoundingBox3dInWorld() {
        return this.boundingBox3dInWorld;
    }

    public Point3DReadOnly getPoint() {
        return this.plane.getPoint();
    }

    public UnitVector3DReadOnly getNormal() {
        return this.plane.getNormal();
    }

    public void set(PlanarLandmark other) {
        this.plane.set(other.plane);
        this.area = other.area;
        this.fromLocalToWorldTransform.set(other.fromLocalToWorldTransform);
        this.fromWorldToLocalTransform.set(other.fromWorldToLocalTransform);
        this.boundingBox3dInWorld.set(other.boundingBox3dInWorld);
        this.id = other.id;
    }

    @Override
    public boolean isPointInside(double xInLocal, double yInLocal) {
        return false;
    }

    public void applyTransform(RigidBodyTransformReadOnly transform) {
        this.plane.applyTransform((Transform)transform);
        this.fromLocalToWorldTransform.multiply(transform);
        this.fromWorldToLocalTransform.multiply(transform);
    }
}

