/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.List;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.geometry.PlaneFitter;

public class LeastSquaresZPlaneFitter
implements PlaneFitter {
    private final DMatrixRMaj covarianceMatrix = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj zVarianceVector = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj coefficients = new DMatrixRMaj(3, 1);

    public static boolean checkDistanceThreshold(List<Point3D> point3dList, Plane3D plane3d, double threshold) {
        if (plane3d.containsNaN()) {
            return false;
        }
        for (Point3D point3d : point3dList) {
            double distance = plane3d.distance((Point3DReadOnly)point3d);
            if (!(distance > threshold)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkZDistanceThreshold(List<Point3D> point3dList, double[] xyCCoefficients, double threshold) {
        if (xyCCoefficients.length != 3) {
            return false;
        }
        for (Point3D point3d : point3dList) {
            if (!(Math.abs(point3d.getZ() + xyCCoefficients[0] * point3d.getX() + xyCCoefficients[1] * point3d.getY() + xyCCoefficients[2]) > threshold)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double fitPlaneToPoints(Point2DBasics center, List<? extends Point3DReadOnly> pointList, Plane3D planeToPack) {
        double squareError = this.fitPlaneToPoints(pointList, planeToPack);
        if (planeToPack.containsNaN()) {
            return Double.POSITIVE_INFINITY;
        }
        double centerZ = planeToPack.getZOnPlane(center.getX(), center.getY());
        Point3D planePoint = new Point3D(center.getX(), center.getY(), centerZ);
        planeToPack.getPoint().set((Tuple3DReadOnly)planePoint);
        return squareError;
    }

    @Override
    public double fitPlaneToPoints(List<? extends Point3DReadOnly> pointList, Plane3D planeToPack) {
        double n = 0.0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double xx = 0.0;
        double xy = 0.0;
        double yy = 0.0;
        double xz = 0.0;
        double yz = 0.0;
        double zz = 0.0;
        if (pointList.size() < 3) {
            planeToPack.setToNaN();
            return Double.POSITIVE_INFINITY;
        }
        for (int i = 0; i < pointList.size(); ++i) {
            Point3DReadOnly point3d = pointList.get(i);
            n += 1.0;
            x += point3d.getX();
            y += point3d.getY();
            z += point3d.getZ();
            xx += Math.pow(point3d.getX(), 2.0);
            xy += point3d.getX() * point3d.getY();
            xz += point3d.getX() * point3d.getZ();
            yy += Math.pow(point3d.getY(), 2.0);
            yz += point3d.getY() * point3d.getZ();
            zz += point3d.getZ() * point3d.getZ();
        }
        this.covarianceMatrix.set(0, 0, xx);
        this.covarianceMatrix.set(0, 1, xy);
        this.covarianceMatrix.set(0, 2, x);
        this.covarianceMatrix.set(1, 0, xy);
        this.covarianceMatrix.set(1, 1, yy);
        this.covarianceMatrix.set(1, 2, y);
        this.covarianceMatrix.set(2, 0, x);
        this.covarianceMatrix.set(2, 1, y);
        this.covarianceMatrix.set(2, 2, n);
        this.zVarianceVector.set(0, 0, -1.0 * xz);
        this.zVarianceVector.set(1, 0, -1.0 * yz);
        this.zVarianceVector.set(2, 0, -1.0 * z);
        CommonOps_DDRM.invert((DMatrixRMaj)this.covarianceMatrix);
        CommonOps_DDRM.mult((DMatrix1Row)this.covarianceMatrix, (DMatrix1Row)this.zVarianceVector, (DMatrix1Row)this.coefficients);
        double xSolution = x / n;
        double ySolution = y / n;
        double zSolution = -this.coefficients.get(0) * xSolution - this.coefficients.get(1) * ySolution - this.coefficients.get(2);
        if (Double.isNaN(zSolution)) {
            planeToPack.setToNaN();
            return Double.POSITIVE_INFINITY;
        }
        planeToPack.getPoint().set(xSolution, ySolution, zSolution);
        planeToPack.getNormal().set(this.coefficients.get(0), this.coefficients.get(1), 1.0);
        double squaredError = 0.0;
        double A = this.coefficients.get(0);
        double B = this.coefficients.get(1);
        double C = this.coefficients.get(2);
        squaredError = A * A * xx + 2.0 * A * B * xy + 2.0 * A * xz + 2.0 * A * C * x + B * B * yy + 2.0 * B * yz + 2.0 * B * C * y + zz + 2.0 * C * z + C * C;
        return squaredError / n;
    }
}

