/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.robotics.dataStructures.HeightMapWithPoints;
import us.ihmc.robotics.geometry.InclusionFunction;
import us.ihmc.robotics.geometry.InsufficientDataException;
import us.ihmc.robotics.geometry.LeastSquaresZPlaneFitter;
import us.ihmc.robotics.geometry.PlaneFitter;

public class HeightMapBestFitPlaneCalculator {
    private List<Point3D> pointList = new ArrayList<Point3D>();
    private final PlaneFitter planeFitter = new LeastSquaresZPlaneFitter();

    public Plane3D calculatePlane(HeightMapWithPoints heightMap, Point2DBasics center, double kernelSizeX, double kernelSizeY) throws InsufficientDataException {
        if (kernelSizeX == 0.0 || kernelSizeY == 0.0) {
            throw new RuntimeException("empty search region.");
        }
        this.pointList = heightMap.getAllPointsWithinArea(center.getX(), center.getY(), kernelSizeX, kernelSizeY);
        Plane3D ret = new Plane3D();
        this.planeFitter.fitPlaneToPoints(center, this.pointList, ret);
        return ret;
    }

    public Plane3D calculatePlane(HeightMapWithPoints heightMap, Point2DBasics center, double xExtent, double yExtent, InclusionFunction<Point3D> kernelMask) throws InsufficientDataException {
        if (xExtent == 0.0 || yExtent == 0.0) {
            throw new RuntimeException("empty search region.");
        }
        this.pointList = heightMap.getAllPointsWithinArea(center.getX(), center.getY(), xExtent, yExtent, kernelMask);
        Plane3D ret = new Plane3D();
        this.planeFitter.fitPlaneToPoints(center, this.pointList, ret);
        return ret;
    }

    public List<Point3D> getPointList() {
        return this.pointList;
    }
}

