/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;

public class BoundingBoxKDTree2D {
    private KDTreeNode rootKDTreeNode = new KDTreeNode(null);
    private ArrayList<BoundingBox2D> allboundingBoxes;
    private int uniqueIdForDisplay = 0;
    private final ArrayList<Object> allObjects;
    private final int MAX_LEAF_SIZE = 5;

    public BoundingBoxKDTree2D(ArrayList<BoundingBox2D> boundingBoxes, ArrayList<Object> objects) {
        this.allboundingBoxes = boundingBoxes;
        this.allObjects = objects;
        if (this.allboundingBoxes.size() != this.allObjects.size()) {
            System.err.println("KDTree::KDTree(): number of points and objects differ.");
        }
        this.buildKDTree(boundingBoxes, 0, this.rootKDTreeNode, objects);
    }

    private KDTreeNode buildKDTree(ArrayList<BoundingBox2D> boundingBoxes, int depth, KDTreeNode nodeToExpand, ArrayList<Object> objects) {
        ArrayList[] split = new ArrayList[2];
        ArrayList[] objectSplit = new ArrayList[2];
        if (boundingBoxes.size() <= 5) {
            nodeToExpand.boundingBoxes = boundingBoxes;
            nodeToExpand.objects = objects;
            nodeToExpand.leafNode = true;
        } else {
            if (depth % 2 == 0) {
                nodeToExpand.splitHorizontal = false;
                split = this.splitInXPlane(boundingBoxes, nodeToExpand, objects, objectSplit);
            } else {
                nodeToExpand.splitHorizontal = true;
                split = this.splitInYPlane(boundingBoxes, nodeToExpand, objects, objectSplit);
            }
            if (split[0].size() == boundingBoxes.size() || split[1].size() == boundingBoxes.size()) {
                nodeToExpand.leafNode = true;
                nodeToExpand.boundingBoxes = boundingBoxes;
                nodeToExpand.objects = objects;
                return nodeToExpand;
            }
            nodeToExpand.left = this.buildKDTree(split[0], depth + 1, new KDTreeNode(nodeToExpand), objectSplit[0]);
            if (!nodeToExpand.leafNode) {
                nodeToExpand.right = this.buildKDTree(split[1], depth + 1, new KDTreeNode(nodeToExpand), objectSplit[1]);
            }
        }
        return nodeToExpand;
    }

    public ArrayList<BoundingBox2D> getIntersectingBoundingBoxes(BoundingBox2D searchBox) {
        ArrayList<BoundingBox2D> intersectingBoundingBoxes = new ArrayList<BoundingBox2D>();
        ArrayList<Object> intersectingObjects = new ArrayList<Object>();
        this.getIntersectingBoundingBoxes(searchBox, this.rootKDTreeNode, 0, intersectingBoundingBoxes, intersectingObjects);
        return intersectingBoundingBoxes;
    }

    public ArrayList<Object> getIntersectingObjects(BoundingBox2D searchBox) {
        ArrayList<BoundingBox2D> intersectingBoundingBoxes = new ArrayList<BoundingBox2D>();
        ArrayList<Object> intersectingObjects = new ArrayList<Object>();
        this.getIntersectingBoundingBoxes(searchBox, this.rootKDTreeNode, 0, intersectingBoundingBoxes, intersectingObjects);
        return intersectingObjects;
    }

    private void getIntersectingBoundingBoxes(BoundingBox2D searchBox, KDTreeNode current, int depth, ArrayList<BoundingBox2D> intersectingBoundingBoxes, ArrayList<Object> intersectingObjects) {
        if (current.leafNode) {
            this.addToReturnList(current.boundingBoxes, current.objects, searchBox, intersectingBoundingBoxes, intersectingObjects);
        } else if (depth % 2 == 0) {
            if (searchBox.getMaxX() <= current.split) {
                this.getIntersectingBoundingBoxes(searchBox, current.left, depth + 1, intersectingBoundingBoxes, intersectingObjects);
            } else if (searchBox.getMinX() >= current.split) {
                this.getIntersectingBoundingBoxes(searchBox, current.right, depth + 1, intersectingBoundingBoxes, intersectingObjects);
            } else {
                this.getIntersectingBoundingBoxes(searchBox, current.left, depth + 1, intersectingBoundingBoxes, intersectingObjects);
                this.getIntersectingBoundingBoxes(searchBox, current.right, depth + 1, intersectingBoundingBoxes, intersectingObjects);
            }
        } else if (searchBox.getMinY() >= current.split) {
            this.getIntersectingBoundingBoxes(searchBox, current.left, depth + 1, intersectingBoundingBoxes, intersectingObjects);
        } else if (searchBox.getMaxY() <= current.split) {
            this.getIntersectingBoundingBoxes(searchBox, current.right, depth + 1, intersectingBoundingBoxes, intersectingObjects);
        } else {
            this.getIntersectingBoundingBoxes(searchBox, current.left, depth + 1, intersectingBoundingBoxes, intersectingObjects);
            this.getIntersectingBoundingBoxes(searchBox, current.right, depth + 1, intersectingBoundingBoxes, intersectingObjects);
        }
    }

    private void addToReturnList(ArrayList<BoundingBox2D> currentBoxes, ArrayList<Object> currentObjects, BoundingBox2D searchBox, ArrayList<BoundingBox2D> intersectingBoundingBoxes, ArrayList<Object> intersectingObjects) {
        for (int i = 0; i < currentBoxes.size(); ++i) {
            if (intersectingBoundingBoxes.contains(currentBoxes.get(i)) || !searchBox.intersectsInclusive((BoundingBox2DReadOnly)currentBoxes.get(i))) continue;
            intersectingBoundingBoxes.add(currentBoxes.get(i));
            intersectingObjects.add(currentObjects.get(i));
        }
    }

    private ArrayList<BoundingBox2D>[] splitInXPlane(ArrayList<BoundingBox2D> boundingBoxes, KDTreeNode current, ArrayList<Object> objects, ArrayList<Object>[] objectSplit) {
        double median;
        ArrayList<BoundingBox2D> leftList = new ArrayList<BoundingBox2D>();
        ArrayList<BoundingBox2D> rightList = new ArrayList<BoundingBox2D>();
        ArrayList<Object> leftObjectList = new ArrayList<Object>();
        ArrayList<Object> rightObjectList = new ArrayList<Object>();
        ArrayList[] returnList = new ArrayList[2];
        Point2D center = new Point2D();
        Point2D minPoint = new Point2D();
        Point2D maxPoint = new Point2D();
        double[] midPointsX = new double[boundingBoxes.size()];
        for (int i = 0; i < boundingBoxes.size(); ++i) {
            boundingBoxes.get(i).getCenterPoint((Point2DBasics)center);
            midPointsX[i] = center.getX();
        }
        current.split = median = this.getMedian((double[])midPointsX.clone());
        for (int i = 0; i < boundingBoxes.size(); ++i) {
            minPoint.set(boundingBoxes.get(i).getMinPoint());
            maxPoint.set(boundingBoxes.get(i).getMaxPoint());
            if (median <= minPoint.getX()) {
                rightList.add(boundingBoxes.get(i));
                rightObjectList.add(objects.get(i));
                continue;
            }
            if (median >= maxPoint.getX()) {
                leftList.add(boundingBoxes.get(i));
                leftObjectList.add(objects.get(i));
                continue;
            }
            rightList.add(boundingBoxes.get(i));
            rightObjectList.add(objects.get(i));
            leftList.add(boundingBoxes.get(i));
            leftObjectList.add(objects.get(i));
        }
        returnList[0] = leftList;
        returnList[1] = rightList;
        objectSplit[0] = leftObjectList;
        objectSplit[1] = rightObjectList;
        return returnList;
    }

    private ArrayList<BoundingBox2D>[] splitInYPlane(ArrayList<BoundingBox2D> boundingBoxes, KDTreeNode current, ArrayList<Object> objects, ArrayList<Object>[] objectSplit) {
        double median;
        ArrayList<BoundingBox2D> upperList = new ArrayList<BoundingBox2D>();
        ArrayList<BoundingBox2D> lowerList = new ArrayList<BoundingBox2D>();
        ArrayList<Object> upperObjectList = new ArrayList<Object>();
        ArrayList<Object> lowerObjectList = new ArrayList<Object>();
        ArrayList[] returnList = new ArrayList[2];
        Point2D center = new Point2D();
        Point2D minPoint = new Point2D();
        Point2D maxPoint = new Point2D();
        double[] midPointsY = new double[boundingBoxes.size()];
        for (int i = 0; i < boundingBoxes.size(); ++i) {
            boundingBoxes.get(i).getCenterPoint((Point2DBasics)center);
            midPointsY[i] = center.getY();
        }
        current.split = median = this.getMedian((double[])midPointsY.clone());
        for (int i = 0; i < boundingBoxes.size(); ++i) {
            minPoint.set(boundingBoxes.get(i).getMinPoint());
            maxPoint.set(boundingBoxes.get(i).getMaxPoint());
            if (median <= minPoint.getY()) {
                upperList.add(boundingBoxes.get(i));
                upperObjectList.add(objects.get(i));
                continue;
            }
            if (median >= maxPoint.getY()) {
                lowerList.add(boundingBoxes.get(i));
                lowerObjectList.add(objects.get(i));
                continue;
            }
            upperList.add(boundingBoxes.get(i));
            upperObjectList.add(objects.get(i));
            lowerList.add(boundingBoxes.get(i));
            lowerObjectList.add(objects.get(i));
        }
        returnList[0] = upperList;
        returnList[1] = lowerList;
        objectSplit[0] = upperObjectList;
        objectSplit[1] = lowerObjectList;
        return returnList;
    }

    private double getMedian(double[] list) {
        Arrays.sort(list);
        int middle = list.length / 2;
        if (list.length % 2 == 1) {
            return list[middle];
        }
        return (list[middle - 1] + list[middle]) / 2.0;
    }

    private class KDTreeNode {
        private double split;
        private boolean splitHorizontal;
        private KDTreeNode left = null;
        private KDTreeNode right = null;
        private KDTreeNode parent = null;
        private boolean leafNode = false;
        private ArrayList<BoundingBox2D> boundingBoxes;
        private ArrayList<Object> objects;

        private KDTreeNode(KDTreeNode parent) {
            this.parent = parent;
        }
    }
}

