/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.Random;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePose2D;
import us.ihmc.euclid.tuple2D.Point2D32;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion32;

public class AngleTools {
    public static final double PI = Math.PI;
    public static final double TwoPI = Math.PI * 2;
    public static final double EPSILON = 1.0E-10;

    private AngleTools() {
    }

    public static double trimAngleMinusPiToPi(double angle) {
        return AngleTools.shiftAngleToStartOfRange(angle, -Math.PI);
    }

    public static float getAngle(Quaternion32 q) {
        return 2.0f * (float)Math.acos(q.getS());
    }

    public static double angleMinusPiToPi(Vector2DReadOnly startVector, Vector2DReadOnly endVector) {
        double absoluteAngle = Math.acos(startVector.dot((Tuple2DReadOnly)endVector) / startVector.length() / endVector.length());
        Vector3D start3d = new Vector3D(startVector.getX(), startVector.getY(), 0.0);
        Vector3D end3d = new Vector3D(endVector.getX(), endVector.getY(), 0.0);
        Vector3D crossProduct = new Vector3D();
        crossProduct.cross((Tuple3DReadOnly)start3d, (Tuple3DReadOnly)end3d);
        if (crossProduct.getZ() >= 0.0) {
            return absoluteAngle;
        }
        return -absoluteAngle;
    }

    public static double computeAngleAverage(double angleA, double angleB) {
        return AngleTools.interpolateAngle(angleA, angleB, 0.5);
    }

    public static double interpolateAngle(double angleA, double angleB, double alpha) {
        double average = angleA + alpha * AngleTools.computeAngleDifferenceMinusPiToPi(angleB, angleA);
        return AngleTools.trimAngleMinusPiToPi(average);
    }

    public static double computeAngleAverage(double[] angles) {
        double average = 0.0;
        double averageOfSin = 0.0;
        double averageOfCos = 0.0;
        double weight = 1.0 / (double)angles.length;
        for (int i = 0; i < angles.length; ++i) {
            averageOfSin += weight * Math.sin(angles[i]);
            averageOfCos += weight * Math.cos(angles[i]);
        }
        average = Math.atan2(averageOfSin, averageOfCos);
        return average;
    }

    public static int findClosestNinetyDegreeYaw(double yawInRadians) {
        double minDifference = Double.POSITIVE_INFINITY;
        int ret = -1;
        double difference = AngleTools.computeAngleDifferenceMinusPiToPi(yawInRadians, 0.0);
        minDifference = Math.abs(difference);
        ret = 0;
        difference = AngleTools.computeAngleDifferenceMinusPiToPi(yawInRadians, 1.5707963267948966);
        if (Math.abs(difference) < minDifference) {
            minDifference = Math.abs(difference);
            ret = 1;
        }
        if (Math.abs(difference = AngleTools.computeAngleDifferenceMinusPiToPi(yawInRadians, Math.PI)) < minDifference) {
            minDifference = Math.abs(difference);
            ret = 2;
        }
        if (Math.abs(difference = AngleTools.computeAngleDifferenceMinusPiToPi(yawInRadians, 4.71238898038469)) < minDifference) {
            minDifference = Math.abs(difference);
            ret = 3;
        }
        return ret;
    }

    public static double computeAngleDifferenceMinusPiToPi(double angleA, double angleB) {
        double difference = angleA - angleB;
        difference %= Math.PI * 2;
        difference = AngleTools.shiftAngleToStartOfRange(difference, -Math.PI);
        return difference;
    }

    public static double computeAngleDifferenceMinusTwoPiToZero(double angleA, double angleB) {
        double difference = angleA - angleB;
        difference %= Math.PI * 2;
        difference = AngleTools.shiftAngleToStartOfRange(difference, Math.PI * -2);
        return difference;
    }

    public static double shiftAngleToStartOfRange(double angleToShift, double startOfAngleRange) {
        return AngleTools.shiftAngleToStartOfRange(angleToShift, startOfAngleRange, Math.PI * 2);
    }

    public static double shiftAngleToStartOfRange(double angleToShift, double startOfAngleRange, double endOfAngleRange) {
        double ret = angleToShift;
        if (angleToShift < (startOfAngleRange -= 1.0E-10)) {
            ret = angleToShift + Math.ceil((startOfAngleRange - angleToShift) / endOfAngleRange) * endOfAngleRange;
        }
        if (angleToShift >= startOfAngleRange + endOfAngleRange) {
            ret = angleToShift - Math.floor((angleToShift - startOfAngleRange) / endOfAngleRange) * endOfAngleRange;
        }
        return ret;
    }

    public static double generateRandomAngle(Random random) {
        return Math.PI * -2 + Math.PI * 4 * random.nextDouble();
    }

    public static double[] generateArrayOfTestAngles(int numberOfAngles, double stayThisFarAwayFromPlusMinus2PI, boolean includeZero, boolean includePlusMinusPI) {
        int arraySize = numberOfAngles;
        double epsilon = stayThisFarAwayFromPlusMinus2PI;
        if (includeZero && !includePlusMinusPI) {
            ++arraySize;
        } else if (includePlusMinusPI && !includeZero) {
            arraySize += 2;
        } else if (includeZero && includePlusMinusPI) {
            arraySize += 3;
        }
        double thetaMin = Math.PI * -2 + stayThisFarAwayFromPlusMinus2PI;
        double thetaMax = Math.PI * 2 - stayThisFarAwayFromPlusMinus2PI;
        double deltaTheta = Math.abs(thetaMax - thetaMin) / (double)(numberOfAngles - 1);
        double[] ret = new double[arraySize];
        for (int i = 0; i < numberOfAngles; ++i) {
            ret[i] = thetaMin + deltaTheta * (double)i;
            boolean epsilonEqualToZero = MathTools.epsilonEquals((double)Math.abs(ret[i]), (double)0.0, (double)epsilon);
            boolean epsilonEqualToPlusMinusPI = MathTools.epsilonEquals((double)Math.abs(ret[i]), (double)Math.PI, (double)epsilon);
            if ((!epsilonEqualToZero || includeZero) && (!epsilonEqualToPlusMinusPI || includePlusMinusPI)) continue;
            int n = i;
            ret[n] = ret[n] + Math.signum(ret[i]) * Math.max(1.0E-4, Math.abs(epsilon));
        }
        if (includeZero && !includePlusMinusPI) {
            ret[numberOfAngles] = 0.0;
        } else if (includePlusMinusPI && !includeZero) {
            ret[numberOfAngles] = -Math.PI;
            ret[numberOfAngles + 1] = Math.PI;
        } else if (includeZero && includePlusMinusPI) {
            ret[numberOfAngles] = 0.0;
            ret[numberOfAngles + 1] = -Math.PI;
            ret[numberOfAngles + 2] = Math.PI;
        }
        return ret;
    }

    public static double calculateHeading(FramePose2D startPose, FramePoint2D endPoint, double headingOffset, double noTranslationTolerance) {
        double heading;
        double deltaX = endPoint.getX() - startPose.getX();
        double deltaY = endPoint.getY() - startPose.getY();
        if (Math.abs(deltaX) < noTranslationTolerance && Math.abs(deltaY) < noTranslationTolerance) {
            heading = startPose.getYaw();
        } else {
            double pathHeading = Math.atan2(deltaY, deltaX);
            heading = AngleTools.trimAngleMinusPiToPi(pathHeading + headingOffset);
        }
        return heading;
    }

    public static double calculateHeading(Tuple3DReadOnly startPose, Tuple3DReadOnly endPoint, double headingOffset) {
        double deltaX = endPoint.getX() - startPose.getX();
        double deltaY = endPoint.getY() - startPose.getY();
        double pathHeading = Math.atan2(deltaY, deltaX);
        return AngleTools.trimAngleMinusPiToPi(pathHeading + headingOffset);
    }

    public static double calculateHeading(Point2D32 startPose, Point2D32 endPoint) {
        double deltaX = endPoint.getX() - startPose.getX();
        double deltaY = endPoint.getY() - startPose.getY();
        double pathHeading = Math.atan2(deltaY, deltaX);
        double heading = AngleTools.trimAngleMinusPiToPi(pathHeading);
        return heading;
    }

    public static double angleFromZeroToTwoPi(double vx, double vy) {
        double angleFromNegtivePiToPi = Math.atan2(vy, vx);
        if (angleFromNegtivePiToPi < 0.0) {
            return Math.PI * 2 + angleFromNegtivePiToPi;
        }
        return angleFromNegtivePiToPi;
    }

    public static double roundToGivenPrecisionForAngle(double angleValue, double precisionFactor) {
        double centeredAngleValue = AngleTools.trimAngleMinusPiToPi(angleValue + 0.5 * precisionFactor);
        long longValue = (long)(centeredAngleValue / precisionFactor);
        double roundedValue = (double)longValue * precisionFactor;
        return AngleTools.trimAngleMinusPiToPi(roundedValue);
    }

    public static void roundToGivenPrecisionForAngles(Tuple3DBasics tuple3d, double precision) {
        tuple3d.setX(AngleTools.roundToGivenPrecisionForAngle(tuple3d.getX(), precision));
        tuple3d.setY(AngleTools.roundToGivenPrecisionForAngle(tuple3d.getY(), precision));
        tuple3d.setZ(AngleTools.roundToGivenPrecisionForAngle(tuple3d.getZ(), precision));
    }
}

