/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.functionApproximation;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.robotics.statistics.OnlineCovarianceCalculator;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class OnlineLeastSquaresRegression {
    private final YoDouble intercept;
    private final YoDouble slope;
    private final YoInteger pointsInRegression;
    private final OnlineCovarianceCalculator covarianceCalculator;

    public OnlineLeastSquaresRegression(String prefix, YoRegistry parentRegistry) {
        YoRegistry registry = new YoRegistry(prefix + this.getClass().getSimpleName());
        this.intercept = new YoDouble(prefix + "_Intercept", registry);
        this.slope = new YoDouble(prefix + "_Slope", registry);
        this.covarianceCalculator = new OnlineCovarianceCalculator(prefix, registry);
        this.pointsInRegression = new YoInteger(prefix + "PointsInRegression", registry);
        parentRegistry.addChild(registry);
    }

    public void reset() {
        this.intercept.set(0.0);
        this.slope.set(0.0);
        this.covarianceCalculator.reset();
        this.pointsInRegression.set(0);
    }

    public double computeY(double x) {
        return this.intercept.getDoubleValue() + this.slope.getDoubleValue() * x;
    }

    public void update(Point2DReadOnly point) {
        this.update(point.getX(), point.getY());
    }

    public void update(double x, double y) {
        this.covarianceCalculator.update(x, y);
        this.pointsInRegression.increment();
        if (this.pointsInRegression.getValue() < 2 || this.covarianceCalculator.getXStandardDeviation() == 0.0) {
            return;
        }
        this.slope.set(this.covarianceCalculator.getCorrelation() * this.covarianceCalculator.getYStandardDeviation() / this.covarianceCalculator.getXStandardDeviation());
        this.intercept.set(this.covarianceCalculator.getYMean() - this.slope.getDoubleValue() * this.covarianceCalculator.getXMean());
    }

    public int getPointsInRegression() {
        return this.pointsInRegression.getIntegerValue();
    }

    public double getRSquared() {
        return MathTools.square((double)this.covarianceCalculator.getCorrelation());
    }

    public double getXStandardDeviation() {
        return this.covarianceCalculator.getXStandardDeviation();
    }

    public double getYStandardDeviation() {
        return this.covarianceCalculator.getYStandardDeviation();
    }

    public double getXMean() {
        return this.covarianceCalculator.getXMean();
    }

    public double getYMean() {
        return this.covarianceCalculator.getYMean();
    }
}

