/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.functionApproximation.NeuralNetwork.importing;

import us.ihmc.robotics.functionApproximation.NeuralNetwork.activationFunction.ActivationFunction;
import us.ihmc.robotics.functionApproximation.NeuralNetwork.activationFunction.PassThrough;
import us.ihmc.robotics.functionApproximation.NeuralNetwork.activationFunction.Relu;
import us.ihmc.robotics.functionApproximation.NeuralNetwork.activationFunction.Sigmoid;

public class NeuralNetworkConfiguration {
    private String[] inputVariableNames;
    private String[] outputVariableNames;
    private String[] activationFunctionsPerLayer;
    private int[] numberOfNeuronsPerLayer;
    private double[][] bias;
    private double[][][] weights;

    public String[] getActivationFunctionsPerLayer() {
        return this.activationFunctionsPerLayer;
    }

    public void setActivationFunctionsPerLayer(String[] activationFunctionsPerLayer) {
        this.activationFunctionsPerLayer = activationFunctionsPerLayer;
    }

    public int[] getNumberOfNeuronsPerLayer() {
        return this.numberOfNeuronsPerLayer;
    }

    public void setNumberOfNeuronsPerLayer(int[] numberOfNeuronsPerLayer) {
        this.numberOfNeuronsPerLayer = numberOfNeuronsPerLayer;
    }

    public double[][] getBias() {
        return this.bias;
    }

    public void setBias(double[][] bias) {
        this.bias = bias;
    }

    public double[][][] getWeights() {
        return this.weights;
    }

    public void setWeights(double[][][] weights) {
        this.weights = weights;
    }

    public ActivationFunction[] getActivationFunctions() {
        ActivationFunction[] activationFunctions = new ActivationFunction[this.activationFunctionsPerLayer.length];
        block8: for (int i = 0; i < this.activationFunctionsPerLayer.length; ++i) {
            switch (this.activationFunctionsPerLayer[i]) {
                case "RELU": {
                    activationFunctions[i] = new Relu();
                    continue block8;
                }
                case "SIGMOID": {
                    activationFunctions[i] = new Sigmoid();
                    continue block8;
                }
                default: {
                    activationFunctions[i] = new PassThrough();
                }
            }
        }
        return activationFunctions;
    }

    public String[] getInputVariableNames() {
        return this.inputVariableNames;
    }

    public void setInputVariableNames(String[] inputVariableNames) {
        this.inputVariableNames = inputVariableNames;
    }

    public String[] getOutputVariableNames() {
        return this.outputVariableNames;
    }

    public void setOutputVariableNames(String[] outputVariableNames) {
        this.outputVariableNames = outputVariableNames;
    }
}

