/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.functionApproximation;

import Jama.Matrix;
import java.util.ArrayList;

public class LinearRegression {
    public static boolean VERBOSE = false;
    private Matrix inputMatrix;
    private Matrix outputVector;
    private boolean solved;
    private double error;
    private Matrix betaVector;

    public LinearRegression(Matrix inputData, Matrix outputData) {
        this.setMatrices(inputData, outputData);
    }

    public LinearRegression(ArrayList<double[]> inputs, ArrayList<Double> outputs) {
        double[][] inputArrays = new double[inputs.size()][inputs.get(0).length];
        for (int i = 0; i < inputArrays.length; ++i) {
            inputArrays[i] = inputs.get(i);
        }
        Matrix inputMatrix = new Matrix(inputArrays);
        double[] outputArray = new double[outputs.size()];
        for (int i = 0; i < outputArray.length; ++i) {
            outputArray[i] = outputs.get(i);
        }
        this.setMatrices(inputMatrix, new Matrix(outputArray, outputArray.length));
    }

    public LinearRegression(double[][] inputs, double[] outputs) {
        this.setMatrices(new Matrix(inputs), new Matrix(outputs, outputs.length));
    }

    private void setMatrices(Matrix inputData, Matrix outputData) {
        this.inputMatrix = inputData;
        this.outputVector = outputData;
        this.solved = false;
    }

    public boolean solve() {
        if (this.solved) {
            return true;
        }
        Matrix x = this.inputMatrix;
        Matrix xTrans = this.inputMatrix.transpose();
        Matrix xTransX = xTrans.times(x);
        if (VERBOSE) {
            System.out.println("LinearRegression::solve: X, Y : ");
            this.inputMatrix.print(5, 5);
            this.outputVector.print(5, 5);
            System.out.println("LinearRegression::solve: xTransX.det() : " + xTransX.det());
        }
        if (Math.abs(xTransX.det()) < 1.0E-86) {
            if (VERBOSE) {
                System.out.println("LinearRegression::solve: Determinate of xTransposeX " + xTransX.det() + ", is too small to invert safely");
            }
            return false;
        }
        Matrix xTransXInv = xTransX.inverse();
        Matrix xTransXInvXTrans = xTransXInv.times(xTrans);
        this.betaVector = xTransXInvXTrans.times(this.outputVector);
        Matrix residuals = this.outputVector.minus(x.times(this.betaVector));
        this.error = 0.0;
        for (int i = 0; i < residuals.getColumnDimension(); ++i) {
            this.error += residuals.get(0, i) * residuals.get(0, i);
        }
        this.solved = true;
        return true;
    }

    public double getSquaredError() {
        this.verifySolved();
        return this.error;
    }

    public Matrix getCoefficientVectorAsMatrix() {
        this.verifySolved();
        return this.betaVector;
    }

    public void getCoefficientVector(double[] coefficientVector) {
        this.verifySolved();
        if (coefficientVector.length != this.betaVector.getRowDimension()) {
            throw new IllegalArgumentException("given array must have size " + this.betaVector.getRowDimension());
        }
        for (int i = 0; i < this.betaVector.getRowDimension(); ++i) {
            coefficientVector[i] = this.betaVector.get(i, 0);
        }
    }

    private void verifySolved() {
        if (!this.solved) {
            throw new IllegalStateException("cannot get error before the Regression has been solved");
        }
    }
}

