/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.dataStructures;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorBasics;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.FrameIndexMap;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.YoMutableFrameObject;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class YoMutableFrameSpatialVector
implements SpatialVectorBasics,
YoMutableFrameObject {
    private final YoLong frameId;
    private final FrameIndexMap frameIndexMap;
    private final YoMutableFrameVector3D angularPart;
    private final YoMutableFrameVector3D linearPart;

    public YoMutableFrameSpatialVector(YoMutableFrameVector3D angularPart, YoMutableFrameVector3D linearPart) {
        this.frameId = angularPart.getYoFrameIndex();
        this.frameIndexMap = angularPart.getFrameIndexMap();
        this.angularPart = angularPart;
        this.linearPart = linearPart;
        this.checkFrameConsistency();
    }

    public YoMutableFrameSpatialVector(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.frameId = new YoLong(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "frame", nameSuffix}), registry);
        this.frameIndexMap = new FrameIndexMap.FrameIndexHashMap();
        YoDouble xAngular = new YoDouble(YoGeometryNameTools.createXName((String)namePrefix, (String)("Angular" + nameSuffix)), registry);
        YoDouble yAngular = new YoDouble(YoGeometryNameTools.createYName((String)namePrefix, (String)("Angular" + nameSuffix)), registry);
        YoDouble zAngular = new YoDouble(YoGeometryNameTools.createZName((String)namePrefix, (String)("Angular" + nameSuffix)), registry);
        this.angularPart = new YoMutableFrameVector3D(xAngular, yAngular, zAngular, this.getYoFrameIndex(), this.getFrameIndexMap());
        YoDouble xLinear = new YoDouble(YoGeometryNameTools.createXName((String)namePrefix, (String)("Linear" + nameSuffix)), registry);
        YoDouble yLinear = new YoDouble(YoGeometryNameTools.createYName((String)namePrefix, (String)("Linear" + nameSuffix)), registry);
        YoDouble zLinear = new YoDouble(YoGeometryNameTools.createZName((String)namePrefix, (String)("Linear" + nameSuffix)), registry);
        this.linearPart = new YoMutableFrameVector3D(xLinear, yLinear, zLinear, this.getYoFrameIndex(), this.getFrameIndexMap());
    }

    public FrameIndexMap getFrameIndexMap() {
        return this.frameIndexMap;
    }

    public YoLong getYoFrameIndex() {
        return this.frameId;
    }

    public FixedFrameVector3DBasics getAngularPart() {
        this.checkFrameConsistency();
        return this.angularPart;
    }

    public FixedFrameVector3DBasics getLinearPart() {
        this.checkFrameConsistency();
        return this.linearPart;
    }

    public ReferenceFrame getReferenceFrame() {
        this.checkFrameConsistency();
        return super.getReferenceFrame();
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        super.setReferenceFrame(referenceFrame);
        this.linearPart.setReferenceFrame(referenceFrame);
    }

    private void checkFrameConsistency() {
        this.angularPart.checkReferenceFrameMatch((ReferenceFrameHolder)this.linearPart);
    }
}

