/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers.pidGains.implementations;

import us.ihmc.robotics.controllers.pidGains.PDGainsReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ZeroableYoPDGains
implements PDGainsReadOnly {
    private final YoDouble kp;
    private final YoDouble kd;
    private final YoDouble maximumFeedback;
    private final YoDouble maximumFeedbackRate;
    private final YoDouble positionDeadband;

    public ZeroableYoPDGains(String suffix, YoRegistry registry) {
        this.kp = new YoDouble("kp" + suffix, registry);
        this.kd = new YoDouble("kd" + suffix, registry);
        this.maximumFeedback = new YoDouble("maximumFeedback" + suffix, registry);
        this.maximumFeedbackRate = new YoDouble("maximumFeedbackRate" + suffix, registry);
        this.positionDeadband = new YoDouble("positionDeadband" + suffix, registry);
        this.maximumFeedback.set(Double.POSITIVE_INFINITY);
        this.maximumFeedbackRate.set(Double.POSITIVE_INFINITY);
    }

    public void setKp(double kp) {
        this.kp.set(kp);
    }

    public void setKd(double kd) {
        this.kd.set(kd);
    }

    public void setMaximumFeedback(double maxFeedback) {
        this.maximumFeedback.set(maxFeedback);
    }

    public void setMaximumFeedbackRate(double maxFeedbackRate) {
        this.maximumFeedbackRate.set(maxFeedbackRate);
    }

    public void setMaximumFeedbackAndMaximumFeedbackRate(double maxFeedback, double maxFeedbackRate) {
        this.maximumFeedback.set(maxFeedback);
        this.maximumFeedbackRate.set(maxFeedbackRate);
    }

    public void setPositionDeadband(double deadband) {
        this.positionDeadband.set(deadband);
    }

    @Override
    public double getKp() {
        return this.kp.getDoubleValue();
    }

    @Override
    public double getKd() {
        return this.kd.getDoubleValue();
    }

    @Override
    public double getMaximumFeedback() {
        return this.maximumFeedback.getDoubleValue();
    }

    @Override
    public double getMaximumFeedbackRate() {
        return this.maximumFeedbackRate.getDoubleValue();
    }

    @Override
    public double getPositionDeadband() {
        return this.positionDeadband.getDoubleValue();
    }

    public YoDouble getYoKp() {
        return this.kp;
    }

    public YoDouble getYoKd() {
        return this.kd;
    }

    public YoDouble getYoMaximumFeedback() {
        return this.maximumFeedback;
    }

    public YoDouble getYoMaximumFeedbackRate() {
        return this.maximumFeedbackRate;
    }

    public YoDouble getYoPositionDeadband() {
        return this.positionDeadband;
    }

    public void set(ZeroableYoPDGains other) {
        this.kp.set(other.kp.getDoubleValue());
        this.kd.set(other.kd.getDoubleValue());
        this.maximumFeedback.set(other.maximumFeedback.getDoubleValue());
        this.maximumFeedbackRate.set(other.maximumFeedbackRate.getDoubleValue());
        this.positionDeadband.set(other.positionDeadband.getDoubleValue());
    }

    public void set(PDGainsReadOnly pdGains) {
        this.setKp(pdGains.getKp());
        this.setKd(pdGains.getKd());
        this.setMaximumFeedback(pdGains.getMaximumFeedback());
        this.setMaximumFeedbackRate(pdGains.getMaximumFeedbackRate());
        this.setPositionDeadband(pdGains.getPositionDeadband());
    }

    public boolean equals(Object object) {
        if (object instanceof PDGainsReadOnly) {
            return PDGainsReadOnly.super.equals((PDGainsReadOnly)object);
        }
        return false;
    }
}

