/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers.pidGains.implementations;

import us.ihmc.robotics.controllers.pidGains.PDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.ParameterizedPDGains;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ParameterizedPIDGains
extends ParameterizedPDGains
implements PIDGainsReadOnly {
    private final DoubleParameter ki;
    private final DoubleParameter maxIntegralError;
    private final DoubleParameter integralLeakRatio;

    public ParameterizedPIDGains(String suffix, YoRegistry registry) {
        this(suffix, null, registry);
    }

    public ParameterizedPIDGains(String suffix, PIDGainsReadOnly defaults, YoRegistry registry) {
        super(suffix, defaults, registry);
        if (defaults == null) {
            this.ki = new DoubleParameter("ki" + suffix, registry, 0.0);
            this.maxIntegralError = new DoubleParameter("maxIntegralError" + suffix, registry, Double.POSITIVE_INFINITY);
            this.integralLeakRatio = new DoubleParameter("integralLeakRatio" + suffix, registry, 1.0);
        } else {
            this.ki = new DoubleParameter("ki" + suffix, registry, defaults.getKi());
            this.maxIntegralError = new DoubleParameter("maxIntegralError" + suffix, registry, defaults.getMaxIntegralError());
            this.integralLeakRatio = new DoubleParameter("integralLeakRatio" + suffix, registry, defaults.getIntegralLeakRatio());
        }
    }

    public ParameterizedPIDGains(String suffix, PDGainsReadOnly defaults, YoRegistry registry) {
        super(suffix, defaults, registry);
        this.ki = new DoubleParameter("ki" + suffix, registry, 0.0);
        this.maxIntegralError = new DoubleParameter("maxIntegralError" + suffix, registry, Double.POSITIVE_INFINITY);
        this.integralLeakRatio = new DoubleParameter("integralLeakRatio" + suffix, registry, 1.0);
    }

    @Override
    public double getKi() {
        return this.ki.getValue();
    }

    @Override
    public double getMaxIntegralError() {
        return this.maxIntegralError.getValue();
    }

    @Override
    public double getIntegralLeakRatio() {
        return this.integralLeakRatio.getValue();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PIDGainsReadOnly) {
            return PIDGainsReadOnly.super.equals((PIDGainsReadOnly)object);
        }
        return false;
    }
}

