/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers.pidGains.implementations;

import java.util.EnumMap;
import java.util.Map;
import us.ihmc.euclid.Axis3D;
import us.ihmc.robotics.controllers.pidGains.GainCalculator;
import us.ihmc.robotics.controllers.pidGains.GainCoupling;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.DefaultYoPID3DGains;
import us.ihmc.robotics.controllers.pidGains.implementations.PID3DConfiguration;
import us.ihmc.yoVariables.listener.YoParameterChangedListener;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ParameterizedPID3DGains
implements PID3DGainsReadOnly {
    private final boolean usingIntegrator;
    private final Map<Axis3D, DoubleParameter> kpMap = new EnumMap<Axis3D, DoubleParameter>(Axis3D.class);
    private final Map<Axis3D, DoubleParameter> kiMap = new EnumMap<Axis3D, DoubleParameter>(Axis3D.class);
    private final Map<Axis3D, DoubleParameter> zetaMap = new EnumMap<Axis3D, DoubleParameter>(Axis3D.class);
    private final DoubleParameter maxIntegralError;
    private final DoubleParameter maxDerivativeError;
    private final DoubleParameter maxProportionalError;
    private final DoubleParameter maxFeedback;
    private final DoubleParameter maxFeedbackRate;
    private final Map<Axis3D, YoDouble> kdMap = new EnumMap<Axis3D, YoDouble>(Axis3D.class);
    private final double[] tempProportionalGains = new double[3];
    private final double[] tempDerivativeGains = new double[3];
    private final double[] tempIntegralGains = new double[3];

    public ParameterizedPID3DGains(String suffix, PID3DConfiguration configuration, YoRegistry registry) {
        this(suffix, configuration.getGainCoupling(), configuration.isUseIntegrator(), configuration.getGains(), registry);
    }

    public ParameterizedPID3DGains(String suffix, GainCoupling gainCoupling, boolean useIntegrator, YoRegistry registry) {
        this(suffix, gainCoupling, useIntegrator, null, registry);
    }

    public ParameterizedPID3DGains(String suffix, GainCoupling gainCoupling, boolean useIntegrator, PID3DGainsReadOnly defaults, YoRegistry registry) {
        this.usingIntegrator = useIntegrator;
        if (defaults == null) {
            ParameterizedPID3DGains.populateMap(this.kpMap, "kp", suffix, gainCoupling, registry);
            DefaultYoPID3DGains.populateMap(this.kdMap, "kd", suffix, gainCoupling, registry);
            ParameterizedPID3DGains.populateMap(this.zetaMap, "zeta", suffix, gainCoupling, registry);
            if (useIntegrator) {
                ParameterizedPID3DGains.populateMap(this.kiMap, "ki", suffix, gainCoupling, registry);
                this.maxIntegralError = new DoubleParameter("maxIntegralError" + suffix, registry, Double.POSITIVE_INFINITY);
            } else {
                this.maxIntegralError = null;
            }
            ParameterizedPID3DGains.createDampingUpdaters(this.kpMap, this.kdMap, this.zetaMap, gainCoupling);
            this.maxDerivativeError = new DoubleParameter("maxDerivativeError" + suffix, registry, Double.POSITIVE_INFINITY);
            this.maxProportionalError = new DoubleParameter("maxProportionalError" + suffix, registry, Double.POSITIVE_INFINITY);
            this.maxFeedback = new DoubleParameter("maximumFeedback" + suffix, registry, Double.POSITIVE_INFINITY);
            this.maxFeedbackRate = new DoubleParameter("maximumFeedbackRate" + suffix, registry, Double.POSITIVE_INFINITY);
        } else {
            double[] defaultProportionalGains = defaults.getProportionalGains();
            double[] defaultDerivativeGains = defaults.getDerivativeGains();
            double[] defaultIntegralGains = defaults.getIntegralGains();
            double[] defaultZetas = new double[3];
            for (int i = 0; i < 3; ++i) {
                double proportionalGain = defaultProportionalGains[i];
                defaultZetas[i] = proportionalGain != 0.0 ? GainCalculator.computeDampingRatio(proportionalGain, defaultDerivativeGains[i]) : 0.0;
            }
            ParameterizedPID3DGains.populateMap(this.kpMap, "kp", suffix, gainCoupling, defaultProportionalGains, registry);
            DefaultYoPID3DGains.populateMap(this.kdMap, "kd", suffix, gainCoupling, registry);
            ParameterizedPID3DGains.populateMap(this.zetaMap, "zeta", suffix, gainCoupling, defaultZetas, registry);
            if (useIntegrator) {
                ParameterizedPID3DGains.populateMap(this.kiMap, "ki", suffix, gainCoupling, defaultIntegralGains, registry);
                this.maxIntegralError = new DoubleParameter("maxIntegralError" + suffix, registry, defaults.getMaximumIntegralError());
            } else {
                this.maxIntegralError = null;
            }
            ParameterizedPID3DGains.createDampingUpdaters(this.kpMap, this.kdMap, this.zetaMap, gainCoupling);
            this.maxDerivativeError = new DoubleParameter("maxDerivativeError" + suffix, registry, defaults.getMaximumDerivativeError());
            this.maxProportionalError = new DoubleParameter("maxProportionalError" + suffix, registry, defaults.getMaximumProportionalError());
            this.maxFeedback = new DoubleParameter("maximumFeedback" + suffix, registry, defaults.getMaximumFeedback());
            this.maxFeedbackRate = new DoubleParameter("maximumFeedbackRate" + suffix, registry, defaults.getMaximumFeedbackRate());
        }
    }

    private static void populateMap(Map<Axis3D, DoubleParameter> mapToFill, String prefix, String suffix, GainCoupling gainCoupling, YoRegistry registry) {
        switch (gainCoupling) {
            case NONE: {
                mapToFill.put(Axis3D.X, new DoubleParameter(prefix + "X" + suffix, registry));
                mapToFill.put(Axis3D.Y, new DoubleParameter(prefix + "Y" + suffix, registry));
                mapToFill.put(Axis3D.Z, new DoubleParameter(prefix + "Z" + suffix, registry));
                break;
            }
            case XY: {
                mapToFill.put(Axis3D.X, new DoubleParameter(prefix + "XY" + suffix, registry));
                mapToFill.put(Axis3D.Y, mapToFill.get(Axis3D.X));
                mapToFill.put(Axis3D.Z, new DoubleParameter(prefix + "Z" + suffix, registry));
                break;
            }
            case YZ: {
                mapToFill.put(Axis3D.X, new DoubleParameter(prefix + "X" + suffix, registry));
                mapToFill.put(Axis3D.Y, new DoubleParameter(prefix + "YZ" + suffix, registry));
                mapToFill.put(Axis3D.Z, mapToFill.get(Axis3D.Y));
                break;
            }
            case XZ: {
                mapToFill.put(Axis3D.X, new DoubleParameter(prefix + "XZ" + suffix, registry));
                mapToFill.put(Axis3D.Y, new DoubleParameter(prefix + "Y" + suffix, registry));
                mapToFill.put(Axis3D.Z, mapToFill.get(Axis3D.X));
                break;
            }
            case XYZ: {
                mapToFill.put(Axis3D.X, new DoubleParameter(prefix + "XYZ" + suffix, registry));
                mapToFill.put(Axis3D.Y, mapToFill.get(Axis3D.X));
                mapToFill.put(Axis3D.Z, mapToFill.get(Axis3D.X));
            }
        }
    }

    private static void populateMap(Map<Axis3D, DoubleParameter> mapToFill, String prefix, String suffix, GainCoupling gainCoupling, double[] defaults, YoRegistry registry) {
        switch (gainCoupling) {
            case NONE: {
                mapToFill.put(Axis3D.X, new DoubleParameter(prefix + "X" + suffix, registry, defaults[0]));
                mapToFill.put(Axis3D.Y, new DoubleParameter(prefix + "Y" + suffix, registry, defaults[1]));
                mapToFill.put(Axis3D.Z, new DoubleParameter(prefix + "Z" + suffix, registry, defaults[2]));
                break;
            }
            case XY: {
                mapToFill.put(Axis3D.X, new DoubleParameter(prefix + "XY" + suffix, registry, defaults[0]));
                mapToFill.put(Axis3D.Y, mapToFill.get(Axis3D.X));
                mapToFill.put(Axis3D.Z, new DoubleParameter(prefix + "Z" + suffix, registry, defaults[2]));
                break;
            }
            case YZ: {
                mapToFill.put(Axis3D.X, new DoubleParameter(prefix + "X" + suffix, registry, defaults[0]));
                mapToFill.put(Axis3D.Y, new DoubleParameter(prefix + "YZ" + suffix, registry, defaults[1]));
                mapToFill.put(Axis3D.Z, mapToFill.get(Axis3D.Y));
                break;
            }
            case XZ: {
                mapToFill.put(Axis3D.X, new DoubleParameter(prefix + "XZ" + suffix, registry, defaults[0]));
                mapToFill.put(Axis3D.Y, new DoubleParameter(prefix + "Y" + suffix, registry, defaults[1]));
                mapToFill.put(Axis3D.Z, mapToFill.get(Axis3D.X));
                break;
            }
            case XYZ: {
                mapToFill.put(Axis3D.X, new DoubleParameter(prefix + "XYZ" + suffix, registry, defaults[0]));
                mapToFill.put(Axis3D.Y, mapToFill.get(Axis3D.X));
                mapToFill.put(Axis3D.Z, mapToFill.get(Axis3D.X));
            }
        }
    }

    private static void createDampingUpdaters(Map<Axis3D, DoubleParameter> kpMap, Map<Axis3D, YoDouble> kdMap, Map<Axis3D, DoubleParameter> zetaMap, GainCoupling gainCoupling) {
        switch (gainCoupling) {
            case NONE: {
                ParameterizedPID3DGains.addDampingUpdater(Axis3D.X, kpMap, kdMap, zetaMap);
                ParameterizedPID3DGains.addDampingUpdater(Axis3D.Y, kpMap, kdMap, zetaMap);
                ParameterizedPID3DGains.addDampingUpdater(Axis3D.Z, kpMap, kdMap, zetaMap);
                break;
            }
            case XY: {
                ParameterizedPID3DGains.addDampingUpdater(Axis3D.X, kpMap, kdMap, zetaMap);
                ParameterizedPID3DGains.addDampingUpdater(Axis3D.Z, kpMap, kdMap, zetaMap);
                break;
            }
            case YZ: {
                ParameterizedPID3DGains.addDampingUpdater(Axis3D.X, kpMap, kdMap, zetaMap);
                ParameterizedPID3DGains.addDampingUpdater(Axis3D.Y, kpMap, kdMap, zetaMap);
                break;
            }
            case XZ: {
                ParameterizedPID3DGains.addDampingUpdater(Axis3D.X, kpMap, kdMap, zetaMap);
                ParameterizedPID3DGains.addDampingUpdater(Axis3D.Y, kpMap, kdMap, zetaMap);
                break;
            }
            case XYZ: {
                ParameterizedPID3DGains.addDampingUpdater(Axis3D.X, kpMap, kdMap, zetaMap);
            }
        }
    }

    private static void addDampingUpdater(Axis3D axis, Map<Axis3D, DoubleParameter> kpMap, Map<Axis3D, YoDouble> kdMap, Map<Axis3D, DoubleParameter> zetaMap) {
        DoubleParameter kp = kpMap.get(axis);
        YoDouble kd = kdMap.get(axis);
        DoubleParameter zeta = zetaMap.get(axis);
        YoParameterChangedListener updater = parameter -> {
            if (kp.isLoaded() && zeta.isLoaded()) {
                kd.set(GainCalculator.computeDerivativeGain(kp.getValue(), zeta.getValue()));
            }
        };
        updater.changed(null);
        kp.addListener(updater);
        zeta.addListener(updater);
    }

    @Override
    public double[] getProportionalGains() {
        ParameterizedPID3DGains.fillFromMap(this.kpMap, this.tempProportionalGains);
        return this.tempProportionalGains;
    }

    @Override
    public double[] getDerivativeGains() {
        DefaultYoPID3DGains.fillFromMap(this.kdMap, this.tempDerivativeGains);
        return this.tempDerivativeGains;
    }

    @Override
    public double[] getIntegralGains() {
        if (!this.usingIntegrator) {
            for (int i = 0; i < 3; ++i) {
                this.tempIntegralGains[i] = 0.0;
            }
            return this.tempIntegralGains;
        }
        ParameterizedPID3DGains.fillFromMap(this.kiMap, this.tempIntegralGains);
        return this.tempIntegralGains;
    }

    private static void fillFromMap(Map<Axis3D, DoubleParameter> map, double[] arrayToFill) {
        arrayToFill[0] = map.get(Axis3D.X).getValue();
        arrayToFill[1] = map.get(Axis3D.Y).getValue();
        arrayToFill[2] = map.get(Axis3D.Z).getValue();
    }

    @Override
    public double getMaximumIntegralError() {
        if (!this.usingIntegrator) {
            return 0.0;
        }
        return this.maxIntegralError.getValue();
    }

    @Override
    public double getMaximumDerivativeError() {
        return this.maxDerivativeError.getValue();
    }

    @Override
    public double getMaximumProportionalError() {
        return this.maxProportionalError.getValue();
    }

    @Override
    public double getMaximumFeedback() {
        return this.maxFeedback.getValue();
    }

    @Override
    public double getMaximumFeedbackRate() {
        return this.maxFeedbackRate.getValue();
    }

    public DoubleParameter getMaximumDerivativeErrorParameter() {
        return this.maxDerivativeError;
    }

    public DoubleParameter getMaximumProportionalErrorParameter() {
        return this.maxProportionalError;
    }
}

