/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers.pidGains.implementations;

import us.ihmc.robotics.controllers.pidGains.GainCalculator;
import us.ihmc.robotics.controllers.pidGains.PDGainsReadOnly;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ParameterizedPDGains
implements PDGainsReadOnly {
    private final DoubleParameter kp;
    private final DoubleParameter zeta;
    private final DoubleParameter maximumFeedback;
    private final DoubleParameter maximumFeedbackRate;
    private final DoubleParameter positionDeadband;

    public ParameterizedPDGains(String suffix, YoRegistry registry) {
        this(suffix, null, registry);
    }

    public ParameterizedPDGains(String suffix, PDGainsReadOnly defaults, YoRegistry registry) {
        if (defaults == null) {
            this.kp = new DoubleParameter("kp" + suffix, registry);
            this.zeta = new DoubleParameter("zeta" + suffix, registry);
            this.maximumFeedback = new DoubleParameter("maximumFeedback" + suffix, registry, Double.POSITIVE_INFINITY);
            this.maximumFeedbackRate = new DoubleParameter("maximumFeedbackRate" + suffix, registry, Double.POSITIVE_INFINITY);
            this.positionDeadband = new DoubleParameter("positionDeadband" + suffix, registry, 0.0);
        } else {
            this.kp = new DoubleParameter("kp" + suffix, registry, defaults.getKp());
            this.zeta = new DoubleParameter("zeta" + suffix, registry, GainCalculator.computeDampingRatio(defaults.getKp(), defaults.getKd()));
            this.maximumFeedback = new DoubleParameter("maximumFeedback" + suffix, registry, defaults.getMaximumFeedback());
            this.maximumFeedbackRate = new DoubleParameter("maximumFeedbackRate" + suffix, registry, defaults.getMaximumFeedbackRate());
            this.positionDeadband = new DoubleParameter("positionDeadband" + suffix, registry, defaults.getPositionDeadband());
        }
    }

    @Override
    public double getKp() {
        return this.kp.getValue();
    }

    @Override
    public double getKd() {
        return GainCalculator.computeDerivativeGain(this.kp.getValue(), this.zeta.getValue());
    }

    @Override
    public double getMaximumFeedback() {
        return this.maximumFeedback.getValue();
    }

    @Override
    public double getMaximumFeedbackRate() {
        return this.maximumFeedbackRate.getValue();
    }

    @Override
    public double getPositionDeadband() {
        return this.positionDeadband.getValue();
    }

    public boolean equals(Object object) {
        if (object instanceof PDGainsReadOnly) {
            return PDGainsReadOnly.super.equals((PDGainsReadOnly)object);
        }
        return false;
    }
}

