/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers.pidGains;

import java.util.Arrays;
import us.ihmc.euclid.matrix.Matrix3D;

public interface PID3DGainsReadOnly {
    public double[] getProportionalGains();

    public double[] getDerivativeGains();

    public double[] getIntegralGains();

    public double getMaximumIntegralError();

    public double getMaximumDerivativeError();

    public double getMaximumProportionalError();

    public double getMaximumFeedback();

    public double getMaximumFeedbackRate();

    default public void getProportionalGainMatrix(Matrix3D proportialGainMatrixToPack) {
        PID3DGainsReadOnly.setMatrixDiagonal(this.getProportionalGains(), proportialGainMatrixToPack);
    }

    default public void getDerivativeGainMatrix(Matrix3D derivativeGainMatrixToPack) {
        PID3DGainsReadOnly.setMatrixDiagonal(this.getDerivativeGains(), derivativeGainMatrixToPack);
    }

    default public void getIntegralGainMatrix(Matrix3D integralGainMatrixToPack) {
        PID3DGainsReadOnly.setMatrixDiagonal(this.getIntegralGains(), integralGainMatrixToPack);
    }

    public static void setMatrixDiagonal(double[] diagonalElements, Matrix3D matrixToFill) {
        PID3DGainsReadOnly.checkArrayLength(diagonalElements);
        matrixToFill.fill(0.0);
        for (int i = 0; i < 3; ++i) {
            matrixToFill.setElement(i, i, diagonalElements[i]);
        }
    }

    public static void checkArrayLength(double[] array) {
        if (array == null || array.length != 3) {
            throw new RuntimeException("Expected array of length three.");
        }
    }

    default public boolean equals(PID3DGainsReadOnly other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!Arrays.equals(this.getProportionalGains(), other.getProportionalGains())) {
            return false;
        }
        if (!Arrays.equals(this.getDerivativeGains(), other.getDerivativeGains())) {
            return false;
        }
        if (!Arrays.equals(this.getIntegralGains(), other.getIntegralGains())) {
            return false;
        }
        if (Double.compare(this.getMaximumIntegralError(), other.getMaximumIntegralError()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaximumDerivativeError(), other.getMaximumDerivativeError()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaximumProportionalError(), other.getMaximumProportionalError()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaximumFeedback(), other.getMaximumFeedback()) != 0) {
            return false;
        }
        return Double.compare(this.getMaximumFeedbackRate(), other.getMaximumFeedbackRate()) == 0;
    }
}

