/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import us.ihmc.robotics.controllers.AbstractPDController;
import us.ihmc.robotics.controllers.AbstractPIDController;
import us.ihmc.robotics.controllers.ParameterizedPDController;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ParameterizedPIDController
extends AbstractPIDController {
    final ParameterizedPDController pdController;
    final DoubleProvider integralGain;
    final DoubleProvider maxIntegralError;
    final DoubleProvider maxOutput;
    final DoubleProvider integralLeakRatio;

    public ParameterizedPIDController(String suffix, YoRegistry registry) {
        super(suffix, registry);
        this.pdController = new ParameterizedPDController(suffix, registry);
        this.integralGain = new DoubleParameter("ki_" + suffix, registry, 0.0);
        this.maxIntegralError = new DoubleParameter("maxIntegralError_" + suffix, registry, Double.POSITIVE_INFINITY);
        this.maxOutput = new DoubleParameter("maxOutput_" + suffix, registry, Double.POSITIVE_INFINITY);
        this.integralLeakRatio = new DoubleParameter("leak_" + suffix, registry, 1.0);
    }

    public ParameterizedPIDController(DoubleParameter proportionalGain, DoubleParameter integralGain, DoubleParameter derivativeGain, DoubleParameter maxIntegralError, String suffix, YoRegistry registry) {
        super(suffix, registry);
        this.pdController = new ParameterizedPDController((DoubleProvider)proportionalGain, (DoubleProvider)derivativeGain, suffix, registry);
        this.integralGain = integralGain;
        this.maxIntegralError = maxIntegralError;
        this.maxOutput = () -> Double.POSITIVE_INFINITY;
        this.integralLeakRatio = () -> 1.0;
    }

    @Override
    protected AbstractPDController getPDController() {
        return this.pdController;
    }

    @Override
    public double getMaximumFeedback() {
        return this.maxOutput.getValue();
    }

    @Override
    public double getIntegralGain() {
        return this.integralGain.getValue();
    }

    @Override
    public double getMaxIntegralError() {
        return this.maxIntegralError.getValue();
    }

    @Override
    public double getIntegralLeakRatio() {
        return this.integralLeakRatio.getValue();
    }
}

