/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameMatrix3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.controllers.TangentialDampingGains;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;

public class EuclideanTangentialDampingCalculator {
    private final ReferenceFrame bodyFrame;
    private final ReferenceFrame bodyFrameTangentToControl;
    private final FrameVector3D positionError = new FrameVector3D();
    private final TangentialDampingGains tangentialDampingGains;
    private final FrameMatrix3D transformedGains;

    public EuclideanTangentialDampingCalculator(String prefix, final ReferenceFrame bodyFrame, TangentialDampingGains tangentialDampingGains) {
        this.bodyFrame = bodyFrame;
        this.tangentialDampingGains = tangentialDampingGains;
        this.bodyFrameTangentToControl = new ReferenceFrame(prefix + "BodyFrameTangentToControl", bodyFrame){
            private final AxisAngle rotationToControlFrame;
            {
                super(arg0, arg1);
                this.rotationToControlFrame = new AxisAngle();
            }

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                EuclideanTangentialDampingCalculator.this.positionError.changeFrame(bodyFrame);
                EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)EuclideanTangentialDampingCalculator.this.positionError, (Orientation3DBasics)this.rotationToControlFrame);
                transformToParent.setRotationAndZeroTranslation((Orientation3DReadOnly)this.rotationToControlFrame);
            }
        };
        this.transformedGains = new FrameMatrix3D(bodyFrame);
    }

    public void compute(YoFrameVector3D positionError, Matrix3D derivativeGainsToPack) {
        this.positionError.setIncludingFrame((FrameTuple3DReadOnly)positionError);
        if (positionError.length() > this.tangentialDampingGains.getParallelDampingDeadband()) {
            this.bodyFrameTangentToControl.update();
            double alpha = this.computeDampingReductionRatioParallelToMotion(positionError.length());
            this.transformedGains.setToZero(this.bodyFrame);
            this.transformedGains.set((Matrix3DReadOnly)derivativeGainsToPack);
            this.transformedGains.changeFrame(this.bodyFrameTangentToControl);
            this.transformedGains.setElement(0, 0, alpha * this.transformedGains.getElement(0, 0));
            this.transformedGains.setElement(1, 0, alpha * this.transformedGains.getElement(1, 0));
            this.transformedGains.setElement(2, 0, alpha * this.transformedGains.getElement(2, 0));
            this.transformedGains.changeFrame(this.bodyFrame);
            derivativeGainsToPack.set((Matrix3DReadOnly)this.transformedGains);
        }
    }

    private double computeDampingReductionRatioParallelToMotion(double parallelError) {
        double reductionRatio = MathTools.clamp((double)this.tangentialDampingGains.getKdReductionRatio(), (double)0.0, (double)1.0);
        double deadband = this.tangentialDampingGains.getParallelDampingDeadband();
        double maxError = this.tangentialDampingGains.getPositionErrorForMinimumKd();
        if (Double.isInfinite(deadband) || deadband > maxError || Math.abs(parallelError) < deadband) {
            return 1.0;
        }
        double slope = (1.0 - reductionRatio) / (maxError - deadband);
        return 1.0 - slope * (Math.abs(parallelError) - deadband);
    }
}

