/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.robotics.controllers.PositionController;
import us.ihmc.robotics.controllers.pidGains.GainCoupling;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.YoPID3DGains;
import us.ihmc.robotics.controllers.pidGains.implementations.DefaultYoPID3DGains;
import us.ihmc.robotics.math.filters.RateLimitedYoFrameVector;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class EuclideanPositionController
implements PositionController {
    private final YoRegistry registry;
    private final YoFrameVector3D positionError;
    private final YoFrameVector3D positionErrorCumulated;
    private final YoFrameVector3D velocityError;
    private final Matrix3D tempGainMatrix = new Matrix3D();
    private final ReferenceFrame bodyFrame;
    private final FrameVector3D proportionalTerm;
    private final FrameVector3D derivativeTerm;
    private final FrameVector3D integralTerm;
    private final FramePoint3D desiredPosition = new FramePoint3D();
    private final FrameVector3D desiredVelocity = new FrameVector3D();
    private final FrameVector3D feedForwardLinearAction = new FrameVector3D();
    private final FrameVector3D actionFromPositionController = new FrameVector3D();
    private final YoFrameVector3D feedbackLinearAction;
    private final RateLimitedYoFrameVector rateLimitedFeedbackLinearAction;
    private final double dt;
    private final YoPID3DGains gains;

    public EuclideanPositionController(String prefix, ReferenceFrame bodyFrame, double dt, YoRegistry parentRegistry) {
        this(prefix, bodyFrame, dt, null, parentRegistry);
    }

    public EuclideanPositionController(String prefix, ReferenceFrame bodyFrame, double dt, YoPID3DGains gains, YoRegistry parentRegistry) {
        this.dt = dt;
        this.bodyFrame = bodyFrame;
        this.registry = new YoRegistry(prefix + this.getClass().getSimpleName());
        if (gains == null) {
            gains = new DefaultYoPID3DGains(prefix, GainCoupling.NONE, true, this.registry);
        }
        this.gains = gains;
        this.positionError = new YoFrameVector3D(prefix + "PositionError", bodyFrame, this.registry);
        this.positionErrorCumulated = new YoFrameVector3D(prefix + "PositionErrorCumulated", bodyFrame, this.registry);
        this.velocityError = new YoFrameVector3D(prefix + "LinearVelocityError", bodyFrame, this.registry);
        this.proportionalTerm = new FrameVector3D(bodyFrame);
        this.derivativeTerm = new FrameVector3D(bodyFrame);
        this.integralTerm = new FrameVector3D(bodyFrame);
        this.feedbackLinearAction = new YoFrameVector3D(prefix + "FeedbackLinearAction", bodyFrame, this.registry);
        this.rateLimitedFeedbackLinearAction = new RateLimitedYoFrameVector(prefix + "RateLimitedFeedbackLinearAction", "", this.registry, (DoubleProvider)gains.getYoMaximumFeedbackRate(), dt, (FrameTuple3DReadOnly)this.feedbackLinearAction);
        parentRegistry.addChild(this.registry);
    }

    public void reset() {
        this.rateLimitedFeedbackLinearAction.reset();
    }

    public void resetIntegrator() {
        this.positionErrorCumulated.setToZero();
    }

    @Override
    public void compute(FrameVector3D output, FramePoint3D desiredPosition, FrameVector3D desiredVelocity, FrameVector3D currentVelocity, FrameVector3D feedForward) {
        this.computeProportionalTerm(desiredPosition);
        if (currentVelocity != null) {
            this.computeDerivativeTerm(desiredVelocity, currentVelocity);
        }
        this.computeIntegralTerm();
        output.setToNaN(this.bodyFrame);
        output.add((FrameTuple3DReadOnly)this.proportionalTerm, (FrameTuple3DReadOnly)this.derivativeTerm);
        output.add((FrameTuple3DReadOnly)this.integralTerm);
        double feedbackLinearActionMagnitude = output.length();
        if (feedbackLinearActionMagnitude > this.gains.getMaximumFeedback()) {
            output.scale(this.gains.getMaximumFeedback() / feedbackLinearActionMagnitude);
        }
        this.feedbackLinearAction.set((FrameTuple3DReadOnly)output);
        this.rateLimitedFeedbackLinearAction.update();
        output.set((FrameTuple3DReadOnly)this.rateLimitedFeedbackLinearAction);
        feedForward.changeFrame(this.bodyFrame);
        output.add((FrameTuple3DReadOnly)feedForward);
    }

    public void compute(Twist twistToPack, FramePose3D desiredPose, TwistReadOnly desiredTwist) {
        this.checkBodyFrames(desiredTwist, (TwistReadOnly)twistToPack);
        this.checkBaseFrames(desiredTwist, (TwistReadOnly)twistToPack);
        this.checkExpressedInFrames(desiredTwist, (TwistReadOnly)twistToPack);
        twistToPack.setToZero(this.bodyFrame, desiredTwist.getBaseFrame(), this.bodyFrame);
        this.desiredPosition.setIncludingFrame((FrameTuple3DReadOnly)desiredPose.getPosition());
        this.desiredVelocity.setIncludingFrame((FrameTuple3DReadOnly)desiredTwist.getLinearPart());
        this.feedForwardLinearAction.setIncludingFrame((FrameTuple3DReadOnly)desiredTwist.getLinearPart());
        this.compute(this.actionFromPositionController, this.desiredPosition, this.desiredVelocity, null, this.feedForwardLinearAction);
        twistToPack.getLinearPart().set((FrameTuple3DReadOnly)this.actionFromPositionController);
    }

    private void checkBodyFrames(TwistReadOnly desiredTwist, TwistReadOnly currentTwist) {
        desiredTwist.getBodyFrame().checkReferenceFrameMatch(this.bodyFrame);
        currentTwist.getBodyFrame().checkReferenceFrameMatch(this.bodyFrame);
    }

    private void checkBaseFrames(TwistReadOnly desiredTwist, TwistReadOnly currentTwist) {
        desiredTwist.getBaseFrame().checkReferenceFrameMatch(currentTwist.getBaseFrame());
    }

    private void checkExpressedInFrames(TwistReadOnly desiredTwist, TwistReadOnly currentTwist) {
        desiredTwist.getReferenceFrame().checkReferenceFrameMatch(this.bodyFrame);
        currentTwist.getReferenceFrame().checkReferenceFrameMatch(this.bodyFrame);
    }

    private void computeProportionalTerm(FramePoint3D desiredPosition) {
        desiredPosition.changeFrame(this.bodyFrame);
        this.positionError.set((FrameTuple3DReadOnly)desiredPosition);
        double maximumError = this.gains.getMaximumProportionalError();
        double errorMagnitude = this.positionError.length();
        this.proportionalTerm.set((FrameTuple3DReadOnly)this.positionError);
        if (errorMagnitude > maximumError) {
            this.proportionalTerm.scale(maximumError / errorMagnitude);
        }
        this.gains.getProportionalGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)this.proportionalTerm);
    }

    private void computeDerivativeTerm(FrameVector3D desiredVelocity, FrameVector3D currentVelocity) {
        desiredVelocity.changeFrame(this.bodyFrame);
        currentVelocity.changeFrame(this.bodyFrame);
        this.derivativeTerm.sub((FrameTuple3DReadOnly)desiredVelocity, (FrameTuple3DReadOnly)currentVelocity);
        double maximumVelocityError = this.gains.getMaximumDerivativeError();
        double velocityErrorMagnitude = this.derivativeTerm.length();
        if (velocityErrorMagnitude > maximumVelocityError) {
            this.derivativeTerm.scale(maximumVelocityError / velocityErrorMagnitude);
        }
        this.velocityError.set((FrameTuple3DReadOnly)this.derivativeTerm);
        this.gains.getDerivativeGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)this.derivativeTerm);
    }

    private void computeIntegralTerm() {
        if (this.gains.getMaximumIntegralError() < 1.0E-5) {
            this.integralTerm.setToZero(this.bodyFrame);
            return;
        }
        double errorIntegratedX = this.positionError.getX() * this.dt;
        double errorIntegratedY = this.positionError.getY() * this.dt;
        double errorIntegratedZ = this.positionError.getZ() * this.dt;
        this.positionErrorCumulated.add(errorIntegratedX, errorIntegratedY, errorIntegratedZ);
        double errorMagnitude = this.positionErrorCumulated.length();
        if (errorMagnitude > this.gains.getMaximumIntegralError()) {
            this.positionErrorCumulated.scale(this.gains.getMaximumIntegralError() / errorMagnitude);
        }
        this.integralTerm.set((FrameTuple3DReadOnly)this.positionErrorCumulated);
        this.gains.getIntegralGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)this.integralTerm);
    }

    public void setProportionalGains(double proportionalGainX, double proportionalGainY, double proportionalGainZ) {
        this.gains.setProportionalGains(proportionalGainX, proportionalGainY, proportionalGainZ);
    }

    public void setDerivativeGains(double derivativeGainX, double derivativeGainY, double derivativeGainZ) {
        this.gains.setDerivativeGains(derivativeGainX, derivativeGainY, derivativeGainZ);
    }

    public void setIntegralGains(double integralGainX, double integralGainY, double integralGainZ, double maxIntegralError) {
        this.gains.setIntegralGains(integralGainX, integralGainY, integralGainZ, maxIntegralError);
    }

    public void setProportionalGains(double[] proportionalGains) {
        this.gains.setProportionalGains(proportionalGains);
    }

    public void setDerivativeGains(double[] derivativeGains) {
        this.gains.setDerivativeGains(derivativeGains);
    }

    public void setIntegralGains(double[] integralGains, double maxIntegralError) {
        this.gains.setIntegralGains(integralGains, maxIntegralError);
    }

    public void getPositionError(FrameVector3D positionErrorToPack) {
        positionErrorToPack.set((FrameTuple3DReadOnly)this.positionError);
    }

    @Override
    public ReferenceFrame getBodyFrame() {
        return this.bodyFrame;
    }

    public void setMaxFeedbackAndFeedbackRate(double maxFeedback, double maxFeedbackRate) {
        this.gains.setMaxFeedbackAndFeedbackRate(maxFeedback, maxFeedbackRate);
    }

    public void setMaxDerivativeError(double maxDerivativeError) {
        this.gains.setMaxDerivativeError(maxDerivativeError);
    }

    public void setMaxProportionalError(double maxProportionalError) {
        this.gains.setMaxProportionalError(maxProportionalError);
    }

    public void setGains(PID3DGainsReadOnly gains) {
        this.gains.set(gains);
    }
}

