/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import us.ihmc.robotics.controllers.pidGains.GainCalculator;

public class CylindricalPDGains {
    private final double kpRadius;
    private final double kpAngle;
    private final double kpZ;
    private final double kdRadius;
    private final double kdAngle;
    private final double kdZ;

    public CylindricalPDGains(double kpRadius, double kpAngle, double kpZ, double zeta) {
        this.kpRadius = kpRadius;
        this.kpAngle = kpAngle;
        this.kpZ = kpZ;
        this.kdRadius = GainCalculator.computeDerivativeGain(kpRadius, zeta);
        this.kdAngle = GainCalculator.computeDerivativeGain(kpAngle, zeta);
        this.kdZ = GainCalculator.computeDerivativeGain(kpZ, zeta);
    }

    public double getKpRadius() {
        return this.kpRadius;
    }

    public double getKpAngle() {
        return this.kpAngle;
    }

    public double getKpZ() {
        return this.kpZ;
    }

    public double getKdRadius() {
        return this.kdRadius;
    }

    public double getKdAngle() {
        return this.kdAngle;
    }

    public double getKdZ() {
        return this.kdZ;
    }
}

