/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import us.ihmc.commons.MathTools;
import us.ihmc.robotics.controllers.AbstractPDController;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public abstract class AbstractPIDController {
    private final YoDouble cumulativeError;
    private final YoDouble actionI;

    protected AbstractPIDController(String suffix, YoRegistry registry) {
        this.cumulativeError = new YoDouble("cumulativeError_" + suffix, registry);
        this.cumulativeError.set(0.0);
        this.actionI = new YoDouble("action_I_" + suffix, registry);
        this.actionI.set(0.0);
    }

    protected abstract AbstractPDController getPDController();

    public abstract double getMaximumFeedback();

    public abstract double getIntegralGain();

    public abstract double getMaxIntegralError();

    public abstract double getIntegralLeakRatio();

    public double getProportionalGain() {
        return this.getPDController().getProportionalGain();
    }

    public double getDerivativeGain() {
        return this.getPDController().getDerivativeGain();
    }

    public double getPositionError() {
        return this.getPDController().getPositionError();
    }

    public double getRateError() {
        return this.getPDController().getRateError();
    }

    public double getCumulativeError() {
        return this.cumulativeError.getDoubleValue();
    }

    public void setCumulativeError(double error) {
        this.cumulativeError.set(error);
    }

    public double getPositionDeadband() {
        return this.getPDController().getPositionDeadband();
    }

    public void resetIntegrator() {
        this.cumulativeError.set(0.0);
    }

    public double compute(double currentPosition, double desiredPosition, double currentRate, double desiredRate, double deltaTime) {
        this.getPDController().compute(currentPosition, desiredPosition, currentRate, desiredRate);
        return this.computeIntegralEffortAndAddPDEffort(deltaTime);
    }

    public double computeForAngles(double currentPosition, double desiredPosition, double currentRate, double desiredRate, double deltaTime) {
        this.getPDController().computeForAngles(currentPosition, desiredPosition, currentRate, desiredRate);
        return this.computeIntegralEffortAndAddPDEffort(deltaTime);
    }

    private double computeIntegralEffortAndAddPDEffort(double deltaTime) {
        double outputSignal = this.getPDController().getProportionalGain() * this.getPDController().getPositionError() + this.getPDController().getDerivativeGain() * this.getPDController().getRateError();
        if (this.getIntegralGain() < 1.0E-5) {
            this.cumulativeError.set(0.0);
        } else {
            double maxError = this.getMaxIntegralError();
            double errorAfterLeak = this.getPDController().getPositionError() * deltaTime + this.getIntegralLeakRatio() * this.cumulativeError.getDoubleValue();
            this.cumulativeError.set(MathTools.clamp((double)errorAfterLeak, (double)maxError));
            this.actionI.set(this.getIntegralGain() * this.cumulativeError.getDoubleValue());
            outputSignal += this.actionI.getDoubleValue();
        }
        double maximumOutput = Math.abs(this.getMaximumFeedback());
        outputSignal = MathTools.clamp((double)outputSignal, (double)maximumOutput);
        return outputSignal;
    }
}

