/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.alphaToAlpha;

import us.ihmc.robotics.alphaToAlpha.AlphaToAlphaFunction;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoVariableRampUpAndDownAlphaToAlpha
implements AlphaToAlphaFunction {
    private final YoDouble startOfRampUp;
    private final YoDouble endOfRamp;
    private final YoDouble startOfRampDown;
    private final YoDouble endOfRampDown;

    public YoVariableRampUpAndDownAlphaToAlpha(YoDouble startOfRampUp, YoDouble endOfRamp, YoDouble startOfRampDown, YoDouble endOfRampDown) {
        this.startOfRampUp = startOfRampUp;
        this.endOfRamp = endOfRamp;
        this.startOfRampDown = startOfRampDown;
        this.endOfRampDown = endOfRampDown;
    }

    @Override
    public double getAlphaPrime(double alpha) {
        if (!this.areVariablesInIncreasingOrderAndLessThanOne()) {
            return 0.0;
        }
        if (alpha < this.startOfRampUp.getDoubleValue()) {
            return 0.0;
        }
        if (alpha < this.endOfRamp.getDoubleValue()) {
            return (alpha - this.startOfRampUp.getDoubleValue()) / (this.endOfRamp.getDoubleValue() - this.startOfRampUp.getDoubleValue());
        }
        if (alpha < this.startOfRampDown.getDoubleValue()) {
            return 1.0;
        }
        if (alpha < this.endOfRampDown.getDoubleValue()) {
            return 1.0 - (alpha - this.startOfRampDown.getDoubleValue()) / (this.endOfRampDown.getDoubleValue() - this.startOfRampDown.getDoubleValue());
        }
        return 0.0;
    }

    @Override
    public double getMaxAlpha() {
        return 1.0;
    }

    @Override
    public double getDerivativeAtAlpha(double alpha) {
        return Double.NaN;
    }

    @Override
    public double getSecondDerivativeAtAlpha(double alpha) {
        return Double.NaN;
    }

    private boolean areVariablesInIncreasingOrderAndLessThanOne() {
        if (this.startOfRampUp.getDoubleValue() <= 0.0) {
            return false;
        }
        if (this.endOfRamp.getDoubleValue() <= this.startOfRampUp.getDoubleValue()) {
            return false;
        }
        if (this.startOfRampDown.getDoubleValue() <= this.endOfRamp.getDoubleValue()) {
            return false;
        }
        if (this.endOfRampDown.getDoubleValue() <= this.startOfRampDown.getDoubleValue()) {
            return false;
        }
        return !(this.endOfRampDown.getDoubleValue() >= 1.0);
    }
}

