/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.alphaToAlpha;

import us.ihmc.robotics.alphaToAlpha.AlphaToAlphaFunction;
import us.ihmc.robotics.trajectories.MinimumJerkTrajectory;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoMiniJerkUpAndDownAlphaToAlpha
implements AlphaToAlphaFunction {
    private final YoDouble startOfRampUp;
    private final YoDouble endOfRamp;
    private final YoDouble startOfRampDown;
    private final YoDouble endOfRampDown;
    private final MinimumJerkTrajectory minimumJerkTrajectory;

    public YoMiniJerkUpAndDownAlphaToAlpha(YoDouble startOfRampUp, YoDouble endOfRamp, YoDouble startOfRampDown, YoDouble endOfRampDown) {
        this.startOfRampUp = startOfRampUp;
        this.endOfRamp = endOfRamp;
        this.startOfRampDown = startOfRampDown;
        this.endOfRampDown = endOfRampDown;
        this.minimumJerkTrajectory = new MinimumJerkTrajectory();
    }

    @Override
    public double getAlphaPrime(double alpha) {
        if (!this.areVariablesInIncreasingOrderAndLessThanOne()) {
            return 0.0;
        }
        if (alpha < this.startOfRampUp.getDoubleValue()) {
            return 0.0;
        }
        if (alpha < this.endOfRamp.getDoubleValue()) {
            double rampUpFraction = alpha - this.startOfRampUp.getDoubleValue();
            this.minimumJerkTrajectory.setMoveParameters(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, this.endOfRamp.getDoubleValue() - this.startOfRampUp.getDoubleValue());
            this.minimumJerkTrajectory.computeTrajectory(rampUpFraction);
            return this.minimumJerkTrajectory.getPosition();
        }
        if (alpha < this.startOfRampDown.getDoubleValue()) {
            return 1.0;
        }
        if (alpha < this.endOfRampDown.getDoubleValue()) {
            double rampUpFraction = alpha - this.startOfRampDown.getDoubleValue();
            this.minimumJerkTrajectory.setMoveParameters(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, this.endOfRampDown.getDoubleValue() - this.startOfRampDown.getDoubleValue());
            this.minimumJerkTrajectory.computeTrajectory(rampUpFraction);
            return this.minimumJerkTrajectory.getPosition();
        }
        return 0.0;
    }

    @Override
    public double getMaxAlpha() {
        return 1.0;
    }

    @Override
    public double getDerivativeAtAlpha(double alpha) {
        return Double.NaN;
    }

    @Override
    public double getSecondDerivativeAtAlpha(double alpha) {
        return Double.NaN;
    }

    private boolean areVariablesInIncreasingOrderAndLessThanOne() {
        if (this.startOfRampUp.getDoubleValue() <= 0.0) {
            return false;
        }
        if (this.endOfRamp.getDoubleValue() <= this.startOfRampUp.getDoubleValue()) {
            return false;
        }
        if (this.startOfRampDown.getDoubleValue() <= this.endOfRamp.getDoubleValue()) {
            return false;
        }
        if (this.endOfRampDown.getDoubleValue() <= this.startOfRampDown.getDoubleValue()) {
            return false;
        }
        return !(this.endOfRampDown.getDoubleValue() >= 1.0);
    }

    public static void main(String[] args) {
        YoRegistry registry = new YoRegistry("dummy");
        YoDouble startOfRampUp = new YoDouble("startOfRampUp", registry);
        YoDouble endOfRamp = new YoDouble("endOfRamp", registry);
        YoDouble startOfRampDown = new YoDouble("startOfRampDown", registry);
        YoDouble endOfRampDown = new YoDouble("endOfRampDown", registry);
        YoMiniJerkUpAndDownAlphaToAlpha yoMiniJerkUpAndDownAlphaToAlpha = new YoMiniJerkUpAndDownAlphaToAlpha(startOfRampUp, endOfRamp, startOfRampDown, endOfRampDown);
        startOfRampUp.set(0.1);
        endOfRamp.set(0.3);
        startOfRampDown.set(0.5);
        endOfRampDown.set(0.7);
        for (double alpha = 0.0; alpha <= 1.0; alpha += 0.01) {
            double alphaPrime = yoMiniJerkUpAndDownAlphaToAlpha.getAlphaPrime(alpha);
            System.out.println(alpha + ", " + alphaPrime);
        }
    }
}

