/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.alphaToAlpha;

import us.ihmc.robotics.alphaToAlpha.AlphaToAlphaFunction;

public class StretchedSlowInMiddleAlphaToAlphaFunction
implements AlphaToAlphaFunction {
    private final double derivativeAtStartAndEnd;
    private final double ratio;
    private final double alphaHoldSteady;
    private final double a1;
    private final double a3;
    private final double a4;
    private final double a5;
    private static final double ratioRequiringStop = 2.142857142857143;

    public StretchedSlowInMiddleAlphaToAlphaFunction(double derivativeAtStartAndEnd) {
        if (Double.isNaN(derivativeAtStartAndEnd)) {
            throw new RuntimeException("Double.isNaN(derivativeAtStartAndEnd)");
        }
        if (Double.isInfinite(derivativeAtStartAndEnd)) {
            throw new RuntimeException("Double.isInfinite(derivativeAtStartAndEnd)");
        }
        this.derivativeAtStartAndEnd = derivativeAtStartAndEnd;
        if (derivativeAtStartAndEnd < 1.0) {
            throw new RuntimeException("We are assuming derivativeAtStartAndEnd >= 1.0!!!");
        }
        if (derivativeAtStartAndEnd > 2.142857142857143) {
            this.alphaHoldSteady = 1.0714285714285714 / derivativeAtStartAndEnd;
            this.ratio = 2.142857142857143;
        } else {
            this.alphaHoldSteady = 0.5;
            this.ratio = derivativeAtStartAndEnd;
        }
        this.a1 = this.ratio;
        this.a3 = -10.0 * this.ratio + 10.0;
        this.a4 = 15.0 * this.ratio - 15.0;
        this.a5 = -6.0 * this.ratio + 6.0;
    }

    @Override
    public double getAlphaPrime(double alpha) {
        if (alpha < 0.0) {
            return 0.0;
        }
        if (alpha > 1.0) {
            return 1.0;
        }
        double ret = this.a1 * (alpha = alpha <= this.alphaHoldSteady ? 0.5 * alpha / this.alphaHoldSteady : (alpha > 1.0 - this.alphaHoldSteady ? 0.5 + 0.5 * ((alpha - (1.0 - this.alphaHoldSteady)) / this.alphaHoldSteady) : 0.5)) + this.a3 * alpha * alpha * alpha + this.a4 * alpha * alpha * alpha * alpha + this.a5 * alpha * alpha * alpha * alpha * alpha;
        if (ret < 0.0) {
            return 0.0;
        }
        if (ret > 1.0) {
            return 1.0;
        }
        return ret;
    }

    @Override
    public double getMaxAlpha() {
        return 1.0;
    }

    @Override
    public double getDerivativeAtAlpha(double alpha) {
        double scaling;
        if (alpha < 0.0 || alpha > 1.0) {
            return 0.0;
        }
        if (alpha <= this.alphaHoldSteady) {
            alpha = 0.5 * alpha / this.alphaHoldSteady;
            scaling = 0.5 / this.alphaHoldSteady;
        } else if (alpha > 1.0 - this.alphaHoldSteady) {
            alpha = 0.5 + 0.5 * ((alpha - (1.0 - this.alphaHoldSteady)) / this.alphaHoldSteady);
            scaling = 0.5 / this.alphaHoldSteady;
        } else {
            return 0.0;
        }
        return scaling * (this.a1 + 3.0 * this.a3 * alpha * alpha + 4.0 * this.a4 * alpha * alpha * alpha + 5.0 * this.a5 * alpha * alpha * alpha * alpha);
    }

    @Override
    public double getSecondDerivativeAtAlpha(double alpha) {
        double scaling;
        if (alpha < 0.0 || alpha > 1.0) {
            return 0.0;
        }
        if (alpha <= this.alphaHoldSteady) {
            alpha = 0.5 * alpha / this.alphaHoldSteady;
            scaling = 0.5 / this.alphaHoldSteady;
        } else if (alpha > 1.0 - this.alphaHoldSteady) {
            alpha = 0.5 + 0.5 * ((alpha - (1.0 - this.alphaHoldSteady)) / this.alphaHoldSteady);
            scaling = 0.5 / this.alphaHoldSteady;
        } else {
            return 0.0;
        }
        return scaling * scaling * (6.0 * this.a3 * alpha + 12.0 * this.a4 * alpha * alpha + 20.0 * this.a5 * alpha * alpha * alpha);
    }

    public static void main(String[] args) {
        new StretchedSlowInMiddleAlphaToAlphaFunction(3.0);
    }
}

