/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.alphaToAlpha;

import us.ihmc.robotics.alphaToAlpha.AlphaToAlphaFunction;

public class RampedClippedAlphaToAlpha
implements AlphaToAlphaFunction {
    private final double upRampStart;
    private final double upRampEnd;
    private final double downRampStart;
    private final double downRampEnd;

    public RampedClippedAlphaToAlpha(double upRampStart, double upRampEnd, double downRampStart, double downRampEnd) {
        this.upRampStart = upRampStart;
        this.upRampEnd = upRampEnd;
        this.downRampStart = downRampStart;
        this.downRampEnd = downRampEnd;
    }

    @Override
    public double getAlphaPrime(double alpha) {
        if (alpha < this.upRampStart) {
            return 0.0;
        }
        if (alpha < this.upRampEnd) {
            return (alpha - this.upRampStart) / (this.upRampEnd - this.upRampStart);
        }
        if (alpha < this.downRampStart) {
            return 1.0;
        }
        if (alpha < this.downRampEnd) {
            return 1.0 - (alpha - this.downRampStart) / (this.downRampEnd - this.downRampStart);
        }
        return 0.0;
    }

    @Override
    public double getMaxAlpha() {
        return 1.0;
    }

    @Override
    public double getDerivativeAtAlpha(double alpha) {
        throw new RuntimeException("Not implemented yet!");
    }

    @Override
    public double getSecondDerivativeAtAlpha(double alpha) {
        throw new RuntimeException("Not implemented yet!");
    }

    public static void main(String[] args) {
        new RampedClippedAlphaToAlpha(0.1, 0.2, 0.8, 0.9);
    }
}

