/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoIOTools;
import us.ihmc.robotics.EuclidCoreMissingTools;

public class MecanoMissingTools {
    public static WrenchReadOnly newLinkedWrenchReadOnly(final ReferenceFrameHolder bodyFrame, ReferenceFrameHolder expressedInFrame, final DMatrixRMaj wrenchMatrixSource) {
        final FrameVector3DReadOnly angularPart = EuclidCoreMissingTools.newLinkedFrameVector3DReadOnly(expressedInFrame, 0, wrenchMatrixSource);
        final FrameVector3DReadOnly linearPart = EuclidCoreMissingTools.newLinkedFrameVector3DReadOnly(expressedInFrame, 3, wrenchMatrixSource);
        return new WrenchReadOnly(){

            public ReferenceFrame getBodyFrame() {
                return bodyFrame.getReferenceFrame();
            }

            public ReferenceFrame getReferenceFrame() {
                return angularPart.getReferenceFrame();
            }

            public FrameVector3DReadOnly getAngularPart() {
                return angularPart;
            }

            public FrameVector3DReadOnly getLinearPart() {
                return linearPart;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof WrenchReadOnly) {
                    return this.equals((WrenchReadOnly)object);
                }
                return false;
            }

            public void get(DMatrix matrixToPack) {
                matrixToPack.set((Matrix)wrenchMatrixSource);
            }

            public String toString() {
                return MecanoIOTools.getWrenchString((WrenchReadOnly)this);
            }
        };
    }
}

