/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotDescription;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.robotDescription.CameraSensorDescription;
import us.ihmc.robotics.robotDescription.ExternalForcePointDescription;
import us.ihmc.robotics.robotDescription.ForceSensorDescription;
import us.ihmc.robotics.robotDescription.GroundContactPointDescription;
import us.ihmc.robotics.robotDescription.IMUSensorDescription;
import us.ihmc.robotics.robotDescription.JointWrenchSensorDescription;
import us.ihmc.robotics.robotDescription.KinematicPointDescription;
import us.ihmc.robotics.robotDescription.LidarSensorDescription;
import us.ihmc.robotics.robotDescription.LinkDescription;
import us.ihmc.robotics.robotDescription.LoopClosureConstraintDescription;
import us.ihmc.robotics.robotDescription.RobotDescriptionNode;
import us.ihmc.robotics.robotDescription.SensorDescription;

public class JointDescription
implements RobotDescriptionNode {
    private final String name;
    private final List<JointDescription> childrenJointDescriptions = new ArrayList<JointDescription>();
    private final List<LoopClosureConstraintDescription> childrenConstraintDescriptions = new ArrayList<LoopClosureConstraintDescription>();
    private JointDescription parentJoint;
    private final Vector3D offsetFromParentJoint = new Vector3D();
    private LinkDescription link;
    private final List<KinematicPointDescription> kinematicPoints = new ArrayList<KinematicPointDescription>();
    private final List<ExternalForcePointDescription> externalForcePoints = new ArrayList<ExternalForcePointDescription>();
    private final List<GroundContactPointDescription> groundContactPoints = new ArrayList<GroundContactPointDescription>();
    private final List<JointWrenchSensorDescription> wrenchSensors = new ArrayList<JointWrenchSensorDescription>();
    private final List<CameraSensorDescription> cameraSensors = new ArrayList<CameraSensorDescription>();
    private final List<IMUSensorDescription> imuSensors = new ArrayList<IMUSensorDescription>();
    private final List<LidarSensorDescription> lidarSensors = new ArrayList<LidarSensorDescription>();
    private final List<ForceSensorDescription> forceSensors = new ArrayList<ForceSensorDescription>();
    private boolean isDynamic = true;

    public JointDescription(String name, Tuple3DReadOnly offsetFromParentJoint) {
        this.name = name;
        this.offsetFromParentJoint.set(offsetFromParentJoint);
    }

    public JointDescription(JointDescription other) {
        this.name = other.name;
        this.offsetFromParentJoint.set(other.offsetFromParentJoint);
        this.link = other.link == null ? null : other.link.copy();
        other.childrenConstraintDescriptions.forEach(kp -> this.childrenConstraintDescriptions.add(kp.copy()));
        this.childrenConstraintDescriptions.forEach(e -> e.setParentJoint(this));
        other.kinematicPoints.forEach(kp -> this.kinematicPoints.add(kp.copy()));
        other.externalForcePoints.forEach(efp -> this.externalForcePoints.add(efp.copy()));
        other.groundContactPoints.forEach(gcp -> this.groundContactPoints.add(gcp.copy()));
        other.wrenchSensors.forEach(sensor -> this.wrenchSensors.add(sensor.copy()));
        other.cameraSensors.forEach(sensor -> this.cameraSensors.add(sensor.copy()));
        other.imuSensors.forEach(sensor -> this.imuSensors.add(sensor.copy()));
        other.lidarSensors.forEach(sensor -> this.lidarSensors.add(sensor.copy()));
        other.forceSensors.forEach(sensor -> this.forceSensors.add(sensor.copy()));
        this.isDynamic = other.isDynamic;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setParentJoint(JointDescription parentJoint) {
        this.parentJoint = parentJoint;
    }

    public void setOffsetFromParentJoint(Tuple3DReadOnly offset) {
        this.offsetFromParentJoint.set(offset);
    }

    public JointDescription getParentJoint() {
        return this.parentJoint;
    }

    public Vector3DReadOnly getOffsetFromParentJoint() {
        return this.offsetFromParentJoint;
    }

    public void getOffsetFromParentJoint(Tuple3DBasics offsetToPack) {
        offsetToPack.set((Tuple3DReadOnly)this.offsetFromParentJoint);
    }

    public LinkDescription getLink() {
        return this.link;
    }

    public void setLink(LinkDescription link) {
        this.link = link;
    }

    public void addJoint(JointDescription childJointDescription) {
        this.childrenJointDescriptions.add(childJointDescription);
        if (childJointDescription.getParentJoint() != null) {
            throw new RuntimeException("JointDescription " + childJointDescription.getName() + "already has a parent joint: " + childJointDescription.getParentJoint().getName());
        }
        childJointDescription.setParentJoint(this);
    }

    public boolean removeJoint(JointDescription childJointDescription) {
        return this.childrenJointDescriptions.remove(childJointDescription);
    }

    public void addConstraint(LoopClosureConstraintDescription childConstraintDescription) {
        this.childrenConstraintDescriptions.add(childConstraintDescription);
        if (childConstraintDescription.getParentJoint() != null) {
            throw new RuntimeException("LoopClosureConstraintDescription " + childConstraintDescription.getName() + "already has a parent joint: " + childConstraintDescription.getParentJoint().getName());
        }
        childConstraintDescription.setParentJoint(this);
    }

    @Override
    public List<JointDescription> getChildrenJoints() {
        return this.childrenJointDescriptions;
    }

    public List<LoopClosureConstraintDescription> getChildrenConstraintDescriptions() {
        return this.childrenConstraintDescriptions;
    }

    public void addGroundContactPoint(GroundContactPointDescription groundContactPointDescription) {
        this.groundContactPoints.add(groundContactPointDescription);
    }

    public List<GroundContactPointDescription> getGroundContactPoints() {
        return this.groundContactPoints;
    }

    public void addExternalForcePoint(ExternalForcePointDescription externalForcePointDescription) {
        this.externalForcePoints.add(externalForcePointDescription);
    }

    public List<ExternalForcePointDescription> getExternalForcePoints() {
        return this.externalForcePoints;
    }

    public void addKinematicPoint(KinematicPointDescription kinematicPointDescription) {
        this.kinematicPoints.add(kinematicPointDescription);
    }

    public List<KinematicPointDescription> getKinematicPoints() {
        return this.kinematicPoints;
    }

    public void addJointWrenchSensor(JointWrenchSensorDescription jointWrenchSensorDescription) {
        this.wrenchSensors.add(jointWrenchSensorDescription);
    }

    public List<JointWrenchSensorDescription> getWrenchSensors() {
        return this.wrenchSensors;
    }

    public void addCameraSensor(CameraSensorDescription cameraSensorDescription) {
        this.cameraSensors.add(cameraSensorDescription);
    }

    public List<CameraSensorDescription> getCameraSensors() {
        return this.cameraSensors;
    }

    public void addIMUSensor(IMUSensorDescription imuSensorDescription) {
        this.imuSensors.add(imuSensorDescription);
    }

    public List<IMUSensorDescription> getIMUSensors() {
        return this.imuSensors;
    }

    public void addLidarSensor(LidarSensorDescription lidarSensor) {
        this.lidarSensors.add(lidarSensor);
    }

    public List<LidarSensorDescription> getLidarSensors() {
        return this.lidarSensors;
    }

    public void addForceSensor(ForceSensorDescription forceSensor) {
        this.forceSensors.add(forceSensor);
    }

    public List<ForceSensorDescription> getForceSensors() {
        return this.forceSensors;
    }

    public void setIsDynamic(boolean isDynamic) {
        this.isDynamic = isDynamic;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void getSensors(List<SensorDescription> sensors) {
        sensors.addAll(this.wrenchSensors);
        sensors.addAll(this.cameraSensors);
        sensors.addAll(this.imuSensors);
        sensors.addAll(this.lidarSensors);
        sensors.addAll(this.forceSensors);
    }

    public void getAllKinematicPoints(List<KinematicPointDescription> allKinematicPoints) {
        allKinematicPoints.addAll(this.kinematicPoints);
        allKinematicPoints.addAll(this.externalForcePoints);
        allKinematicPoints.addAll(this.groundContactPoints);
    }

    public static void scaleChildrenJoint(List<JointDescription> childrenJoints, double factor, double massScalePower, List<String> ignoreInertiaScaleJointList) {
        Vector3D offsetFromParentJoint = new Vector3D();
        for (int i = 0; i < childrenJoints.size(); ++i) {
            JointDescription description = childrenJoints.get(i);
            description.getOffsetFromParentJoint((Tuple3DBasics)offsetFromParentJoint);
            offsetFromParentJoint.scale(factor);
            description.setOffsetFromParentJoint((Tuple3DReadOnly)offsetFromParentJoint);
            description.scale(factor, massScalePower, ignoreInertiaScaleJointList);
        }
    }

    @Override
    public void scale(double factor, double massScalePower, List<String> ignoreInertiaScaleJointList) {
        this.scaleSensorsOffsets(factor);
        this.scaleAllKinematicsPointOffsets(factor);
        boolean scaleInertia = true;
        if (ignoreInertiaScaleJointList.contains(this.getName())) {
            scaleInertia = false;
        }
        this.link.scale(factor, massScalePower, scaleInertia);
        JointDescription.scaleChildrenJoint(this.getChildrenJoints(), factor, massScalePower, ignoreInertiaScaleJointList);
    }

    private void scaleSensorsOffsets(double factor) {
        ArrayList<SensorDescription> sensors = new ArrayList<SensorDescription>();
        this.getSensors(sensors);
        for (int i = 0; i < sensors.size(); ++i) {
            SensorDescription sensor = (SensorDescription)sensors.get(i);
            RigidBodyTransform transformToJoint = sensor.getTransformToJoint();
            Vector3D translation = new Vector3D();
            translation.set((Tuple3DReadOnly)transformToJoint.getTranslation());
            translation.scale(factor);
            transformToJoint.getTranslation().set((Tuple3DReadOnly)translation);
            sensor.setTransformToJoint((RigidBodyTransformReadOnly)transformToJoint);
        }
    }

    private void scaleAllKinematicsPointOffsets(double factor) {
        ArrayList<KinematicPointDescription> allKinematicPoints = new ArrayList<KinematicPointDescription>();
        this.getAllKinematicPoints(allKinematicPoints);
        for (int i = 0; i < allKinematicPoints.size(); ++i) {
            KinematicPointDescription kinematicPoint = (KinematicPointDescription)allKinematicPoints.get(i);
            Vector3D offset = kinematicPoint.getOffsetFromJoint();
            offset.scale(factor);
            kinematicPoint.setOffsetFromJoint((Tuple3DReadOnly)offset);
        }
    }

    @Override
    public JointDescription copy() {
        return new JointDescription(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", joint: " + this.name;
    }
}

