/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotDescription;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.robotDescription.CapsuleDescriptionReadOnly;
import us.ihmc.robotics.robotDescription.CollisionMaskHolder;
import us.ihmc.robotics.robotDescription.ConvexPolytopeDescriptionReadOnly;
import us.ihmc.robotics.robotDescription.ConvexShapeDescriptionReadOnly;
import us.ihmc.robotics.robotDescription.CubeDescriptionReadOnly;
import us.ihmc.robotics.robotDescription.CylinderDescriptionReadOnly;
import us.ihmc.robotics.robotDescription.SphereDescriptionReadOnly;

public class CollisionMeshDescription
implements CollisionMaskHolder {
    private final Pose3D pose = new Pose3D();
    private final ArrayList<ConvexShapeDescriptionReadOnly> convexShapeDescriptions = new ArrayList();
    private boolean isGround = false;
    private int collisionGroup = 0;
    private int collisionMask = 0;
    private int estimatedNumberOfContactPoints = 24;

    public void setEstimatedNumberOfContactPoints(int estimatedNumberOfContactPoints) {
        this.estimatedNumberOfContactPoints = estimatedNumberOfContactPoints;
    }

    public int getEstimatedNumberOfContactPoints() {
        return this.estimatedNumberOfContactPoints;
    }

    public void addConvexShape(ConvexShapeDescriptionReadOnly convexShapeDescription) {
        this.convexShapeDescriptions.add(convexShapeDescription);
    }

    public void addSphere(double radius) {
        SphereDescriptionReadOnly sphere = new SphereDescriptionReadOnly(radius, (RigidBodyTransformReadOnly)this.getRigidBodyTransformCopy());
        this.convexShapeDescriptions.add(sphere);
    }

    public void addCapsule(double radius, LineSegment3D capToCapLineSegment) {
        CapsuleDescriptionReadOnly capsule = new CapsuleDescriptionReadOnly(radius, capToCapLineSegment, this.getRigidBodyTransformCopy());
        this.convexShapeDescriptions.add(capsule);
    }

    public void addCapsule(double radius, double height, Axis3D longAxis) {
        CapsuleDescriptionReadOnly capsule = new CapsuleDescriptionReadOnly(radius, height, longAxis, this.getRigidBodyTransformCopy());
        this.convexShapeDescriptions.add(capsule);
    }

    public void addCapsule(double radius, double height) {
        CapsuleDescriptionReadOnly capsule = new CapsuleDescriptionReadOnly(radius, height, this.getRigidBodyTransformCopy());
        this.convexShapeDescriptions.add(capsule);
    }

    public void addCubeReferencedAtBottomMiddle(double lengthX, double widthY, double heightZ) {
        this.pose.appendTranslation(0.0, 0.0, heightZ / 2.0);
        CubeDescriptionReadOnly cube = new CubeDescriptionReadOnly(lengthX, widthY, heightZ, this.getRigidBodyTransformCopy());
        this.pose.appendTranslation(0.0, 0.0, -heightZ / 2.0);
        this.convexShapeDescriptions.add(cube);
    }

    public void addCubeReferencedAtCenter(double lengthX, double widthY, double heightZ) {
        CubeDescriptionReadOnly cube = new CubeDescriptionReadOnly(lengthX, widthY, heightZ, this.getRigidBodyTransformCopy());
        this.convexShapeDescriptions.add(cube);
    }

    public void addCylinderReferencedAtCenter(double radius, double height) {
        CylinderDescriptionReadOnly cylinder = new CylinderDescriptionReadOnly(radius, height, this.getRigidBodyTransformCopy());
        this.convexShapeDescriptions.add(cylinder);
    }

    public void addCylinderReferencedAtBottomMiddle(double radius, double height) {
        this.pose.appendTranslation(0.0, 0.0, height / 2.0);
        CylinderDescriptionReadOnly cylinder = new CylinderDescriptionReadOnly(radius, height, this.getRigidBodyTransformCopy());
        this.convexShapeDescriptions.add(cylinder);
        this.pose.appendTranslation(0.0, 0.0, -height / 2.0);
    }

    public void addConvexPolytope(ConvexPolytope3DReadOnly polytope) {
        ConvexPolytopeDescriptionReadOnly polytopeReadOnly = new ConvexPolytopeDescriptionReadOnly(polytope, this.getRigidBodyTransformCopy());
        this.convexShapeDescriptions.add(polytopeReadOnly);
    }

    private RigidBodyTransform getRigidBodyTransformCopy() {
        return new RigidBodyTransform((Orientation3DReadOnly)this.pose.getOrientation(), (Tuple3DReadOnly)this.pose.getPosition());
    }

    public void getConvexShapeDescriptions(List<ConvexShapeDescriptionReadOnly> convexShapeDescriptionsToPack) {
        convexShapeDescriptionsToPack.addAll(this.convexShapeDescriptions);
    }

    public boolean getIsGround() {
        return this.isGround;
    }

    @Override
    public int getCollisionGroup() {
        return this.collisionGroup;
    }

    @Override
    public int getCollisionMask() {
        return this.collisionMask;
    }

    public void setIsGround(boolean isGround) {
        this.isGround = isGround;
    }

    @Override
    public void setCollisionGroup(int collisionGroup) {
        this.collisionGroup = collisionGroup;
    }

    @Override
    public void setCollisionMask(int collisionMask) {
        this.collisionMask = collisionMask;
    }

    public void translate(double x, double y, double z) {
        this.pose.appendTranslation(x, y, z);
    }

    public void translate(Tuple3DReadOnly translationVector) {
        this.pose.appendTranslation(translationVector);
    }

    public void transform(RigidBodyTransform transform) {
        this.pose.set((RigidBodyTransformReadOnly)transform);
    }

    public void identity() {
        this.pose.setToZero();
    }

    public void rotateEuler(Vector3DReadOnly eulerAngles) {
        this.pose.appendYawRotation(eulerAngles.getZ());
        this.pose.appendPitchRotation(eulerAngles.getY());
        this.pose.appendRollRotation(eulerAngles.getZ());
    }

    public void rotate(Orientation3DReadOnly rotation) {
        this.pose.appendRotation(rotation);
    }

    public void rotate(double rotationAngle, Axis3D axis) {
        switch (axis) {
            case X: {
                this.pose.appendRollRotation(rotationAngle);
                break;
            }
            case Y: {
                this.pose.appendPitchRotation(rotationAngle);
                break;
            }
            case Z: {
                this.pose.appendYawRotation(rotationAngle);
            }
        }
    }

    public void scale(double factor) {
        throw new RuntimeException("TODO: Implement me");
    }

    public CollisionMeshDescription copy() {
        CollisionMeshDescription copy = new CollisionMeshDescription();
        copy.pose.set(this.pose);
        this.convexShapeDescriptions.forEach(shape -> copy.convexShapeDescriptions.add(shape.copy()));
        copy.isGround = this.isGround;
        copy.collisionGroup = this.collisionGroup;
        copy.collisionMask = this.collisionMask;
        copy.estimatedNumberOfContactPoints = this.estimatedNumberOfContactPoints;
        return copy;
    }
}

