/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotDescription;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.robotDescription.CameraSensorDescription;
import us.ihmc.robotics.robotDescription.CollisionMeshDescription;
import us.ihmc.robotics.robotDescription.ExternalForcePointDescription;
import us.ihmc.robotics.robotDescription.FloatingJointDescription;
import us.ihmc.robotics.robotDescription.FloatingPlanarJointDescription;
import us.ihmc.robotics.robotDescription.ForceSensorDescription;
import us.ihmc.robotics.robotDescription.GroundContactPointDescription;
import us.ihmc.robotics.robotDescription.IMUSensorDescription;
import us.ihmc.robotics.robotDescription.JointDescription;
import us.ihmc.robotics.robotDescription.JointWrenchSensorDescription;
import us.ihmc.robotics.robotDescription.KinematicPointDescription;
import us.ihmc.robotics.robotDescription.LidarSensorDescription;
import us.ihmc.robotics.robotDescription.LinkDescription;
import us.ihmc.robotics.robotDescription.LinkGraphicsDescription;
import us.ihmc.robotics.robotDescription.OneDoFJointDescription;
import us.ihmc.robotics.robotDescription.PinJointDescription;
import us.ihmc.robotics.robotDescription.Plane;
import us.ihmc.robotics.robotDescription.RobotDescription;
import us.ihmc.robotics.robotDescription.SliderJointDescription;

public class RobotDescriptionTest {
    @Test
    public void testRobotDescriptionOne() {
        RobotDescription robotDescription = new RobotDescription("Test");
        Assert.assertEquals("Test", robotDescription.getName());
        robotDescription.setName("TestTwo");
        Assert.assertEquals("TestTwo", robotDescription.getName());
        FloatingJointDescription rootJointOne = new FloatingJointDescription("rootJointOne");
        Assert.assertEquals("rootJointOne", rootJointOne.getName());
        LinkDescription rootLinkOne = new LinkDescription("rootLinkOne");
        Assert.assertEquals("rootLinkOne", rootLinkOne.getName());
        rootLinkOne.setMass(1.2);
        rootLinkOne.setCenterOfMassOffset((Tuple3DReadOnly)new Vector3D(1.0, 2.0, 3.0));
        rootLinkOne.setMomentOfInertia(0.1, 0.2, 0.3);
        Assert.assertEquals(1.2, rootLinkOne.getMass(), 1.0E-7);
        Vector3D comOffsetCheck = new Vector3D();
        rootLinkOne.getCenterOfMassOffset((Tuple3DBasics)comOffsetCheck);
        EuclidCoreTestTools.assertEquals((String)"", (EuclidGeometry)new Vector3D(1.0, 2.0, 3.0), (EuclidGeometry)comOffsetCheck, (double)1.0E-7);
        EuclidCoreTestTools.assertEquals((String)"", (EuclidGeometry)new Vector3D(1.0, 2.0, 3.0), (EuclidGeometry)rootLinkOne.getCenterOfMassOffset(), (double)1.0E-7);
        Matrix3D momentOfInertiaCopy = rootLinkOne.getMomentOfInertiaCopy();
        Assert.assertEquals(0.1, momentOfInertiaCopy.getM00(), 1.0E-7);
        Assert.assertEquals(0.2, momentOfInertiaCopy.getM11(), 1.0E-7);
        Assert.assertEquals(0.3, momentOfInertiaCopy.getM22(), 1.0E-7);
        DMatrixRMaj momentOfInertiaCheck = rootLinkOne.getMomentOfInertia();
        Assert.assertEquals(0.1, momentOfInertiaCheck.get(0, 0), 1.0E-7);
        Assert.assertEquals(0.2, momentOfInertiaCheck.get(1, 1), 1.0E-7);
        Assert.assertEquals(0.3, momentOfInertiaCheck.get(2, 2), 1.0E-7);
        rootJointOne.setLink(rootLinkOne);
        Assert.assertTrue(rootJointOne.getLink() == rootLinkOne);
        robotDescription.addRootJoint((JointDescription)rootJointOne);
        List rootJoints = robotDescription.getRootJoints();
        Assert.assertEquals(1L, rootJoints.size());
        Assert.assertTrue(rootJointOne == rootJoints.get(0));
        PinJointDescription rootJointTwo = new PinJointDescription("rootJointTwo", (Tuple3DReadOnly)new Vector3D(-0.1, -0.2, -0.3), (Vector3DReadOnly)Axis3D.Y);
        Vector3D jointAxisCheck = new Vector3D();
        rootJointTwo.getJointAxis((Vector3DBasics)jointAxisCheck);
        EuclidCoreTestTools.assertEquals((String)"", (EuclidGeometry)new Vector3D(0.0, 1.0, 0.0), (EuclidGeometry)jointAxisCheck, (double)1.0E-7);
        LinkDescription rootLinkTwo = new LinkDescription("rootLinkTwo");
        Assert.assertEquals("rootLinkTwo", rootLinkTwo.getName());
        rootLinkTwo.setMass(1.2);
        rootLinkTwo.setCenterOfMassOffset((Tuple3DReadOnly)new Vector3D(1.0, 2.0, 3.0));
        rootLinkTwo.setMomentOfInertia(0.1, 0.2, 0.3);
        rootJointTwo.setLink(rootLinkTwo);
        robotDescription.addRootJoint((JointDescription)rootJointTwo);
        Assert.assertEquals(2L, robotDescription.getChildrenJoints().size());
        Assert.assertTrue(rootJointOne == robotDescription.getChildrenJoints().get(0));
        Assert.assertTrue(rootJointTwo == robotDescription.getChildrenJoints().get(1));
        PinJointDescription childJointOne = new PinJointDescription("childJointOne", (Tuple3DReadOnly)new Vector3D(1.2, 1.3, 7.7), (Vector3DReadOnly)Axis3D.Z);
        Vector3D jointOffsetCheck = new Vector3D();
        childJointOne.getOffsetFromParentJoint((Tuple3DBasics)jointOffsetCheck);
        EuclidCoreTestTools.assertEquals((String)"", (EuclidGeometry)new Vector3D(1.2, 1.3, 7.7), (EuclidGeometry)jointOffsetCheck, (double)1.0E-7);
        LinkDescription childLinkOne = new LinkDescription("childLinkOne");
        childLinkOne.setMass(3.3);
        DMatrixRMaj childMomentOfInertiaOne = new DMatrixRMaj((double[][])new double[][]{{1.0, 0.012, 0.013}, {0.021, 2.0, 0.023}, {0.031, 0.032, 3.0}});
        childLinkOne.setMomentOfInertia((DMatrix)childMomentOfInertiaOne);
        DMatrixRMaj childMomentOfInertiaOneCheck = new DMatrixRMaj(3, 3);
        childLinkOne.getMomentOfInertia((DMatrix)childMomentOfInertiaOneCheck);
        Assert.assertTrue(MatrixFeatures_DDRM.isEquals((DMatrixD1)new DMatrixRMaj((double[][])new double[][]{{1.0, 0.012, 0.013}, {0.021, 2.0, 0.023}, {0.031, 0.032, 3.0}}), (DMatrixD1)childMomentOfInertiaOneCheck, (double)1.0E-7));
        rootJointOne.addJoint((JointDescription)childJointOne);
        RigidBodyTransform cameraOneTransformToJoint = new RigidBodyTransform();
        CameraSensorDescription cameraOneDescription = new CameraSensorDescription("cameraOne", (RigidBodyTransformReadOnly)cameraOneTransformToJoint);
        childJointOne.addCameraSensor(cameraOneDescription);
        List cameraSensors = childJointOne.getCameraSensors();
        Assert.assertEquals(1L, cameraSensors.size());
        Assert.assertTrue(cameraOneDescription == cameraSensors.get(0));
        Assert.assertEquals(rootJointOne, childJointOne.getParentJoint());
        Assert.assertNull(rootJointOne.getParentJoint());
        childJointOne.setOffsetFromParentJoint((Tuple3DReadOnly)new Vector3D(-0.4, -0.5, -0.6));
        childJointOne.getOffsetFromParentJoint((Tuple3DBasics)jointOffsetCheck);
        EuclidCoreTestTools.assertEquals((String)"", (EuclidGeometry)new Vector3D(-0.4, -0.5, -0.6), (EuclidGeometry)jointOffsetCheck, (double)1.0E-7);
        Assert.assertFalse(childJointOne.containsLimitStops());
        double qMin = -0.2;
        double qMax = 0.4;
        double kLimit = 1000.0;
        double bLimit = 100.0;
        childJointOne.setLimitStops(qMin, qMax, kLimit, bLimit);
        double[] limitStopParameters = childJointOne.getLimitStopParameters();
        Assert.assertEquals(4L, limitStopParameters.length);
        Assert.assertEquals(qMin, limitStopParameters[0], 1.0E-7);
        Assert.assertEquals(qMax, limitStopParameters[1], 1.0E-7);
        Assert.assertEquals(kLimit, limitStopParameters[2], 1.0E-7);
        Assert.assertEquals(bLimit, limitStopParameters[3], 1.0E-7);
        Assert.assertEquals(qMin, childJointOne.getLowerLimit(), 1.0E-7);
        Assert.assertEquals(qMax, childJointOne.getUpperLimit(), 1.0E-7);
        childJointOne.setDamping(4.4);
        Assert.assertEquals(4.4, childJointOne.getDamping(), 1.0E-7);
        childJointOne.setStiction(7.7);
        Assert.assertEquals(7.7, childJointOne.getStiction(), 1.0E-7);
        childJointOne.setEffortLimit(400.3);
        Assert.assertEquals(400.3, childJointOne.getEffortLimit(), 1.0E-7);
        childJointOne.setVelocityLimits(10.0, 30.0);
        Assert.assertEquals(10.0, childJointOne.getVelocityLimit(), 1.0E-7);
        Assert.assertEquals(30.0, childJointOne.getVelocityDamping(), 1.0E-7);
        Assert.assertTrue(childJointOne.containsLimitStops());
        childJointOne.getJointAxis((Vector3DBasics)jointAxisCheck);
        EuclidCoreTestTools.assertEquals((String)"", (EuclidGeometry)new Vector3D(0.0, 0.0, 1.0), (EuclidGeometry)jointAxisCheck, (double)1.0E-7);
        SliderJointDescription childJointTwo = new SliderJointDescription("childJointTwo", (Tuple3DReadOnly)new Vector3D(0.5, 0.7, 0.9), (Vector3DReadOnly)new Vector3D(1.1, 2.2, 3.3));
        Assert.assertTrue(Double.POSITIVE_INFINITY == childJointTwo.getEffortLimit());
        Assert.assertTrue(Double.POSITIVE_INFINITY == childJointTwo.getVelocityLimit());
        Assert.assertFalse(childJointTwo.containsLimitStops());
        Assert.assertTrue(Double.NEGATIVE_INFINITY == childJointTwo.getLowerLimit());
        Assert.assertTrue(Double.POSITIVE_INFINITY == childJointTwo.getUpperLimit());
        limitStopParameters = childJointTwo.getLimitStopParameters();
        Assert.assertTrue(Double.NEGATIVE_INFINITY == limitStopParameters[0]);
        Assert.assertTrue(Double.POSITIVE_INFINITY == limitStopParameters[1]);
        Assert.assertEquals(0.0, limitStopParameters[2], 1.0E-7);
        Assert.assertEquals(0.0, limitStopParameters[3], 1.0E-7);
        Assert.assertEquals(0.0, childJointTwo.getVelocityDamping(), 1.0E-7);
        Assert.assertEquals(0.0, childJointTwo.getDamping(), 1.0E-7);
        Assert.assertEquals(0.0, childJointTwo.getStiction(), 1.0E-7);
        childJointTwo.getJointAxis((Vector3DBasics)jointAxisCheck);
        EuclidCoreTestTools.assertEquals((String)"", (EuclidGeometry)new Vector3D(1.1, 2.2, 3.3), (EuclidGeometry)jointAxisCheck, (double)1.0E-7);
        LinkDescription childLinkTwo = new LinkDescription("childLinkTwo");
        childLinkTwo.setMass(9.9);
        childLinkTwo.setMomentOfInertia(1.9, 2.2, 0.4);
        EuclidCoreTestTools.assertEquals((String)"", (EuclidGeometry)new Vector3D(), (EuclidGeometry)childLinkTwo.getCenterOfMassOffset(), (double)1.0E-7);
        childJointTwo.setLink(childLinkTwo);
        rootJointOne.addJoint((JointDescription)childJointTwo);
        List childrenJoints = rootJointOne.getChildrenJoints();
        Assert.assertEquals(2L, childrenJoints.size());
        Assert.assertTrue(childJointOne == childrenJoints.get(0));
        Assert.assertTrue(childJointTwo == childrenJoints.get(1));
        PinJointDescription childJointThree = new PinJointDescription("childJointThree", (Tuple3DReadOnly)new Vector3D(9.9, 0.0, -0.5), (Vector3DReadOnly)Axis3D.X);
        childJointThree.getOffsetFromParentJoint((Tuple3DBasics)jointOffsetCheck);
        EuclidCoreTestTools.assertEquals((String)"", (EuclidGeometry)new Vector3D(9.9, 0.0, -0.5), (EuclidGeometry)jointOffsetCheck, (double)1.0E-7);
        childJointThree.getJointAxis((Vector3DBasics)jointAxisCheck);
        EuclidCoreTestTools.assertEquals((String)"", (EuclidGeometry)new Vector3D(1.0, 0.0, 0.0), (EuclidGeometry)jointAxisCheck, (double)1.0E-7);
        LinkDescription childLinkThree = new LinkDescription("childLinkThree");
        childLinkThree.setMass(1.9);
        childLinkThree.setMomentOfInertia(0.2, 0.3, 0.4);
        LinkGraphicsDescription childGraphicsThree = new LinkGraphicsDescription();
        childLinkThree.setLinkGraphics(childGraphicsThree);
        CollisionMeshDescription childMeshThree = new CollisionMeshDescription();
        childLinkThree.addCollisionMesh(childMeshThree);
        childJointThree.setLink(childLinkThree);
        childJointTwo.addJoint((JointDescription)childJointThree);
        childrenJoints = childJointTwo.getChildrenJoints();
        Assert.assertEquals(1L, childrenJoints.size());
        Assert.assertTrue(childJointThree == childrenJoints.get(0));
        Assert.assertTrue(childJointTwo == childJointThree.getParentJoint());
        JointDescription jointDescriptionCheck = robotDescription.getJointDescription("rootJointOne");
        Assert.assertTrue(rootJointOne == jointDescriptionCheck);
        jointDescriptionCheck = robotDescription.getJointDescription("rootJointTwo");
        Assert.assertTrue(rootJointTwo == jointDescriptionCheck);
        jointDescriptionCheck = robotDescription.getJointDescription("childJointOne");
        Assert.assertTrue(childJointOne == jointDescriptionCheck);
        jointDescriptionCheck = robotDescription.getJointDescription("childJointTwo");
        Assert.assertTrue(childJointTwo == jointDescriptionCheck);
        jointDescriptionCheck = robotDescription.getJointDescription("childJointThree");
        Assert.assertTrue(childJointThree == jointDescriptionCheck);
        Assert.assertNull(robotDescription.getJointDescription("noSuchJoint"));
        Assert.assertNull(robotDescription.getGraphicsObject("noSuchJoint"));
        Graphics3DObject linkGraphicsCheck = robotDescription.getGraphicsObject("childJointThree");
        Assert.assertTrue(linkGraphicsCheck == childGraphicsThree);
    }

    @Test
    public void testCloneConstructor() {
        Random random = new Random(457657L);
        for (int i = 0; i < 1000; ++i) {
            String namePrefix = "Bolop";
            int numberOfJoints = random.nextInt(100) + 5;
            RobotDescription original = RobotDescriptionTest.nextRobotDescription(random, namePrefix, numberOfJoints);
            RobotDescription clone = new RobotDescription(original);
            RobotDescriptionTest.assertRobotDescriptionEquals(original, clone);
        }
    }

    private static void assertRobotDescriptionEquals(RobotDescription expected, RobotDescription actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            Assertions.fail();
        }
        Assert.assertEquals(expected.getName(), actual.getName());
        Assert.assertEquals(expected.getChildrenJoints().size(), actual.getChildrenJoints().size());
        for (int i = 0; i < expected.getChildrenJoints().size(); ++i) {
            JointDescription expectedChild = (JointDescription)expected.getChildrenJoints().get(i);
            JointDescription actualChild = actual.getChildrenJoints().stream().filter(e -> e.getName().equals(expectedChild.getName())).findFirst().orElse(null);
            Assertions.assertNotNull((Object)actualChild);
            RobotDescriptionTest.assertJointDescriptionEqualsRecursive(expectedChild, actualChild);
        }
    }

    private static void assertJointDescriptionEqualsRecursive(JointDescription expected, JointDescription actual) {
        RobotDescriptionTest.assertJointDescriptionEquals(expected, actual);
        for (int i = 0; i < expected.getChildrenJoints().size(); ++i) {
            JointDescription expectedChild = (JointDescription)expected.getChildrenJoints().get(i);
            JointDescription actualChild = actual.getChildrenJoints().stream().filter(e -> e.getName().equals(expectedChild.getName())).findFirst().orElse(null);
            Assertions.assertNotNull((Object)actualChild);
            RobotDescriptionTest.assertJointDescriptionEqualsRecursive(expectedChild, actualChild);
        }
    }

    private static void assertJointDescriptionEquals(JointDescription expected, JointDescription actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            Assertions.fail();
        }
        try {
            KinematicPointDescription actualSensor;
            String sensorName;
            KinematicPointDescription expectedSensor;
            int i;
            Assert.assertEquals(expected.getName(), actual.getName());
            Assert.assertEquals(expected.getClass(), actual.getClass());
            Assert.assertEquals(expected.isDynamic(), actual.isDynamic());
            Assert.assertEquals(expected.getOffsetFromParentJoint(), actual.getOffsetFromParentJoint());
            RobotDescriptionTest.assertLinkDescriptionEquals(expected.getLink(), actual.getLink());
            if (expected instanceof FloatingJointDescription) {
                RobotDescriptionTest.assertFloatingJointDescriptionPropertiesEqual((FloatingJointDescription)expected, (FloatingJointDescription)actual);
            } else if (expected instanceof FloatingPlanarJointDescription) {
                RobotDescriptionTest.assertFloatingPlanarJointDescriptionPropertiesEqual((FloatingPlanarJointDescription)expected, (FloatingPlanarJointDescription)actual);
            } else if (expected instanceof OneDoFJointDescription) {
                RobotDescriptionTest.assertOneDoFJointDescriptionPropertiesEqual((OneDoFJointDescription)expected, (OneDoFJointDescription)actual);
            } else {
                Assertions.fail((String)("Assertions not implemented for: " + expected.getClass().getSimpleName()));
            }
            JointDescription expectedParentJoint = expected.getParentJoint();
            JointDescription actualParentJoint = actual.getParentJoint();
            if (expectedParentJoint == null) {
                Assert.assertNull(actualParentJoint);
            } else {
                Assertions.assertNotNull((Object)actualParentJoint);
                Assert.assertEquals(expectedParentJoint.getName(), actualParentJoint.getName());
            }
            Assert.assertEquals(expected.getChildrenJoints().size(), actual.getChildrenJoints().size());
            for (i = 0; i < expected.getChildrenJoints().size(); ++i) {
                String childName = ((JointDescription)expected.getChildrenJoints().get(i)).getName();
                Assert.assertTrue(actual.getChildrenJoints().stream().anyMatch(actualChild -> actualChild.getName().equals(childName)));
            }
            Assert.assertEquals(expected.getKinematicPoints().size(), actual.getKinematicPoints().size());
            for (i = 0; i < expected.getKinematicPoints().size(); ++i) {
                expectedSensor = (KinematicPointDescription)expected.getKinematicPoints().get(i);
                sensorName = expectedSensor.getName();
                actualSensor = actual.getKinematicPoints().stream().filter(e -> e.getName().equals(sensorName)).findFirst().orElse(null);
                Assertions.assertNotNull((Object)actualSensor);
                Assert.assertEquals(expectedSensor.getOffsetFromJoint(), actualSensor.getOffsetFromJoint());
            }
            Assert.assertEquals(expected.getExternalForcePoints().size(), actual.getExternalForcePoints().size());
            for (i = 0; i < expected.getExternalForcePoints().size(); ++i) {
                expectedSensor = (ExternalForcePointDescription)expected.getExternalForcePoints().get(i);
                sensorName = expectedSensor.getName();
                actualSensor = actual.getExternalForcePoints().stream().filter(e -> e.getName().equals(sensorName)).findFirst().orElse(null);
                Assertions.assertNotNull((Object)actualSensor);
                Assert.assertEquals(expectedSensor.getOffsetFromJoint(), actualSensor.getOffsetFromJoint());
            }
            Assert.assertEquals(expected.getGroundContactPoints().size(), actual.getGroundContactPoints().size());
            for (i = 0; i < expected.getGroundContactPoints().size(); ++i) {
                expectedSensor = (GroundContactPointDescription)expected.getGroundContactPoints().get(i);
                sensorName = expectedSensor.getName();
                actualSensor = actual.getGroundContactPoints().stream().filter(e -> e.getName().equals(sensorName)).findFirst().orElse(null);
                Assertions.assertNotNull((Object)actualSensor);
                Assert.assertEquals(expectedSensor.getOffsetFromJoint(), actualSensor.getOffsetFromJoint());
            }
            Assert.assertEquals(expected.getWrenchSensors().size(), actual.getWrenchSensors().size());
            for (i = 0; i < expected.getWrenchSensors().size(); ++i) {
                expectedSensor = (JointWrenchSensorDescription)expected.getWrenchSensors().get(i);
                sensorName = expectedSensor.getName();
                actualSensor = actual.getWrenchSensors().stream().filter(e -> e.getName().equals(sensorName)).findFirst().orElse(null);
                Assertions.assertNotNull((Object)actualSensor);
                Assert.assertEquals(expectedSensor.getTransformToJoint(), actualSensor.getTransformToJoint());
            }
            Assert.assertEquals(expected.getCameraSensors().size(), actual.getCameraSensors().size());
            for (i = 0; i < expected.getCameraSensors().size(); ++i) {
                expectedSensor = (CameraSensorDescription)expected.getCameraSensors().get(i);
                sensorName = expectedSensor.getName();
                actualSensor = actual.getCameraSensors().stream().filter(e -> e.getName().equals(sensorName)).findFirst().orElse(null);
                Assertions.assertNotNull((Object)actualSensor);
                Assert.assertEquals(expectedSensor.getFieldOfView(), actualSensor.getFieldOfView());
                Assert.assertEquals(expectedSensor.getClipNear(), actualSensor.getClipNear());
                Assert.assertEquals(expectedSensor.getClipFar(), actualSensor.getClipFar());
                Assert.assertEquals(expectedSensor.getImageWidth(), actualSensor.getImageWidth());
                Assert.assertEquals(expectedSensor.getImageHeight(), actualSensor.getImageHeight());
                Assert.assertEquals(expectedSensor.getTransformToJoint(), actualSensor.getTransformToJoint());
            }
            Assert.assertEquals(expected.getIMUSensors().size(), actual.getIMUSensors().size());
            for (i = 0; i < expected.getIMUSensors().size(); ++i) {
                expectedSensor = (IMUSensorDescription)expected.getIMUSensors().get(i);
                sensorName = expectedSensor.getName();
                actualSensor = actual.getIMUSensors().stream().filter(e -> e.getName().equals(sensorName)).findFirst().orElse(null);
                Assertions.assertNotNull((Object)actualSensor);
                Assert.assertEquals(expectedSensor.getAccelerationNoiseMean(), actualSensor.getAccelerationNoiseMean());
                Assert.assertEquals(expectedSensor.getAccelerationNoiseStandardDeviation(), actualSensor.getAccelerationNoiseStandardDeviation());
                Assert.assertEquals(expectedSensor.getAccelerationBiasMean(), actualSensor.getAccelerationBiasMean());
                Assert.assertEquals(expectedSensor.getAccelerationBiasStandardDeviation(), actualSensor.getAccelerationBiasStandardDeviation());
                Assert.assertEquals(expectedSensor.getAngularVelocityNoiseMean(), actualSensor.getAngularVelocityNoiseMean());
                Assert.assertEquals(expectedSensor.getAngularVelocityNoiseStandardDeviation(), actualSensor.getAngularVelocityNoiseStandardDeviation());
                Assert.assertEquals(expectedSensor.getAngularVelocityBiasMean(), actualSensor.getAngularVelocityBiasMean());
                Assert.assertEquals(expectedSensor.getAngularVelocityBiasStandardDeviation(), actualSensor.getAngularVelocityBiasStandardDeviation());
                Assert.assertEquals(expectedSensor.getTransformToJoint(), actualSensor.getTransformToJoint());
            }
            Assert.assertEquals(expected.getLidarSensors().size(), actual.getLidarSensors().size());
            for (i = 0; i < expected.getLidarSensors().size(); ++i) {
                expectedSensor = (LidarSensorDescription)expected.getLidarSensors().get(i);
                sensorName = expectedSensor.getName();
                actualSensor = actual.getLidarSensors().stream().filter(e -> e.getName().equals(sensorName)).findFirst().orElse(null);
                Assertions.assertNotNull((Object)actualSensor);
                Assert.assertEquals(expectedSensor.getSweepYawMin(), actualSensor.getSweepYawMin());
                Assert.assertEquals(expectedSensor.getSweepYawMax(), actualSensor.getSweepYawMax());
                Assert.assertEquals(expectedSensor.getHeightPitchMin(), actualSensor.getHeightPitchMin());
                Assert.assertEquals(expectedSensor.getHeightPitchMax(), actualSensor.getHeightPitchMax());
                Assert.assertEquals(expectedSensor.getMinRange(), actualSensor.getMinRange());
                Assert.assertEquals(expectedSensor.getMaxRange(), actualSensor.getMaxRange());
                Assert.assertEquals(expectedSensor.getPointsPerSweep(), actualSensor.getPointsPerSweep());
                Assert.assertEquals(expectedSensor.getScanHeight(), actualSensor.getScanHeight());
                Assert.assertEquals(expectedSensor.getTransformToJoint(), actualSensor.getTransformToJoint());
            }
            Assert.assertEquals(expected.getForceSensors().size(), actual.getForceSensors().size());
            for (i = 0; i < expected.getForceSensors().size(); ++i) {
                expectedSensor = (ForceSensorDescription)expected.getForceSensors().get(i);
                sensorName = expectedSensor.getName();
                actualSensor = actual.getForceSensors().stream().filter(e -> e.getName().equals(sensorName)).findFirst().orElse(null);
                Assertions.assertNotNull((Object)actualSensor);
                Assert.assertEquals(expectedSensor.useShapeCollision(), actualSensor.useShapeCollision());
                Assert.assertEquals(expectedSensor.useGroundContactPoints(), actualSensor.useGroundContactPoints());
                Assert.assertEquals(expectedSensor.getTransformToJoint(), actualSensor.getTransformToJoint());
            }
        }
        catch (Throwable e2) {
            throw new AssertionFailedError("Assertion failed for joint: " + expected.getName(), e2);
        }
    }

    private static void assertFloatingJointDescriptionPropertiesEqual(FloatingJointDescription expected, FloatingJointDescription actual) {
        Assert.assertEquals(expected.getJointVariableName(), actual.getJointVariableName());
    }

    private static void assertFloatingPlanarJointDescriptionPropertiesEqual(FloatingPlanarJointDescription expected, FloatingPlanarJointDescription actual) {
        Assert.assertEquals(expected.getPlane(), actual.getPlane());
    }

    private static void assertOneDoFJointDescriptionPropertiesEqual(OneDoFJointDescription expected, OneDoFJointDescription actual) {
        Assert.assertEquals(expected.containsLimitStops(), actual.containsLimitStops());
        Assert.assertEquals(expected.getLowerLimit(), actual.getLowerLimit());
        Assert.assertEquals(expected.getUpperLimit(), actual.getUpperLimit());
        Assertions.assertArrayEquals((double[])expected.getLimitStopParameters(), (double[])actual.getLimitStopParameters());
        Assert.assertEquals(expected.getDamping(), actual.getDamping());
        Assert.assertEquals(expected.getStiction(), actual.getStiction());
        Assert.assertEquals(expected.getVelocityLimit(), actual.getVelocityLimit());
        Assert.assertEquals(expected.getVelocityDamping(), actual.getVelocityDamping());
        Assert.assertEquals(expected.getJointAxis(), actual.getJointAxis());
        Assert.assertEquals(expected.getEffortLimit(), actual.getEffortLimit());
    }

    private static void assertLinkDescriptionEquals(LinkDescription expected, LinkDescription actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            Assertions.fail();
        }
        Assert.assertEquals(expected.getName(), actual.getName());
        Assert.assertEquals(expected.getMass(), actual.getMass());
        Assert.assertEquals(expected.getCenterOfMassOffset(), actual.getCenterOfMassOffset());
        Assert.assertTrue(MatrixFeatures_DDRM.isEquals((DMatrixD1)expected.getMomentOfInertia(), (DMatrixD1)actual.getMomentOfInertia()));
    }

    private static RobotDescription nextRobotDescription(Random random, String namePrefix, int numberOfJoints) {
        List<JointDescription> joints = RobotDescriptionTest.nextJointDescriptionTree(random, namePrefix, numberOfJoints);
        RobotDescriptionTest.addSensors(random, joints);
        RobotDescription next = new RobotDescription(namePrefix + "_robot");
        next.addRootJoint(joints.get(0));
        return next;
    }

    private static void addSensors(Random random, List<? extends JointDescription> jointDescriptions) {
        int n = 4;
        for (JointDescription jointDescription : jointDescriptions) {
            int i;
            if (jointDescriptions.size() > 1 && random.nextBoolean()) continue;
            String jointName = jointDescription.getName();
            if (random.nextBoolean()) {
                for (i = 0; i < random.nextInt(n); ++i) {
                    jointDescription.addKinematicPoint(RobotDescriptionTest.nextKinematicPointDescription(random, jointName + "_kp" + i));
                }
            }
            if (random.nextBoolean()) {
                for (i = 0; i < random.nextInt(n); ++i) {
                    jointDescription.addExternalForcePoint(RobotDescriptionTest.nextExternalForcePointDescription(random, jointName + "_efp" + i));
                }
            }
            if (random.nextBoolean()) {
                for (i = 0; i < random.nextInt(n); ++i) {
                    jointDescription.addGroundContactPoint(RobotDescriptionTest.nextGroundContactPointDescription(random, jointName + "_gcp" + i));
                }
            }
            if (random.nextBoolean()) {
                for (i = 0; i < random.nextInt(n); ++i) {
                    jointDescription.addJointWrenchSensor(RobotDescriptionTest.nextJointWrenchSensorDescription(random, jointName + "_jws" + i));
                }
            }
            if (random.nextBoolean()) {
                for (i = 0; i < random.nextInt(n); ++i) {
                    jointDescription.addCameraSensor(RobotDescriptionTest.nextCameraSensorDescription(random, jointName + "_cam" + i));
                }
            }
            if (random.nextBoolean()) {
                for (i = 0; i < random.nextInt(n); ++i) {
                    jointDescription.addIMUSensor(RobotDescriptionTest.nextIMUSensorDescription(random, jointName + "_imu" + i));
                }
            }
            if (random.nextBoolean()) {
                for (i = 0; i < random.nextInt(n); ++i) {
                    jointDescription.addLidarSensor(RobotDescriptionTest.nextLidarSensorDescription(random, jointName + "_lidar" + i));
                }
            }
            if (!random.nextBoolean()) continue;
            for (i = 0; i < random.nextInt(n); ++i) {
                jointDescription.addForceSensor(RobotDescriptionTest.nextForceSensorDescription(random, jointName + "_fs" + i));
            }
        }
    }

    private static List<JointDescription> nextJointDescriptionTree(Random random, String namePrefix, int numberOfJoints) {
        ArrayList<JointDescription> jointDescriptions = new ArrayList<JointDescription>();
        JointDescription parentJoint = null;
        int jointsRemaining = numberOfJoints;
        int branchCounter = 0;
        while (jointsRemaining > 0) {
            int branchSize = jointsRemaining == 1 ? 1 : random.nextInt(jointsRemaining - 1) + 1;
            List<JointDescription> branchJoints = RobotDescriptionTest.nextJointDescriptionChain(random, namePrefix + "_b" + branchCounter, branchSize);
            if (parentJoint != null) {
                parentJoint.addJoint(branchJoints.get(0));
            }
            jointDescriptions.addAll(branchJoints);
            parentJoint = (JointDescription)jointDescriptions.get(random.nextInt(jointDescriptions.size()));
            jointsRemaining -= branchSize;
            ++branchCounter;
        }
        return jointDescriptions;
    }

    private static List<JointDescription> nextJointDescriptionChain(Random random, String namePrefix, int numberOfJoints) {
        ArrayList<JointDescription> jointDescriptions = new ArrayList<JointDescription>();
        JointDescription parentJoint = null;
        for (int i = 0; i < numberOfJoints; ++i) {
            JointDescription joint = RobotDescriptionTest.nextJointDescription(random, namePrefix + "_j" + i);
            joint.setLink(RobotDescriptionTest.nextLinkDescription(random, namePrefix + "_l" + i));
            if (parentJoint != null) {
                parentJoint.addJoint(joint);
            }
            jointDescriptions.add(joint);
            parentJoint = joint;
        }
        return jointDescriptions;
    }

    private static JointDescription nextJointDescription(Random random, String name) {
        switch (random.nextInt(4)) {
            case 0: {
                return RobotDescriptionTest.nextFloatingJointDescription(random, name);
            }
            case 1: {
                return RobotDescriptionTest.nextFloatingPlanarJointDescription(random, name);
            }
            case 2: {
                return RobotDescriptionTest.nextPinJointDescription(random, name);
            }
        }
        return RobotDescriptionTest.nextSliderJointDescription(random, name);
    }

    private static FloatingJointDescription nextFloatingJointDescription(Random random, String name) {
        FloatingJointDescription next = new FloatingJointDescription(name, name + "VarName");
        next.setIsDynamic(random.nextBoolean());
        next.setOffsetFromParentJoint((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
        return next;
    }

    private static FloatingPlanarJointDescription nextFloatingPlanarJointDescription(Random random, String name) {
        FloatingPlanarJointDescription next = new FloatingPlanarJointDescription(name, Plane.values[random.nextInt(Plane.values.length)]);
        next.setIsDynamic(random.nextBoolean());
        next.setOffsetFromParentJoint((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
        return next;
    }

    private static PinJointDescription nextPinJointDescription(Random random, String name) {
        PinJointDescription next = new PinJointDescription(name, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextUnitVector3D((Random)random));
        next.setIsDynamic(random.nextBoolean());
        next.setVelocityLimits(EuclidCoreRandomTools.nextDouble((Random)random), EuclidCoreRandomTools.nextDouble((Random)random));
        next.setDamping(EuclidCoreRandomTools.nextDouble((Random)random));
        if (random.nextBoolean()) {
            next.setLimitStops(EuclidCoreRandomTools.nextDouble((Random)random, (double)(-Math.PI), (double)0.0), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)Math.PI), EuclidCoreRandomTools.nextDouble((Random)random), EuclidCoreRandomTools.nextDouble((Random)random));
        }
        next.setEffortLimit(EuclidCoreRandomTools.nextDouble((Random)random));
        return next;
    }

    private static SliderJointDescription nextSliderJointDescription(Random random, String name) {
        SliderJointDescription next = new SliderJointDescription(name, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextUnitVector3D((Random)random));
        next.setIsDynamic(random.nextBoolean());
        next.setVelocityLimits(EuclidCoreRandomTools.nextDouble((Random)random), EuclidCoreRandomTools.nextDouble((Random)random));
        next.setDamping(EuclidCoreRandomTools.nextDouble((Random)random));
        if (random.nextBoolean()) {
            next.setLimitStops(EuclidCoreRandomTools.nextDouble((Random)random, (double)(-Math.PI), (double)0.0), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)Math.PI), EuclidCoreRandomTools.nextDouble((Random)random), EuclidCoreRandomTools.nextDouble((Random)random));
        }
        next.setEffortLimit(EuclidCoreRandomTools.nextDouble((Random)random));
        return next;
    }

    private static LinkDescription nextLinkDescription(Random random, String name) {
        LinkDescription next = new LinkDescription(name);
        next.setLinkGraphics(RobotDescriptionTest.nextLinkGraphicsDescription(random));
        next.addCollisionMesh(RobotDescriptionTest.nextCollisionMeshDescription(random));
        next.setMass(random.nextDouble());
        next.setCenterOfMassOffset((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
        next.setMomentOfInertia((Matrix3DReadOnly)EuclidCoreRandomTools.nextMatrix3D((Random)random));
        return next;
    }

    private static LinkGraphicsDescription nextLinkGraphicsDescription(Random random) {
        LinkGraphicsDescription next = new LinkGraphicsDescription();
        int size = random.nextInt(5);
        for (int i = 0; i < size; ++i) {
            switch (random.nextInt(9)) {
                case 0: {
                    next.addCube(random.nextDouble(), random.nextDouble(), random.nextDouble(), YoAppearance.randomColor((Random)random));
                    break;
                }
                case 1: {
                    next.addWedge(random.nextDouble(), random.nextDouble(), random.nextDouble(), YoAppearance.randomColor((Random)random));
                    break;
                }
                case 2: {
                    next.addSphere(random.nextDouble(), YoAppearance.randomColor((Random)random));
                    break;
                }
                case 3: {
                    next.addCapsule(random.nextDouble(), random.nextDouble() + 2.0, YoAppearance.randomColor((Random)random));
                    break;
                }
                case 4: {
                    next.addEllipsoid(random.nextDouble(), random.nextDouble(), random.nextDouble(), YoAppearance.randomColor((Random)random));
                    break;
                }
                case 5: {
                    next.addCylinder(random.nextDouble(), random.nextDouble(), YoAppearance.randomColor((Random)random));
                    break;
                }
                case 6: {
                    next.addCone(random.nextDouble(), random.nextDouble(), YoAppearance.randomColor((Random)random));
                    break;
                }
                case 7: {
                    next.addGenTruncatedCone(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), YoAppearance.randomColor((Random)random));
                    break;
                }
            }
            next.translate((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
            next.rotate((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
        }
        return next;
    }

    private static CollisionMeshDescription nextCollisionMeshDescription(Random random) {
        CollisionMeshDescription next = new CollisionMeshDescription();
        int size = random.nextInt(5);
        block5: for (int i = 0; i < size; ++i) {
            switch (random.nextInt(4)) {
                case 0: {
                    next.addSphere(random.nextDouble());
                    continue block5;
                }
                case 1: {
                    next.addCapsule(random.nextDouble(), EuclidGeometryRandomTools.nextLineSegment3D((Random)random));
                    continue block5;
                }
                case 2: {
                    next.addCubeReferencedAtBottomMiddle(random.nextDouble(), random.nextDouble(), random.nextDouble());
                    continue block5;
                }
                default: {
                    next.addCylinderReferencedAtBottomMiddle(random.nextDouble(), random.nextDouble());
                }
            }
        }
        return next;
    }

    private static KinematicPointDescription nextKinematicPointDescription(Random random, String name) {
        return new KinematicPointDescription(name, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
    }

    private static ExternalForcePointDescription nextExternalForcePointDescription(Random random, String name) {
        return new ExternalForcePointDescription(name, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
    }

    private static GroundContactPointDescription nextGroundContactPointDescription(Random random, String name) {
        return new GroundContactPointDescription(name, EuclidCoreRandomTools.nextVector3D((Random)random), random.nextInt(20));
    }

    private static JointWrenchSensorDescription nextJointWrenchSensorDescription(Random random, String name) {
        return new JointWrenchSensorDescription(name, EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
    }

    private static CameraSensorDescription nextCameraSensorDescription(Random random, String name) {
        CameraSensorDescription next = new CameraSensorDescription(name, (RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)360.0), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)100.0));
        next.setImageHeight(random.nextInt(1024));
        next.setImageWidth(random.nextInt(1024));
        return next;
    }

    private static IMUSensorDescription nextIMUSensorDescription(Random random, String name) {
        IMUSensorDescription next = new IMUSensorDescription(name, EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
        next.setAccelerationNoiseParameters(random.nextDouble(), random.nextDouble());
        next.setAccelerationBiasParameters(random.nextDouble(), random.nextDouble());
        next.setAngularVelocityNoiseParameters(random.nextDouble(), random.nextDouble());
        next.setAngularVelocityBiasParameters(random.nextDouble(), random.nextDouble());
        return next;
    }

    private static LidarSensorDescription nextLidarSensorDescription(Random random, String name) {
        LidarSensorDescription next = new LidarSensorDescription(name, (RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
        next.setSweepYawLimits(EuclidCoreRandomTools.nextDouble((Random)random, (double)-180.0, (double)0.0), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)180.0));
        next.setHeightPitchLimits(EuclidCoreRandomTools.nextDouble((Random)random, (double)-180.0, (double)0.0), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)180.0));
        next.setRangeLimits(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)100.0));
        next.setPointsPerSweep(random.nextInt(100000));
        next.setScanHeight(random.nextInt(10));
        return next;
    }

    private static ForceSensorDescription nextForceSensorDescription(Random random, String name) {
        ForceSensorDescription next = new ForceSensorDescription(name, EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
        next.setUseGroundContactPoints(random.nextBoolean());
        next.setUseShapeCollision(random.nextBoolean());
        return next;
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForPackage(RobotDescriptionTest.class);
    }
}

