/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotDescription;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.robotDescription.InertiaTools;

public class InertiaToolsTest {
    private static final int ITERATIONS = 1000;
    private static final double DELTA = 0.001;

    @Test
    public void testGetInertiaEllipsoidRadii() {
        Random random = new Random();
        double maxRandomValue = 1000.0;
        for (int i = 0; i < 1000; ++i) {
            double mass = maxRandomValue * random.nextDouble();
            double xRadius = maxRandomValue * random.nextDouble();
            double yRadius = maxRandomValue * random.nextDouble();
            double zRadius = maxRandomValue * random.nextDouble();
            Matrix3D rotationalInertia = InertiaToolsTest.getRotationalInertiaMatrixOfSolidEllipsoid(mass, xRadius, yRadius, zRadius);
            Vector3D principalMomentsOfInertia = new Vector3D(rotationalInertia.getM00(), rotationalInertia.getM11(), rotationalInertia.getM22());
            Vector3D ellipsoidRadii = InertiaTools.getInertiaEllipsoidRadii((Vector3D)principalMomentsOfInertia, (double)mass);
            Assert.assertEquals(xRadius, ellipsoidRadii.getX(), 0.001);
            Assert.assertEquals(yRadius, ellipsoidRadii.getY(), 0.001);
            Assert.assertEquals(zRadius, ellipsoidRadii.getZ(), 0.001);
        }
    }

    @Test
    public void testRotations() {
        double epsilon = 1.0E-7;
        Random random = new Random();
        double maxRandomValue = 1.0;
        for (int i = 0; i < 1000; ++i) {
            double mass = maxRandomValue * random.nextDouble();
            double xRadius = maxRandomValue * random.nextDouble();
            double yRadius = maxRandomValue * random.nextDouble();
            double zRadius = maxRandomValue * random.nextDouble();
            Matrix3D rotationalInertia = InertiaToolsTest.getRotationalInertiaMatrixOfSolidEllipsoid(mass, xRadius, yRadius, zRadius);
            Matrix3D rotationalInertiaCopy = new Matrix3D((Matrix3DReadOnly)rotationalInertia);
            RotationMatrix inertialFrameRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Matrix3D rotatedInertia = InertiaTools.rotate((RotationMatrix)inertialFrameRotation, (Matrix3D)rotationalInertiaCopy);
            RotationMatrix principalAxesAfterRotation = new RotationMatrix();
            Vector3D principalMomentsOfInertiaAfterRotation = new Vector3D();
            InertiaTools.computePrincipalMomentsOfInertia((Matrix3D)rotatedInertia, (RotationMatrix)principalAxesAfterRotation, (Vector3D)principalMomentsOfInertiaAfterRotation);
            ArrayList<Double> principleMomentsBeforeRotation = new ArrayList<Double>();
            principleMomentsBeforeRotation.add(rotationalInertia.getM00());
            principleMomentsBeforeRotation.add(rotationalInertia.getM11());
            principleMomentsBeforeRotation.add(rotationalInertia.getM22());
            ArrayList<Double> principleMomentsAfterRotation = new ArrayList<Double>();
            principleMomentsAfterRotation.add(principalMomentsOfInertiaAfterRotation.getX());
            principleMomentsAfterRotation.add(principalMomentsOfInertiaAfterRotation.getY());
            principleMomentsAfterRotation.add(principalMomentsOfInertiaAfterRotation.getZ());
            Collections.sort(principleMomentsBeforeRotation);
            Collections.sort(principleMomentsAfterRotation);
            Assert.assertEquals((Double)principleMomentsBeforeRotation.get(0), (Double)principleMomentsAfterRotation.get(0), epsilon);
            Assert.assertEquals((Double)principleMomentsBeforeRotation.get(1), (Double)principleMomentsAfterRotation.get(1), epsilon);
            Assert.assertEquals((Double)principleMomentsBeforeRotation.get(2), (Double)principleMomentsAfterRotation.get(2), epsilon);
            Matrix3D inertiaAboutPrincipalAxes = new Matrix3D();
            inertiaAboutPrincipalAxes.setM00(principalMomentsOfInertiaAfterRotation.getX());
            inertiaAboutPrincipalAxes.setM11(principalMomentsOfInertiaAfterRotation.getY());
            inertiaAboutPrincipalAxes.setM22(principalMomentsOfInertiaAfterRotation.getZ());
            Matrix3D rotatedInertiaAgain = InertiaTools.rotate((RotationMatrix)principalAxesAfterRotation, (Matrix3D)inertiaAboutPrincipalAxes);
            Assert.assertTrue(rotatedInertiaAgain.epsilonEquals((EuclidGeometry)rotatedInertia, epsilon));
        }
    }

    public static Matrix3D getRotationalInertiaMatrixOfSolidEllipsoid(double mass, double xRadius, double yRadius, double zRadius) {
        double ixx = 0.2 * mass * (yRadius * yRadius + zRadius * zRadius);
        double iyy = 0.2 * mass * (zRadius * zRadius + xRadius * xRadius);
        double izz = 0.2 * mass * (xRadius * xRadius + yRadius * yRadius);
        Matrix3D ret = new Matrix3D();
        ret.setM00(ixx);
        ret.setM11(iyy);
        ret.setM22(izz);
        return ret;
    }
}

